/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data;

import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CauseOfTransmission;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataListener;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataModuleMessageSource;

public class DataListenerImpl
implements DataListener {
    private final CauseOfTransmission cause;
    private final DataModuleMessageSource source;

    public DataListenerImpl(DataModuleMessageSource source, CauseOfTransmission cause) {
        this.source = source;
        this.cause = cause;
    }

    @Override
    public void dataChangeBoolean(ASDUAddress asduAddress, InformationObjectAddress startAddress, List<Value<Boolean>> values) {
        this.source.sendBooleanValues(new ASDUHeader(this.cause, asduAddress), startAddress, values);
    }

    @Override
    public void dataChangeBoolean(ASDUAddress asduAddress, List<InformationEntry<Boolean>> values) {
        this.source.sendBooleanValues(new ASDUHeader(this.cause, asduAddress), values);
    }

    @Override
    public void dataChangeFloat(ASDUAddress asduAddress, InformationObjectAddress startAddress, List<Value<Float>> values) {
        this.source.sendFloatValues(new ASDUHeader(this.cause, asduAddress), startAddress, values);
    }

    @Override
    public void dataChangeFloat(ASDUAddress asduAddress, List<InformationEntry<Float>> values) {
        this.source.sendFloatValues(new ASDUHeader(this.cause, asduAddress), values);
    }

    @Override
    public void dataChangeShort(ASDUAddress asduAddress, InformationObjectAddress startAddress, List<Value<Short>> values) {
        this.source.sendShortValues(new ASDUHeader(this.cause, asduAddress), startAddress, values);
    }

    @Override
    public void dataChangeShort(ASDUAddress asduAddress, List<InformationEntry<Short>> values) {
        this.source.sendShortValues(new ASDUHeader(this.cause, asduAddress), values);
    }
}

