/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.script;

import java.util.concurrent.Callable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public final class Scripts {
    private Scripts() {
    }

    public static ScriptEngineManager createManager(ClassLoader contextClassLoader) {
        try {
            return Scripts.executeWithClassLoader(contextClassLoader, new Callable<ScriptEngineManager>(){

                @Override
                public ScriptEngineManager call() {
                    return new ScriptEngineManager(null);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ScriptEngine createEngine(String engineName, ClassLoader scriptClassLoader) throws Exception {
        return Scripts.createEngine(Scripts.createManager(scriptClassLoader), engineName, scriptClassLoader);
    }

    public static ScriptEngine createEngine(final ScriptEngineManager engineManager, final String engineName, ClassLoader scriptClassLoader) throws Exception {
        if (engineManager == null) {
            throw new IllegalArgumentException("Script engine manager must not be null");
        }
        if (engineName == null) {
            return null;
        }
        ScriptEngine engine = Scripts.executeWithClassLoader(scriptClassLoader, new Callable<ScriptEngine>(){

            @Override
            public ScriptEngine call() throws Exception {
                return engineManager.getEngineByName(engineName);
            }
        });
        if (engine == null) {
            throw new ScriptException(String.format("Script engine '%s' could not be found", engineName));
        }
        return engine;
    }

    public static <V> V executeWithClassLoader(ClassLoader classLoader, Callable<V> callable) throws Exception {
        if (classLoader == null) {
            return callable.call();
        }
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            V v = callable.call();
            return v;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcl);
        }
    }
}

