/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.iec60870.BaseOptions;
import org.apache.camel.component.iec60870.ConnectionId;
import org.apache.camel.component.iec60870.ObjectAddress;
import org.apache.camel.component.iec60870.client.ClientOptions;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIecComponent<T1, T2 extends BaseOptions<T2>>
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIecComponent.class);
    private final Map<ConnectionId, T1> connections = new HashMap<ConnectionId, T1>();
    private final Class<T2> connectionOptionsClazz;
    private T2 defaultConnectionOptions;

    protected AbstractIecComponent(Class<T2> connectionOptionsClazz, T2 defaultConnectionOptions) {
        this.connectionOptionsClazz = connectionOptionsClazz;
        this.defaultConnectionOptions = defaultConnectionOptions;
    }

    protected AbstractIecComponent(Class<T2> connectionOptionsClazz, T2 defaultConnectionOptions, CamelContext context) {
        super(context);
        this.connectionOptionsClazz = connectionOptionsClazz;
        this.defaultConnectionOptions = defaultConnectionOptions;
    }

    protected abstract T1 createConnection(ConnectionId var1, T2 var2);

    @Metadata
    protected void setDefaultConnectionOptions(T2 defaultConnectionOptions) {
        this.defaultConnectionOptions = (BaseOptions)Objects.requireNonNull(defaultConnectionOptions);
    }

    protected T2 getDefaultConnectionOptions() {
        return this.defaultConnectionOptions;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        LOG.debug("Create endpoint - uri: {}, remaining: {}, parameters: {}", new Object[]{uri, remaining, parameters});
        T1 connection = this.lookupConnection(uri, parameters);
        ObjectAddress address = AbstractIecComponent.parseAddress(uri);
        return this.createEndpoint(uri, connection, address);
    }

    protected abstract Endpoint createEndpoint(String var1, T1 var2, ObjectAddress var3);

    protected T2 parseOptions(Map<String, Object> parameters) throws Exception {
        Object connectionOptions = parameters.get("connectionOptions");
        if (connectionOptions != null) {
            try {
                return (T2)((BaseOptions)this.connectionOptionsClazz.cast(connectionOptions));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("'%s' must by of type %s", "connectionOptions", ClientOptions.class.getName()), e);
            }
        }
        Object options = ((BaseOptions)this.defaultConnectionOptions).copy();
        if (parameters.get("protocolOptions") instanceof ProtocolOptions) {
            ((BaseOptions)options).setProtocolOptions((ProtocolOptions)parameters.get("protocolOptions"));
        }
        this.applyDataModuleOptions(options, parameters);
        this.setProperties(options, parameters);
        return (T2)options;
    }

    protected abstract void applyDataModuleOptions(T2 var1, Map<String, Object> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T1 lookupConnection(String fullUri, Map<String, Object> parameters) throws Exception {
        LOG.debug("parse connection - '{}'", (Object)fullUri);
        if (fullUri == null || fullUri.isEmpty()) {
            throw new IllegalArgumentException("Invalid URI: " + fullUri);
        }
        ConnectionId id = AbstractIecComponent.parseConnectionId(fullUri, parameters);
        LOG.debug("parse connection - fullUri: {} -> {}", (Object)fullUri, (Object)id);
        this.lock.lock();
        try {
            LOG.debug("Locating connection - {}", (Object)id);
            T1 connection = this.connections.get(id);
            LOG.debug("Result - {} -> {}", (Object)id, connection);
            if (connection == null) {
                T2 options = this.parseOptions(parameters);
                LOG.debug("Creating new connection: {}", options);
                connection = this.createConnection(id, options);
                this.connections.put(id, connection);
            }
            T1 T1 = connection;
            return T1;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static ConnectionId parseConnectionId(String fullUri, Map<String, Object> parameters) {
        URI uri = URI.create(fullUri);
        Object connectionId = parameters.get("connectionId");
        return new ConnectionId(uri.getHost(), uri.getPort(), connectionId instanceof String ? (String)connectionId : null);
    }

    private static ObjectAddress parseAddress(String fullUri) {
        URI uri = URI.create(fullUri);
        String path = uri.getPath();
        path = path.replaceAll("^\\/+", "");
        return ObjectAddress.valueOf(path);
    }
}

