/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;

public class ASDUAddress {
    public static final ASDUAddress BROADCAST = new ASDUAddress(65535);
    private final int address;

    private ASDUAddress(int address) {
        this.address = address;
    }

    public int getAddress() {
        return this.address;
    }

    public void encode(ProtocolOptions options, ByteBuf out) {
        options.getAdsuAddressType().write(this.address, out);
    }

    public boolean isBroadcast() {
        return this.address == 65535;
    }

    public static ASDUAddress parse(ProtocolOptions options, ByteBuf data) {
        return new ASDUAddress(options.getAdsuAddressType().read(data));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.address;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ASDUAddress other = (ASDUAddress)obj;
        return this.address == other.address;
    }

    public String toString() {
        int[] add = this.toArray();
        return this.isBroadcast() ? "[BCAST]" : String.format("[%d-%d # %d]", add[0], add[1], this.address);
    }

    public int[] toArray() {
        ByteBuf buf = Unpooled.buffer(2);
        buf.writeShort(this.address);
        return new int[]{buf.getUnsignedByte(0), buf.getUnsignedByte(1)};
    }

    public static ASDUAddress fromArray(int[] data) {
        if (data.length > 2) {
            throw new IllegalArgumentException("Address may only have a maximum of 2 segments");
        }
        int address = 0;
        int[] nArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            address = address << 8 | i;
            ++n2;
        }
        return ASDUAddress.valueOf(address);
    }

    public static ASDUAddress fromString(String value) {
        int address = 0;
        String[] stringArray = value.split("-");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            address = address << 8 | Integer.parseInt(tok);
            ++n2;
        }
        return ASDUAddress.valueOf(address);
    }

    public static ASDUAddress valueOf(int address) {
        if (address < 0) {
            throw new IllegalArgumentException("'adddress' must not be negative");
        }
        if (address > 65535) {
            throw new IllegalArgumentException("'adddress' must be below or equal to 0xFFFF");
        }
        return new ASDUAddress(address);
    }
}

