/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.str;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.scada.utils.str.ExtendedPropertiesReplacer;

public class StringReplacer {
    public static final Pattern DEFAULT_PATTERN = Pattern.compile("\\$\\{([^{}]*?)\\}");

    public static String replace(String string, Map<?, ?> properties) {
        return StringReplacer.replace(string, StringReplacer.newSource(properties), DEFAULT_PATTERN);
    }

    public static ReplaceSource newSource(final Map<?, ?> properties) {
        return new ReplaceSource(){

            @Override
            public String replace(String context, String key) {
                Object result = properties.get(key);
                if (result == null) {
                    return context;
                }
                return result.toString();
            }
        };
    }

    public static ReplaceSource newExtendedSource(Map<?, ?> properties) {
        return new ExtendedPropertiesReplacer(properties);
    }

    public static ReplaceSource newBeansSource(final Map<?, ?> properties) {
        return new ReplaceSource(){

            @Override
            public String replace(String context, String key) {
                String result = null;
                try {
                    result = BeanUtils.getProperty((Object)properties, (String)key);
                }
                catch (Exception exception) {}
                if (result != null) {
                    return result;
                }
                return context;
            }
        };
    }

    public static String replace(String string, ReplaceSource replaceSource, Pattern pattern, boolean nested) {
        if (string == null) {
            return null;
        }
        Matcher m4 = pattern.matcher(string);
        boolean result = m4.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                String key = m4.groupCount() > 0 ? m4.group(1) : null;
                String replacement = replaceSource.replace(m4.group(0), key);
                if (replacement == null) {
                    m4.appendReplacement(sb, "");
                    continue;
                }
                replacement = replacement.replace("\\", "\\\\").replace("$", "\\$");
                m4.appendReplacement(sb, replacement);
            } while (result = m4.find());
            m4.appendTail(sb);
            String resultString = sb.toString();
            if (nested && !string.equals(resultString)) {
                return StringReplacer.replace(resultString, replaceSource, pattern, true);
            }
            return resultString;
        }
        return string;
    }

    public static String replace(String string, ReplaceSource replaceSource, Pattern pattern) {
        return StringReplacer.replace(string, replaceSource, pattern, true);
    }

    public static interface ReplaceSource {
        public String replace(String var1, String var2);
    }
}

