/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.set;

import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ignite.AbstractIgniteEndpoint;
import org.apache.camel.component.ignite.IgniteConstants;
import org.apache.camel.component.ignite.set.IgniteSetComponent;
import org.apache.camel.component.ignite.set.IgniteSetOperation;
import org.apache.camel.component.ignite.set.IgniteSetProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.PropertiesHelper;
import org.apache.ignite.configuration.CollectionConfiguration;

@UriEndpoint(firstVersion="2.17.0", scheme="ignite-set", title="Ignite Sets", syntax="ignite-set:name", category={Category.CACHE, Category.CLUSTERING}, producerOnly=true, headersClass=IgniteConstants.class)
public class IgniteSetEndpoint
extends AbstractIgniteEndpoint {
    @UriPath
    @Metadata(required=true)
    private String name;
    @UriParam(label="producer")
    private CollectionConfiguration configuration = new CollectionConfiguration();
    @UriParam(label="producer")
    private IgniteSetOperation operation;

    public IgniteSetEndpoint(String endpointUri, String remaining, Map<String, Object> parameters, IgniteSetComponent igniteComponent) {
        super(endpointUri, igniteComponent);
        this.name = remaining;
        if (!parameters.containsKey("configuration")) {
            Map<String, Object> configProps = PropertiesHelper.extractProperties(parameters, "config.");
            PropertyBindingSupport.bindProperties(this.getCamelContext(), parameters, configProps);
        }
    }

    @Override
    public Producer createProducer() throws Exception {
        return new IgniteSetProducer(this, this.ignite().set(this.name, this.configuration));
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("The Ignite Sets endpoint doesn't support consumers.");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CollectionConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CollectionConfiguration configuration) {
        this.configuration = configuration;
    }

    public IgniteSetOperation getOperation() {
        return this.operation;
    }

    public void setOperation(IgniteSetOperation operation) {
        this.operation = operation;
    }
}

