/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.DefaultHeaderFilterStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class DefaultHeaderFilterStrategyConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        DefaultHeaderFilterStrategy target = (DefaultHeaderFilterStrategy)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allownullvalues": 
            case "allowNullValues": {
                target.setAllowNullValues(DefaultHeaderFilterStrategyConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "caseinsensitive": 
            case "caseInsensitive": {
                target.setCaseInsensitive(DefaultHeaderFilterStrategyConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "filteronmatch": 
            case "filterOnMatch": {
                target.setFilterOnMatch(DefaultHeaderFilterStrategyConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "infilter": 
            case "inFilter": {
                target.setInFilter(DefaultHeaderFilterStrategyConfigurer.property(camelContext, Set.class, value));
                return true;
            }
            case "lowercase": 
            case "lowerCase": {
                target.setLowerCase(DefaultHeaderFilterStrategyConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "outfilter": 
            case "outFilter": {
                target.setOutFilter(DefaultHeaderFilterStrategyConfigurer.property(camelContext, Set.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allownullvalues": 
            case "allowNullValues": {
                return Boolean.TYPE;
            }
            case "caseinsensitive": 
            case "caseInsensitive": {
                return Boolean.TYPE;
            }
            case "filteronmatch": 
            case "filterOnMatch": {
                return Boolean.TYPE;
            }
            case "infilter": 
            case "inFilter": {
                return Set.class;
            }
            case "lowercase": 
            case "lowerCase": {
                return Boolean.TYPE;
            }
            case "outfilter": 
            case "outFilter": {
                return Set.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        DefaultHeaderFilterStrategy target = (DefaultHeaderFilterStrategy)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allownullvalues": 
            case "allowNullValues": {
                return target.isAllowNullValues();
            }
            case "caseinsensitive": 
            case "caseInsensitive": {
                return target.isCaseInsensitive();
            }
            case "filteronmatch": 
            case "filterOnMatch": {
                return target.isFilterOnMatch();
            }
            case "infilter": 
            case "inFilter": {
                return target.getInFilter();
            }
            case "lowercase": 
            case "lowerCase": {
                return target.isLowerCase();
            }
            case "outfilter": 
            case "outFilter": {
                return target.getOutFilter();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "infilter": 
            case "inFilter": {
                return String.class;
            }
            case "outfilter": 
            case "outFilter": {
                return String.class;
            }
        }
        return null;
    }
}

