/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache.scan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.internal.management.cache.scan.CacheScanCommandArg;
import org.apache.ignite.internal.management.cache.scan.CacheScanTaskFormat;
import org.apache.ignite.internal.management.cache.scan.CacheScanTaskResult;
import org.apache.ignite.internal.management.cache.scan.DefaultCacheScanTaskFormat;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.plugin.security.SecurityPermissionSetBuilder;

@GridInternal
public class CacheScanTask
extends VisorOneNodeTask<CacheScanCommandArg, CacheScanTaskResult> {
    private static final long serialVersionUID = 0L;

    protected CacheScanJob job(CacheScanCommandArg arg) {
        return new CacheScanJob(arg, this.debug);
    }

    private static CacheScanTaskFormat format(String format) {
        if (format == null) {
            return new DefaultCacheScanTaskFormat();
        }
        Iterable<CacheScanTaskFormat> formats = U.loadService(CacheScanTaskFormat.class);
        for (CacheScanTaskFormat f : formats) {
            if (!f.name().equals(format)) continue;
            return f;
        }
        throw new IllegalStateException("Unknown format: " + format);
    }

    private static class CacheScanJob
    extends VisorJob<CacheScanCommandArg, CacheScanTaskResult> {
        private static final long serialVersionUID = 0L;

        private CacheScanJob(CacheScanCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected CacheScanTaskResult run(CacheScanCommandArg arg) {
            if (F.isEmpty(arg.cacheName())) {
                throw new IllegalStateException("Cache name was not specified.");
            }
            if (arg.limit() <= 0) {
                throw new IllegalStateException("Invalid limit value.");
            }
            IgniteCache cache = this.ignite.cache(arg.cacheName()).withKeepBinary();
            int cnt = 0;
            ArrayList entries = new ArrayList();
            CacheScanTaskFormat format = CacheScanTask.format(arg.outputFormat());
            List<String> titles = Collections.emptyList();
            Query scanQry = new ScanQuery().setPageSize(Math.min(arg.limit(), 1024));
            try (QueryCursor qry = cache.query(scanQry);){
                Iterator iter = qry.iterator();
                if (cnt++ < arg.limit() && iter.hasNext()) {
                    Cache.Entry first = (Cache.Entry)iter.next();
                    titles = format.titles(first);
                    entries.add(format.row(first));
                }
                while (cnt++ < arg.limit() && iter.hasNext()) {
                    entries.add(format.row((Cache.Entry)iter.next()));
                }
            }
            return new CacheScanTaskResult(titles, entries);
        }

        @Override
        public SecurityPermissionSet requiredPermissions() {
            return SecurityPermissionSetBuilder.NO_PERMISSIONS;
        }

        public String toString() {
            return S.toString(CacheScanJob.class, this);
        }
    }
}

