/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import javax.management.MBeanServer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.eviction.EvictionFilter;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheEvictionManager;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionManager;
import org.apache.ignite.internal.util.GridBusyLock;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.mxbean.IgniteMBeanAware;
import org.jetbrains.annotations.Nullable;

public class GridCacheEvictionManager
extends GridCacheManagerAdapter
implements CacheEvictionManager {
    private EvictionPolicy plc;
    private EvictionFilter filter;
    private boolean plcEnabled;
    private final GridBusyLock busyLock = new GridBusyLock();
    private boolean stopped;
    private volatile boolean firstEvictWarn;

    @Override
    public void start0() throws IgniteCheckedException {
        CacheConfiguration cfg = this.cctx.config();
        this.plc = this.cctx.isNear() ? (cfg.getNearConfiguration().getNearEvictionPolicyFactory() != null ? cfg.getNearConfiguration().getNearEvictionPolicyFactory().create() : cfg.getNearConfiguration().getNearEvictionPolicy()) : (cfg.getEvictionPolicyFactory() != null ? cfg.getEvictionPolicyFactory().create() : cfg.getEvictionPolicy());
        boolean bl = this.plcEnabled = this.plc != null;
        if (this.plcEnabled) {
            this.prepare(cfg, this.plc, this.cctx.isNear());
        }
        this.filter = cfg.getEvictionFilter();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Eviction manager started on node: " + this.cctx.nodeId());
        }
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        super.onKernalStop0(cancel);
        this.busyLock.block();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Eviction manager stopped on node: " + this.cctx.nodeId());
            }
        }
        finally {
            this.stopped = true;
            this.busyLock.unblock();
        }
    }

    private boolean enterBusy() {
        if (!this.busyLock.enterBusy()) {
            return false;
        }
        if (this.stopped) {
            this.busyLock.leaveBusy();
            return false;
        }
        return true;
    }

    private boolean evict0(GridCacheAdapter cache, GridCacheEntryEx entry, GridCacheVersion obsoleteVer, @Nullable CacheEntryPredicate[] filter, boolean explicit) throws IgniteCheckedException {
        assert (cache != null);
        assert (entry != null);
        assert (obsoleteVer != null);
        boolean recordable = this.cctx.events().isRecordable(62);
        CacheObject oldVal = recordable ? entry.rawGet() : null;
        boolean hasVal = recordable && entry.hasValue();
        boolean evicted = entry.evictInternal(obsoleteVer, filter, false);
        if (evicted) {
            if (explicit && this.plcEnabled) {
                this.notifyPolicy(entry);
            }
            cache.removeEntry(entry);
            if (this.cctx.statisticsEnabled()) {
                cache.metrics0().onEvict();
            }
            if (recordable) {
                this.cctx.events().addEvent(entry.partition(), entry.key(), this.cctx.nodeId(), null, null, null, 62, null, false, oldVal, hasVal, null, null, false);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Entry was evicted [entry=" + entry + ", localNode=" + this.cctx.nodeId() + "]");
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Entry was not evicted [entry=" + entry + ", localNode=" + this.cctx.nodeId() + "]");
        }
        return evicted;
    }

    @Override
    public void touch(IgniteTxEntry txEntry, boolean loc) {
        assert (txEntry.context() == this.cctx) : "Entry from another cache context passed to eviction manager: [entry=" + txEntry + ", cctx=" + this.cctx + ", entryCtx=" + txEntry.context() + "]";
        if (!this.plcEnabled) {
            return;
        }
        if (!loc && this.cctx.isNear()) {
            return;
        }
        GridCacheEntryEx e = txEntry.cached();
        if (e.detached() || e.isInternal()) {
            return;
        }
        try {
            if (e.markObsoleteIfEmpty(null) || e.obsolete()) {
                e.context().cache().removeEntry(e);
            }
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Failed to evict entry from cache: " + e, ex);
        }
        this.notifyPolicy(e);
    }

    @Override
    public void touch(GridCacheEntryEx e) {
        assert (e.context() == this.cctx) : "Entry from another cache context passed to eviction manager: [entry=" + e + ", cctx=" + this.cctx + ", entryCtx=" + e.context() + "]";
        if (e.detached() || e.isInternal()) {
            return;
        }
        try {
            if (e.markObsoleteIfEmpty(null) || e.obsolete()) {
                e.context().cache().removeEntry(e);
            }
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Failed to evict entry from cache: " + e, ex);
        }
        if (!this.plcEnabled) {
            return;
        }
        if (!this.enterBusy()) {
            return;
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Touching entry [entry=" + e + ", localNode=" + this.cctx.nodeId() + "]");
            }
            this.notifyPolicy(e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void warnFirstEvict() {
        GridCacheEvictionManager gridCacheEvictionManager = this;
        synchronized (gridCacheEvictionManager) {
            if (this.firstEvictWarn) {
                return;
            }
            this.firstEvictWarn = true;
        }
        U.warn(this.log, "Evictions started (cache may have reached its capacity). You may wish to increase 'maxSize' on eviction policy being used for cache: " + this.cctx.name());
    }

    @Override
    public boolean evict(@Nullable GridCacheEntryEx entry, @Nullable GridCacheVersion obsoleteVer, boolean explicit, @Nullable CacheEntryPredicate[] filter) throws IgniteCheckedException {
        assert (entry == null || entry.context() == this.cctx) : "Entry from another cache context passed to eviction manager: [entry=" + entry + ", cctx=" + this.cctx + ", entryCtx=" + entry.context() + "]";
        if (entry == null) {
            return true;
        }
        if (entry.key() instanceof GridCacheInternal) {
            return false;
        }
        if (!(this.cctx.isNear() || explicit || this.firstEvictWarn)) {
            this.warnFirstEvict();
        }
        if (obsoleteVer == null) {
            obsoleteVer = this.cctx.cache().nextVersion();
        }
        return this.evict0(this.cctx.cache(), entry, obsoleteVer, filter, explicit);
    }

    @Override
    public void batchEvict(Collection<?> keys, @Nullable GridCacheVersion obsoleteVer) throws IgniteCheckedException {
        boolean recordable = this.cctx.events().isRecordable(62);
        GridCacheAdapter cache = this.cctx.cache();
        for (Object k : keys) {
            KeyCacheObject cacheKey = this.cctx.toCacheKeyObject(k);
            GridCacheEntryEx entry = cache.peekEx(cacheKey);
            if (entry == null || !entry.evictInternal(GridCacheVersionManager.EVICT_VER, null, false)) continue;
            if (this.plcEnabled) {
                this.notifyPolicy(entry);
            }
            if (!recordable) continue;
            this.cctx.events().addEvent(entry.partition(), entry.key(), this.cctx.nodeId(), null, null, null, 62, null, false, entry.rawGet(), entry.hasValue(), null, null, false);
        }
    }

    private void notifyPolicy(GridCacheEntryEx e) {
        assert (this.plcEnabled);
        assert (this.plc != null);
        assert (!e.isInternal()) : "Invalid entry for policy notification: " + e;
        assert (e.context() == this.cctx) : "Entry from another cache context passed to eviction manager: [entry=" + e + ", cctx=" + this.cctx + ", entryCtx=" + e.context() + "]";
        if (this.log.isDebugEnabled()) {
            this.log.debug("Notifying eviction policy with entry: " + e);
        }
        if (this.filter == null || this.filter.evictAllowed(e.wrapLazyValue(this.cctx.keepBinary()))) {
            try {
                this.plc.onEntryAccessed(e.obsoleteOrDeleted(), e.wrapEviction());
            }
            catch (RuntimeException ex) {
                if (!e.obsoleteOrDeleted()) {
                    try {
                        this.plc.onEntryAccessed(true, e.wrapEviction());
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    e.wrapEviction().evict();
                }
                LT.warn(this.log, "The cache entry cannot be touched [entry=" + e + ", err=" + ex + "]");
            }
        }
    }

    @Override
    public void printMemoryStats() {
        X.println(">>> ", new Object[0]);
        X.println(">>> Eviction manager memory stats [igniteInstanceName=" + this.cctx.igniteInstanceName() + ", cache=" + this.cctx.name() + "]", new Object[0]);
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.plc;
    }

    private void prepare(CacheConfiguration cfg, @Nullable Object rsrc, boolean near) throws IgniteCheckedException {
        this.cctx.kernalContext().resource().injectGeneric(rsrc);
        this.cctx.kernalContext().resource().injectCacheName(rsrc, cfg.getName());
        this.registerMbean(rsrc, cfg.getName(), near);
    }

    private void registerMbean(Object obj, @Nullable String cacheName, boolean near) throws IgniteCheckedException {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        assert (obj != null);
        MBeanServer srvr = this.cctx.kernalContext().config().getMBeanServer();
        assert (srvr != null);
        cacheName = U.maskName((String)cacheName);
        cacheName = near ? (String)cacheName + "-near" : cacheName;
        Object mbeanImpl = obj instanceof IgniteMBeanAware ? ((IgniteMBeanAware)obj).getMBean() : obj;
        for (Class<?> itf : mbeanImpl.getClass().getInterfaces()) {
            if (!itf.getName().endsWith("MBean") && !itf.getName().endsWith("MXBean")) continue;
            try {
                U.registerMBean(srvr, this.cctx.kernalContext().igniteInstanceName(), (String)cacheName, obj.getClass().getName(), mbeanImpl, itf);
                break;
            }
            catch (Throwable e) {
                throw new IgniteCheckedException("Failed to register MBean for component: " + obj, e);
            }
        }
    }

    @Override
    protected void stop0(boolean cancel, boolean destroy) {
        this.cleanup(this.cctx.config(), this.plc, this.cctx.isNear());
    }

    void cleanup(CacheConfiguration cfg, @Nullable Object rsrc, boolean near) {
        if (rsrc != null) {
            this.unregisterMbean(rsrc, cfg.getName(), near);
            try {
                this.cctx.kernalContext().resource().cleanupGeneric(rsrc);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to cleanup resource: " + rsrc, e);
            }
        }
    }

    private void unregisterMbean(Object o, @Nullable String cacheName, boolean near) {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        assert (o != null);
        MBeanServer srvr = this.cctx.kernalContext().config().getMBeanServer();
        assert (srvr != null);
        cacheName = U.maskName((String)cacheName);
        cacheName = near ? (String)cacheName + "-near" : cacheName;
        boolean needToUnregister = o instanceof IgniteMBeanAware;
        if (!needToUnregister) {
            for (Class<?> itf : o.getClass().getInterfaces()) {
                if (!itf.getName().endsWith("MBean") && !itf.getName().endsWith("MXBean")) continue;
                needToUnregister = true;
                break;
            }
        }
        if (needToUnregister) {
            try {
                srvr.unregisterMBean(U.makeMBeanName(this.cctx.kernalContext().igniteInstanceName(), (String)cacheName, o.getClass().getName()));
            }
            catch (Throwable e) {
                U.error(this.log, "Failed to unregister MBean for component: " + o, e);
            }
        }
    }
}

