/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.IgniteExternalizableExpiryPolicy;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridNearAtomicFullUpdateRequest
extends GridNearAtomicAbstractUpdateRequest {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> keys;
    @GridDirectCollection(value=CacheObject.class)
    private List<CacheObject> vals;
    @GridDirectTransient
    private List<EntryProcessor<Object, Object, Object>> entryProcessors;
    @GridDirectCollection(value=byte[].class)
    private List<byte[]> entryProcessorsBytes;
    @GridDirectCollection(value=GridCacheVersion.class)
    private List<GridCacheVersion> conflictVers;
    private GridLongList conflictTtls;
    private GridLongList conflictExpireTimes;
    @GridDirectTransient
    private Object[] invokeArgs;
    private byte[][] invokeArgsBytes;
    @GridDirectTransient
    private ExpiryPolicy expiryPlc;
    private byte[] expiryPlcBytes;
    private CacheEntryPredicate[] filter;
    @GridDirectTransient
    private int initSize;

    public GridNearAtomicFullUpdateRequest() {
    }

    GridNearAtomicFullUpdateRequest(int cacheId, UUID nodeId, long futId, @NotNull AffinityTopologyVersion topVer, CacheWriteSynchronizationMode syncMode, GridCacheOperation op, @Nullable ExpiryPolicy expiryPlc, @Nullable Object[] invokeArgs, @Nullable CacheEntryPredicate[] filter, int taskNameHash, byte flags, boolean addDepInfo, int maxEntryCnt) {
        super(cacheId, nodeId, futId, topVer, syncMode, op, taskNameHash, flags, addDepInfo);
        this.expiryPlc = expiryPlc;
        this.invokeArgs = invokeArgs;
        this.filter = filter;
        this.initSize = Math.min(maxEntryCnt, 10);
        this.keys = new ArrayList<KeyCacheObject>(this.initSize);
    }

    @Override
    public void addUpdateEntry(KeyCacheObject key, @Nullable Object val, long conflictTtl, long conflictExpireTime, @Nullable GridCacheVersion conflictVer) {
        int i;
        EntryProcessor entryProc = null;
        if (this.op == GridCacheOperation.TRANSFORM) {
            assert (val instanceof EntryProcessor) : val;
            entryProc = (EntryProcessor)val;
        }
        assert (val != null || this.op == GridCacheOperation.DELETE);
        this.keys.add(key);
        if (entryProc != null) {
            if (this.entryProcessors == null) {
                this.entryProcessors = new ArrayList<EntryProcessor<Object, Object, Object>>(this.initSize);
            }
            this.entryProcessors.add(entryProc);
        } else if (val != null) {
            assert (val instanceof CacheObject) : val;
            if (this.vals == null) {
                this.vals = new ArrayList<CacheObject>(this.initSize);
            }
            this.vals.add((CacheObject)val);
        }
        if (conflictVer != null) {
            if (this.conflictVers == null) {
                this.conflictVers = new ArrayList<GridCacheVersion>(this.initSize);
                for (i = 0; i < this.keys.size() - 1; ++i) {
                    this.conflictVers.add(null);
                }
            }
            this.conflictVers.add(conflictVer);
        } else if (this.conflictVers != null) {
            this.conflictVers.add(null);
        }
        if (conflictTtl >= 0L) {
            if (this.conflictTtls == null) {
                this.conflictTtls = new GridLongList(this.keys.size());
                for (i = 0; i < this.keys.size() - 1; ++i) {
                    this.conflictTtls.add(-1L);
                }
            }
            this.conflictTtls.add(conflictTtl);
        }
        if (conflictExpireTime >= 0L) {
            if (this.conflictExpireTimes == null) {
                this.conflictExpireTimes = new GridLongList(this.keys.size());
                for (i = 0; i < this.keys.size() - 1; ++i) {
                    this.conflictExpireTimes.add(-1L);
                }
            }
            this.conflictExpireTimes.add(conflictExpireTime);
        }
    }

    @Override
    public List<KeyCacheObject> keys() {
        return this.keys;
    }

    @Override
    public int size() {
        assert (this.keys != null);
        return this.keys != null ? this.keys.size() : 0;
    }

    @Override
    public KeyCacheObject key(int idx) {
        return this.keys.get(idx);
    }

    @Override
    public List<?> values() {
        return this.op == GridCacheOperation.TRANSFORM ? this.entryProcessors : this.vals;
    }

    @Override
    public CacheObject value(int idx) {
        assert (this.op == GridCacheOperation.UPDATE) : this.op;
        return this.vals.get(idx);
    }

    @Override
    public EntryProcessor<Object, Object, Object> entryProcessor(int idx) {
        assert (this.op == GridCacheOperation.TRANSFORM) : this.op;
        return this.entryProcessors.get(idx);
    }

    @Override
    public CacheObject writeValue(int idx) {
        if (this.vals != null) {
            return this.vals.get(idx);
        }
        return null;
    }

    @Override
    @Nullable
    public List<GridCacheVersion> conflictVersions() {
        return this.conflictVers;
    }

    @Override
    @Nullable
    public GridCacheVersion conflictVersion(int idx) {
        if (this.conflictVers != null) {
            assert (idx >= 0 && idx < this.conflictVers.size());
            return this.conflictVers.get(idx);
        }
        return null;
    }

    @Override
    public long conflictTtl(int idx) {
        if (this.conflictTtls != null) {
            assert (idx >= 0 && idx < this.conflictTtls.size());
            return this.conflictTtls.get(idx);
        }
        return -1L;
    }

    @Override
    public long conflictExpireTime(int idx) {
        if (this.conflictExpireTimes != null) {
            assert (idx >= 0 && idx < this.conflictExpireTimes.size());
            return this.conflictExpireTimes.get(idx);
        }
        return -1L;
    }

    @Override
    @Nullable
    public Object[] invokeArguments() {
        return this.invokeArgs;
    }

    @Override
    @Nullable
    public CacheEntryPredicate[] filter() {
        return this.filter;
    }

    @Override
    public ExpiryPolicy expiry() {
        return this.expiryPlc;
    }

    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        if (this.expiryPlc != null && this.expiryPlcBytes == null) {
            this.expiryPlcBytes = CU.marshal(cctx, new IgniteExternalizableExpiryPolicy(this.expiryPlc));
        }
        this.prepareMarshalCacheObjects(this.keys, cctx);
        if (this.filter != null) {
            boolean hasFilter = false;
            for (CacheEntryPredicate p : this.filter) {
                if (p == null) continue;
                hasFilter = true;
                p.prepareMarshal(cctx);
            }
            if (!hasFilter) {
                this.filter = null;
            }
        }
        if (this.op == GridCacheOperation.TRANSFORM) {
            if (!this.addDepInfo && ctx.deploymentEnabled()) {
                this.addDepInfo = true;
            }
            if (this.entryProcessorsBytes == null) {
                this.entryProcessorsBytes = this.marshalCollection(this.entryProcessors, cctx);
            }
            if (this.invokeArgsBytes == null) {
                this.invokeArgsBytes = this.marshalInvokeArguments(this.invokeArgs, cctx);
            }
        } else {
            this.prepareMarshalCacheObjects(this.vals, cctx);
        }
    }

    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        if (this.expiryPlcBytes != null && this.expiryPlc == null) {
            this.expiryPlc = (ExpiryPolicy)U.unmarshal(ctx, this.expiryPlcBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        this.finishUnmarshalCacheObjects(this.keys, cctx, ldr);
        if (this.filter != null) {
            for (CacheEntryPredicate p : this.filter) {
                if (p == null) continue;
                p.finishUnmarshal(cctx, ldr);
            }
        }
        if (this.op == GridCacheOperation.TRANSFORM) {
            if (this.entryProcessors == null) {
                this.entryProcessors = this.unmarshalCollection(this.entryProcessorsBytes, ctx, ldr);
            }
            if (this.invokeArgs == null) {
                this.invokeArgs = this.unmarshalInvokeArguments(this.invokeArgsBytes, ctx, ldr);
            }
        } else {
            this.finishUnmarshalCacheObjects(this.vals, cctx, ldr);
        }
    }

    @Override
    public int partition() {
        assert (!F.isEmpty(this.keys));
        return this.keys.get(0).partition();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 10: {
                if (!writer.writeMessage("conflictExpireTimes", this.conflictExpireTimes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeMessage("conflictTtls", this.conflictTtls)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeCollection("conflictVers", this.conflictVers, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeCollection("entryProcessorsBytes", this.entryProcessorsBytes, MessageCollectionItemType.BYTE_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeByteArray("expiryPlcBytes", this.expiryPlcBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeObjectArray("filter", this.filter, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeObjectArray("invokeArgsBytes", (T[])this.invokeArgsBytes, MessageCollectionItemType.BYTE_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 17: {
                if (!writer.writeCollection("keys", this.keys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 18: {
                if (!writer.writeCollection("vals", this.vals, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 10: {
                this.conflictExpireTimes = (GridLongList)reader.readMessage("conflictExpireTimes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.conflictTtls = (GridLongList)reader.readMessage("conflictTtls");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.conflictVers = (List)reader.readCollection("conflictVers", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.entryProcessorsBytes = (List)reader.readCollection("entryProcessorsBytes", MessageCollectionItemType.BYTE_ARR);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.expiryPlcBytes = reader.readByteArray("expiryPlcBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.filter = reader.readObjectArray("filter", MessageCollectionItemType.MSG, CacheEntryPredicate.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                this.invokeArgsBytes = reader.readObjectArray("invokeArgsBytes", MessageCollectionItemType.BYTE_ARR, byte[].class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 17: {
                this.keys = (List)reader.readCollection("keys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 18: {
                this.vals = (List)reader.readCollection("vals", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearAtomicFullUpdateRequest.class);
    }

    @Override
    public void cleanup(boolean clearKeys) {
        this.vals = null;
        this.entryProcessors = null;
        this.entryProcessorsBytes = null;
        this.invokeArgs = null;
        this.invokeArgsBytes = null;
        if (clearKeys) {
            this.keys = null;
        }
    }

    @Override
    public short directType() {
        return 40;
    }

    @Override
    public byte fieldsCount() {
        return 19;
    }

    @Override
    public String toString() {
        return S.toString(GridNearAtomicFullUpdateRequest.class, this, "filter", (Object)Arrays.toString(this.filter), "parent", (Object)super.toString());
    }
}

