/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.odbc;

import java.sql.BatchUpdateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.configuration.Factory;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequest;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponseSender;
import org.apache.ignite.internal.processors.odbc.SqlListenerUtils;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcParameterMeta;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcColumnMeta;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQuery;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryCloseRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryCloseResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryExecuteBatchRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryExecuteBatchResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryExecuteRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryExecuteResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryFetchRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryFetchResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetColumnsMetaRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetColumnsMetaResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetParamsMetaRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetParamsMetaResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetResultsetMetaRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetResultsetMetaResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetTablesMetaRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetTablesMetaResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryMoreResultsRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryMoreResultsResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryResults;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcRequestHandlerWorker;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcResponse;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcResultSet;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcStreamingBatchRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcStreamingBatchResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcTableMeta;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcUtils;
import org.apache.ignite.internal.processors.odbc.odbc.escape.OdbcEscapeUtils;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.SqlClientContext;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class OdbcRequestHandler
implements ClientListenerRequestHandler {
    private static final AtomicLong QRY_ID_GEN = new AtomicLong();
    private final GridKernalContext ctx;
    private final SqlClientContext cliCtx;
    private final IgniteLogger log;
    private final GridSpinBusyLock busyLock;
    private final OdbcRequestHandlerWorker worker;
    private final int maxCursors;
    private final ConcurrentHashMap<Long, OdbcQueryResults> qryResults = new ConcurrentHashMap();
    private ClientListenerProtocolVersion ver;
    private final PriorityQueue<OdbcStreamingBatchRequest> orderedBatchesQueue = new PriorityQueue();
    private final Object orderedBatchesMux = new Object();
    private final ClientListenerResponseSender sender;
    private final OdbcConnectionContext connCtx;

    public OdbcRequestHandler(GridKernalContext ctx, GridSpinBusyLock busyLock, ClientListenerResponseSender sender, int maxCursors, boolean distributedJoins, boolean enforceJoinOrder, boolean replicatedOnly, boolean collocated, boolean lazy, boolean skipReducerOnUpdate, @Nullable String qryEngine, ClientListenerProtocolVersion ver, OdbcConnectionContext connCtx) {
        this.ctx = ctx;
        this.connCtx = connCtx;
        Factory<GridWorker> orderedFactory = new Factory<GridWorker>(){

            @Override
            public GridWorker create() {
                return new OrderedBatchWorker();
            }
        };
        this.cliCtx = new SqlClientContext(ctx, orderedFactory, distributedJoins, enforceJoinOrder, collocated, replicatedOnly, lazy, skipReducerOnUpdate, null, null, qryEngine, null, null, 0L, null);
        this.busyLock = busyLock;
        this.sender = sender;
        this.maxCursors = maxCursors;
        this.ver = ver;
        this.log = ctx.log(this.getClass());
        this.worker = new OdbcRequestHandlerWorker(ctx.igniteInstanceName(), this.log, this, ctx);
    }

    @Override
    public ClientListenerResponse handle(ClientListenerRequest req) {
        assert (req != null);
        assert (req instanceof OdbcRequest);
        return this.doHandle((OdbcRequest)req);
    }

    void start() {
        if (this.worker != null) {
            this.worker.start();
        }
    }

    public ClientListenerResponse doHandle(OdbcRequest req) {
        if (!this.busyLock.enterBusy()) {
            return new OdbcResponse(1, "Failed to handle ODBC request because node is stopping: " + req);
        }
        try {
            switch (req.command()) {
                case 2: {
                    ClientListenerResponse clientListenerResponse = this.executeQuery((OdbcQueryExecuteRequest)req);
                    return clientListenerResponse;
                }
                case 8: {
                    ClientListenerResponse clientListenerResponse = this.executeBatchQuery((OdbcQueryExecuteBatchRequest)req);
                    return clientListenerResponse;
                }
                case 10: {
                    ClientListenerResponse clientListenerResponse = this.dispatchBatchOrdered((OdbcStreamingBatchRequest)req);
                    return clientListenerResponse;
                }
                case 3: {
                    ClientListenerResponse clientListenerResponse = this.fetchQuery((OdbcQueryFetchRequest)req);
                    return clientListenerResponse;
                }
                case 4: {
                    ClientListenerResponse clientListenerResponse = this.closeQuery((OdbcQueryCloseRequest)req);
                    return clientListenerResponse;
                }
                case 5: {
                    ClientListenerResponse clientListenerResponse = this.getColumnsMeta((OdbcQueryGetColumnsMetaRequest)req);
                    return clientListenerResponse;
                }
                case 6: {
                    ClientListenerResponse clientListenerResponse = this.getTablesMeta((OdbcQueryGetTablesMetaRequest)req);
                    return clientListenerResponse;
                }
                case 7: {
                    ClientListenerResponse clientListenerResponse = this.getParamsMeta((OdbcQueryGetParamsMetaRequest)req);
                    return clientListenerResponse;
                }
                case 11: {
                    ClientListenerResponse clientListenerResponse = this.getResultMeta((OdbcQueryGetResultsetMetaRequest)req);
                    return clientListenerResponse;
                }
                case 9: {
                    ClientListenerResponse clientListenerResponse = this.moreResults((OdbcQueryMoreResultsRequest)req);
                    return clientListenerResponse;
                }
            }
            OdbcResponse odbcResponse = new OdbcResponse(1, "Unsupported ODBC request: " + req);
            return odbcResponse;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public ClientListenerResponse handleException(Throwable e, ClientListenerRequest req) {
        return OdbcRequestHandler.exceptionToResult(e);
    }

    @Override
    public void writeHandshake(BinaryWriterExImpl writer) {
        writer.writeBoolean(true);
    }

    public void onDisconnect() {
        if (this.busyLock.enterBusy()) {
            if (this.worker != null) {
                this.worker.cancel();
                try {
                    this.worker.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                for (OdbcQueryResults res : this.qryResults.values()) {
                    res.closeAll();
                }
                U.close(this.cliCtx, this.log);
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
    }

    @Override
    public boolean isCancellationCommand(int cmdId) {
        return false;
    }

    @Override
    public boolean isCancellationSupported() {
        return false;
    }

    @Override
    public void registerRequest(long reqId, int cmdType) {
    }

    @Override
    public void unregisterRequest(long reqId) {
    }

    @Override
    public ClientListenerProtocolVersion protocolVersion() {
        return this.ver;
    }

    private SqlFieldsQueryEx makeQuery(String schema, String sql, Object[] args, int timeout, boolean autoCommit) {
        SqlFieldsQueryEx qry = this.makeQuery(schema, sql);
        qry.setArgs(args);
        qry.setAutoCommit(autoCommit);
        QueryUtils.withQueryTimeout(qry, timeout, TimeUnit.SECONDS);
        return qry;
    }

    private SqlFieldsQueryEx makeQuery(String schema, String sql) {
        SqlFieldsQueryEx qry = new SqlFieldsQueryEx(sql, null);
        qry.setDistributedJoins(this.cliCtx.isDistributedJoins());
        qry.setEnforceJoinOrder(this.cliCtx.isEnforceJoinOrder());
        qry.setReplicatedOnly(this.cliCtx.isReplicatedOnly());
        qry.setCollocated(this.cliCtx.isCollocated());
        qry.setLazy(this.cliCtx.isLazy());
        qry.setSchema(OdbcUtils.prepareSchema(schema));
        qry.setSkipReducerOnUpdate(this.cliCtx.isSkipReducerOnUpdate());
        qry.setQueryInitiatorId(this.connCtx.clientDescriptor());
        return qry;
    }

    private ClientListenerResponse executeQuery(OdbcQueryExecuteRequest req) {
        int cursorCnt = this.qryResults.size();
        if (this.maxCursors > 0 && cursorCnt >= this.maxCursors) {
            return new OdbcResponse(1, "Too many open cursors (either close other open cursors or increase the limit through ClientConnectorConfiguration.maxOpenCursorsPerConnection) [maximum=" + this.maxCursors + ", current=" + cursorCnt + "]");
        }
        long qryId = QRY_ID_GEN.getAndIncrement();
        assert (!this.cliCtx.isStream());
        try {
            Collection<OdbcColumnMeta> fieldsMeta;
            String sql = OdbcEscapeUtils.parse(req.sqlQuery());
            if (this.log.isDebugEnabled()) {
                this.log.debug("ODBC query parsed [reqId=" + req.requestId() + ", original=" + req.sqlQuery() + ", parsed=" + sql + "]");
            }
            SqlFieldsQueryEx qry = this.makeQuery(req.schema(), sql, req.arguments(), req.timeout(), req.autoCommit());
            List<FieldsQueryCursor<List<?>>> cursors = this.ctx.query().querySqlFields(null, qry, this.cliCtx, true, false);
            OdbcQueryResults results = new OdbcQueryResults(cursors, this.ver);
            OdbcResultSet set = results.currentResultSet();
            if (set == null) {
                fieldsMeta = new ArrayList<OdbcColumnMeta>();
            } else {
                fieldsMeta = set.fieldsMeta();
                if (this.log.isDebugEnabled()) {
                    for (OdbcColumnMeta meta : fieldsMeta) {
                        this.log.debug("Meta - " + meta.toString());
                    }
                }
            }
            if (!results.hasUnfetchedRows()) {
                results.closeAll();
            } else {
                this.qryResults.put(qryId, results);
            }
            OdbcQueryExecuteResult res = new OdbcQueryExecuteResult(qryId, fieldsMeta, results.rowsAffected());
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            this.qryResults.remove(qryId);
            U.error(this.log, "Failed to execute SQL query [reqId=" + req.requestId() + ", req=" + req + "]", e);
            return OdbcRequestHandler.exceptionToResult(e);
        }
    }

    private ClientListenerResponse executeBatchQuery(OdbcQueryExecuteBatchRequest req) {
        try {
            String sql = OdbcEscapeUtils.parse(req.sqlQuery());
            if (this.log.isDebugEnabled()) {
                this.log.debug("ODBC query parsed [reqId=" + req.requestId() + ", original=" + req.sqlQuery() + ", parsed=" + sql + "]");
            }
            SqlFieldsQueryEx qry = this.makeQuery(req.schema(), sql, null, req.timeout(), req.autoCommit());
            Object[][] paramSet = req.arguments();
            if (paramSet.length <= 0) {
                throw new IgniteException("Batch execute request with non-positive batch length. [len=" + paramSet.length + "]");
            }
            for (Object[] set : paramSet) {
                qry.addBatchedArgs(set);
            }
            List<FieldsQueryCursor<List<?>>> qryCurs = this.ctx.query().querySqlFields(null, qry, this.cliCtx, true, true);
            long[] rowsAffected = new long[req.arguments().length];
            for (int i = 0; i < qryCurs.size(); ++i) {
                rowsAffected[i] = OdbcUtils.rowsAffected((QueryCursor)qryCurs.get(i));
            }
            OdbcQueryExecuteBatchResult res = new OdbcQueryExecuteBatchResult(rowsAffected);
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to execute SQL query [reqId=" + req.requestId() + ", req=" + req + "]", e);
            return OdbcRequestHandler.exceptionToBatchResult(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientListenerResponse dispatchBatchOrdered(OdbcStreamingBatchRequest req) {
        if (!this.cliCtx.isStreamOrdered()) {
            this.processStreamingBatchOrdered(req);
        } else {
            Object object = this.orderedBatchesMux;
            synchronized (object) {
                this.orderedBatchesQueue.add(req);
                this.orderedBatchesMux.notifyAll();
            }
        }
        return null;
    }

    private void processStreamingBatchOrdered(OdbcStreamingBatchRequest req) {
        try {
            if (req.last()) {
                this.cliCtx.waitTotalProcessedOrderedRequests(req.order());
            }
            this.sender.send(this.processStreamingBatch(req));
        }
        catch (Exception e) {
            U.error(null, "Error processing file batch", e);
            this.sender.send(new OdbcResponse(1, "Server error: " + e));
        }
        this.cliCtx.orderedRequestProcessed();
    }

    private ClientListenerResponse processStreamingBatch(OdbcStreamingBatchRequest req) {
        assert (this.cliCtx.isStream());
        IgniteBiTuple<Integer, String> firstErr = new IgniteBiTuple<Integer, String>();
        SqlFieldsQueryEx qry = null;
        for (OdbcQuery q : req.queries()) {
            if (q.sql() != null) {
                if (qry != null) {
                    this.processStreamingBatch(qry, firstErr);
                }
                qry = this.makeQuery(req.schemaName(), q.sql());
            }
            assert (qry != null);
            qry.addBatchedArgs(q.args());
        }
        if (qry != null) {
            this.processStreamingBatch(qry, firstErr);
        }
        if (req.last()) {
            this.cliCtx.disableStreaming();
        }
        if (firstErr.isEmpty()) {
            return new OdbcResponse(new OdbcStreamingBatchResult(req.order()));
        }
        assert (firstErr.getKey() != null);
        return new OdbcResponse(new OdbcStreamingBatchResult(firstErr.getKey(), firstErr.getValue(), req.order()));
    }

    private void processStreamingBatch(SqlFieldsQueryEx qry, IgniteBiTuple<Integer, String> err) {
        try {
            assert (this.cliCtx.isStream());
            this.ctx.query().streamBatchedUpdateQuery(OdbcUtils.prepareSchema(qry.getSchema()), this.cliCtx, qry.getSql(), qry.batchedArguments(), this.connCtx.clientDescriptor());
        }
        catch (Exception e) {
            U.error(this.log, "Failed to execute batch query [qry=" + qry + "]", e);
            OdbcRequestHandler.extractBatchError(e, null, err);
        }
    }

    private ClientListenerResponse closeQuery(OdbcQueryCloseRequest req) {
        long qryId = req.queryId();
        try {
            OdbcQueryResults results = this.qryResults.get(qryId);
            if (results == null) {
                return new OdbcResponse(1, "Failed to find query with ID: " + qryId);
            }
            this.CloseCursor(results, qryId);
            OdbcQueryCloseResult res = new OdbcQueryCloseResult(qryId);
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            this.qryResults.remove(qryId);
            U.error(this.log, "Failed to close SQL query [reqId=" + req.requestId() + ", req=" + qryId + "]", e);
            return OdbcRequestHandler.exceptionToResult(e);
        }
    }

    private ClientListenerResponse fetchQuery(OdbcQueryFetchRequest req) {
        try {
            boolean lastPage;
            long qryId = req.queryId();
            OdbcQueryResults results = this.qryResults.get(qryId);
            if (results == null) {
                return new OdbcResponse(1, "Failed to find query with ID: " + qryId);
            }
            OdbcResultSet set = results.currentResultSet();
            List<Object> items = set.fetch(req.pageSize());
            boolean bl = lastPage = !set.hasUnfetchedRows();
            if (!results.hasUnfetchedRows()) {
                this.CloseCursor(results, qryId);
            }
            OdbcQueryFetchResult res = new OdbcQueryFetchResult(qryId, items, lastPage);
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to fetch SQL query result [reqId=" + req.requestId() + ", req=" + req + "]", e);
            return OdbcRequestHandler.exceptionToResult(e);
        }
    }

    private ClientListenerResponse getColumnsMeta(OdbcQueryGetColumnsMetaRequest req) {
        try {
            String tablePattern;
            String schemaPattern;
            ArrayList<OdbcColumnMeta> meta = new ArrayList<OdbcColumnMeta>();
            if (req.tablePattern().contains(".")) {
                String[] parts = req.tablePattern().split("\\.");
                schemaPattern = parts[0];
                tablePattern = parts[1];
            } else {
                schemaPattern = req.schemaPattern();
                tablePattern = req.tablePattern();
            }
            schemaPattern = OdbcUtils.removeQuotationMarksIfNeeded(schemaPattern);
            for (String cacheName : this.ctx.cache().publicCacheNames()) {
                for (GridQueryTypeDescriptor table : this.ctx.query().types(cacheName)) {
                    if (!OdbcRequestHandler.matches(table.schemaName(), schemaPattern) || !OdbcRequestHandler.matches(table.tableName(), tablePattern)) continue;
                    for (Map.Entry<String, Class<?>> field : table.fields().entrySet()) {
                        if (!OdbcRequestHandler.matches(field.getKey(), req.columnPattern())) continue;
                        GridQueryProperty prop = table.property(field.getKey());
                        OdbcColumnMeta columnMeta = new OdbcColumnMeta(table.schemaName(), table.tableName(), field.getKey(), field.getValue(), prop.precision(), prop.scale(), prop.notNull() ? 0 : 1);
                        if (meta.contains(columnMeta)) continue;
                        meta.add(columnMeta);
                    }
                }
            }
            OdbcQueryGetColumnsMetaResult res = new OdbcQueryGetColumnsMetaResult(meta);
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get columns metadata [reqId=" + req.requestId() + ", req=" + req + "]", e);
            return OdbcRequestHandler.exceptionToResult(e);
        }
    }

    private ClientListenerResponse getTablesMeta(OdbcQueryGetTablesMetaRequest req) {
        try {
            ArrayList<OdbcTableMeta> meta = new ArrayList<OdbcTableMeta>();
            String schemaPattern = OdbcUtils.removeQuotationMarksIfNeeded(req.schema());
            for (String cacheName : this.ctx.cache().publicCacheNames()) {
                for (GridQueryTypeDescriptor table : this.ctx.query().types(cacheName)) {
                    OdbcTableMeta tableMeta;
                    if (!OdbcRequestHandler.matches(table.schemaName(), schemaPattern) || !OdbcRequestHandler.matches(table.tableName(), req.table()) || !OdbcRequestHandler.matchesTableType("TABLE", req.tableType()) || meta.contains(tableMeta = new OdbcTableMeta(null, table.schemaName(), table.tableName(), "TABLE"))) continue;
                    meta.add(tableMeta);
                }
            }
            OdbcQueryGetTablesMetaResult res = new OdbcQueryGetTablesMetaResult(meta);
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get tables metadata [reqId=" + req.requestId() + ", req=" + req + "]", e);
            return OdbcRequestHandler.exceptionToResult(e);
        }
    }

    private ClientListenerResponse getParamsMeta(OdbcQueryGetParamsMetaRequest req) {
        try {
            String sql = OdbcEscapeUtils.parse(req.query());
            String schema = OdbcUtils.prepareSchema(req.schema());
            SqlFieldsQueryEx qry = this.makeQuery(schema, sql);
            List<JdbcParameterMeta> params = this.ctx.query().parameterMetaData(qry, this.cliCtx);
            byte[] typeIds = new byte[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                int sqlType = params.get(i).type();
                typeIds[i] = OdbcRequestHandler.sqlTypeToBinary(sqlType);
            }
            OdbcQueryGetParamsMetaResult res = new OdbcQueryGetParamsMetaResult(typeIds);
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get params metadata [reqId=" + req.requestId() + ", req=" + req + "]", e);
            return OdbcRequestHandler.exceptionToResult(e);
        }
    }

    private ClientListenerResponse getResultMeta(OdbcQueryGetResultsetMetaRequest req) {
        try {
            String sql = OdbcEscapeUtils.parse(req.query());
            String schema = OdbcUtils.prepareSchema(req.schema());
            SqlFieldsQueryEx qry = this.makeQuery(schema, sql);
            List<GridQueryFieldMetadata> columns = this.ctx.query().resultSetMetaData(qry, this.cliCtx);
            Collection<OdbcColumnMeta> meta = OdbcUtils.convertMetadata(columns);
            OdbcQueryGetResultsetMetaResult res = new OdbcQueryGetResultsetMetaResult(meta);
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get resultset metadata [reqId=" + req.requestId() + ", req=" + req + "]", e);
            return OdbcRequestHandler.exceptionToResult(e);
        }
    }

    private ClientListenerResponse moreResults(OdbcQueryMoreResultsRequest req) {
        try {
            boolean lastPage;
            long qryId = req.queryId();
            OdbcQueryResults results = this.qryResults.get(qryId);
            if (results == null) {
                return new OdbcResponse(1, "Failed to find query with ID: " + qryId);
            }
            results.nextResultSet();
            OdbcResultSet set = results.currentResultSet();
            List<Object> items = set.fetch(req.pageSize());
            boolean bl = lastPage = !set.hasUnfetchedRows();
            if (!results.hasUnfetchedRows()) {
                this.CloseCursor(results, qryId);
            }
            OdbcQueryMoreResultsResult res = new OdbcQueryMoreResultsResult(qryId, items, lastPage);
            return new OdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get more SQL query results [reqId=" + req.requestId() + ", req=" + req + "]", e);
            return OdbcRequestHandler.exceptionToResult(e);
        }
    }

    private void CloseCursor(OdbcQueryResults results, long queryId) {
        assert (results != null);
        results.closeAll();
        this.qryResults.remove(queryId);
    }

    private static byte sqlTypeToBinary(int sqlType) {
        switch (sqlType) {
            case -5: {
                return 4;
            }
            case 16: {
                return 8;
            }
            case 91: {
                return 11;
            }
            case 8: {
                return 6;
            }
            case 6: 
            case 7: {
                return 5;
            }
            case 2: 
            case 3: {
                return 30;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 2;
            }
            case 92: {
                return 36;
            }
            case 93: {
                return 33;
            }
            case -6: {
                return 1;
            }
            case -16: 
            case 1: 
            case 12: {
                return 9;
            }
            case 0: {
                return 101;
            }
        }
        return 12;
    }

    private static boolean matchesTableType(String str, String ptrn) {
        String[] types;
        if (F.isEmpty(ptrn)) {
            return true;
        }
        if (str == null) {
            return false;
        }
        String pattern = OdbcUtils.preprocessPattern(ptrn);
        for (String type0 : types = pattern.split(",")) {
            String type = OdbcUtils.removeQuotationMarksIfNeeded(type0.trim());
            if (!str.toUpperCase().matches(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(String str, String ptrn) {
        if (F.isEmpty(ptrn)) {
            return true;
        }
        if (str == null) {
            return false;
        }
        String pattern = OdbcUtils.preprocessPattern(ptrn);
        return str.toUpperCase().matches(pattern);
    }

    private static OdbcResponse exceptionToBatchResult(Exception e) {
        IgniteBiTuple<Integer, String> err = new IgniteBiTuple<Integer, String>();
        ArrayList<Long> rowsAffected = new ArrayList<Long>();
        OdbcRequestHandler.extractBatchError(e, rowsAffected, err);
        OdbcQueryExecuteBatchResult res = new OdbcQueryExecuteBatchResult(U.toLongArray(rowsAffected), -1L, err.get1(), err.get2());
        return new OdbcResponse(res);
    }

    private static void extractBatchError(Exception e, List<Long> rowsAffected, IgniteBiTuple<Integer, String> err) {
        if (e instanceof IgniteSQLException) {
            BatchUpdateException batchCause = X.cause(e, BatchUpdateException.class);
            if (batchCause != null) {
                if (rowsAffected != null) {
                    for (long cnt : batchCause.getLargeUpdateCounts()) {
                        rowsAffected.add(cnt);
                    }
                }
                err.set(batchCause.getErrorCode(), batchCause.getMessage());
            } else {
                err.set(((IgniteSQLException)e).statusCode(), OdbcUtils.tryRetrieveH2ErrorMessage(e));
            }
        } else {
            err.set(1, e.getMessage());
        }
    }

    private static OdbcResponse exceptionToResult(Throwable e) {
        String msg = OdbcUtils.tryRetrieveH2ErrorMessage(e);
        int errorCode = SqlListenerUtils.exceptionToSqlErrorCode(e);
        return new OdbcResponse(errorCode, msg);
    }

    private class OrderedBatchWorker
    extends GridWorker {
        OrderedBatchWorker() {
            super(OdbcRequestHandler.this.ctx.igniteInstanceName(), "ordered-batch", OdbcRequestHandler.this.log);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            long nextBatchOrder = 0L;
            while (OdbcRequestHandler.this.cliCtx.isStream()) {
                OdbcStreamingBatchRequest req;
                Object object = OdbcRequestHandler.this.orderedBatchesMux;
                synchronized (object) {
                    req = OdbcRequestHandler.this.orderedBatchesQueue.peek();
                    if (req == null || req.order() != nextBatchOrder) {
                        OdbcRequestHandler.this.orderedBatchesMux.wait();
                        continue;
                    }
                    OdbcRequestHandler.this.orderedBatchesQueue.poll();
                }
                OdbcRequestHandler.this.processStreamingBatchOrdered(req);
                ++nextBatchOrder;
            }
            return;
        }
    }
}

