/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ssl;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.configuration.Factory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ssl.SSLContextWrapper;

public abstract class AbstractSslContextFactory
implements Factory<SSLContext> {
    private static final long serialVersionUID = 0L;
    public static final String DFLT_SSL_PROTOCOL = "TLS";
    protected String proto = "TLS";
    protected String[] cipherSuites;
    protected String[] protocols;
    protected final AtomicReference<SSLContext> sslCtx = new AtomicReference();

    public String getProtocol() {
        return this.proto;
    }

    public void setProtocol(String proto) {
        A.notNull(proto, "proto");
        this.proto = proto;
    }

    public void setCipherSuites(String ... cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public void setProtocols(String ... protocols) {
        this.protocols = protocols;
    }

    private SSLContext createSslContext() throws SSLException {
        this.checkParameters();
        KeyManager[] keyMgrs = this.createKeyManagers();
        TrustManager[] trustMgrs = this.createTrustManagers();
        try {
            SSLContext ctx = SSLContext.getInstance(this.proto);
            if (this.cipherSuites != null || this.protocols != null) {
                SSLParameters sslParameters = new SSLParameters();
                if (this.cipherSuites != null) {
                    sslParameters.setCipherSuites(this.cipherSuites);
                }
                if (this.protocols != null) {
                    sslParameters.setProtocols(this.protocols);
                }
                ctx = new SSLContextWrapper(ctx, sslParameters);
            }
            ctx.init(keyMgrs, trustMgrs, null);
            return ctx;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSLException("Unsupported SSL protocol: " + this.proto, e);
        }
        catch (KeyManagementException e) {
            throw new SSLException("Failed to initialized SSL context.", e);
        }
    }

    protected void checkNullParameter(Object param, String name) throws SSLException {
        if (param == null) {
            throw new SSLException("Failed to initialize SSL context (parameter cannot be null): " + name);
        }
    }

    protected abstract void checkParameters() throws SSLException;

    protected abstract KeyManager[] createKeyManagers() throws SSLException;

    protected abstract TrustManager[] createTrustManagers() throws SSLException;

    @Override
    public SSLContext create() {
        SSLContext ctx = this.sslCtx.get();
        if (ctx == null) {
            try {
                ctx = this.createSslContext();
                if (!this.sslCtx.compareAndSet(null, ctx)) {
                    ctx = this.sslCtx.get();
                }
            }
            catch (SSLException e) {
                throw new IgniteException(e);
            }
        }
        return ctx;
    }
}

