/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfiguration;
import org.infinispan.client.hotrod.impl.MarshallerRegistry;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.client.hotrod.marshall.MediaTypeMarshaller;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.AdaptiveBufferSizePredictor;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.IdentityMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;

public final class DataFormat {
    private static final Log log = LogFactory.getLog(DataFormat.class, Log.class);
    private final BufferSizePredictor keySizePredictor = new AdaptiveBufferSizePredictor();
    private final BufferSizePredictor valueSizePredictor = new AdaptiveBufferSizePredictor();
    private final DataFormatImpl server;
    private final DataFormatImpl client;
    private MarshallerRegistry marshallerRegistry;
    private Marshaller defaultMarshaller;

    private DataFormat(MediaType cKeyType, MediaType cValueType, Marshaller cKeyMarshaller, Marshaller cValueMarshaller, MediaType sKeyType, MediaType sValueType, Marshaller sKeyMarshaller, Marshaller sValueMarshaller) {
        this.server = new DataFormatImpl(sKeyType, sValueType, sKeyMarshaller, sValueMarshaller);
        this.client = new DataFormatImpl(cKeyType, cValueType, cKeyMarshaller, cValueMarshaller);
    }

    private DataFormat(MediaType cKeyType, MediaType cValueType, Marshaller cKeyMarshaller, Marshaller cValueMarshaller) {
        this.server = null;
        this.client = new DataFormatImpl(cKeyType, cValueType, cKeyMarshaller, cValueMarshaller);
    }

    public DataFormat withoutValueType() {
        DataFormat dataFormat = this.server != null ? new DataFormat(this.client.keyType, null, this.client.keyMarshaller, null, this.server.keyType, this.server.valueType, this.server.keyMarshaller, this.server.valueMarshaller) : new DataFormat(this.client.keyType, null, this.client.keyMarshaller, null);
        dataFormat.marshallerRegistry = this.marshallerRegistry;
        dataFormat.defaultMarshaller = this.defaultMarshaller;
        return dataFormat;
    }

    public MediaType getKeyType() {
        return this.client.getKeyType();
    }

    public MediaType getValueType() {
        return this.client.getValueType();
    }

    @Deprecated(forRemoval=true, since="12.0")
    public void initialize(RemoteCacheManager remoteCacheManager, boolean serverObjectStorage) {
        this.marshallerRegistry = remoteCacheManager.getMarshallerRegistry();
        this.defaultMarshaller = remoteCacheManager.getMarshaller();
    }

    public void initialize(RemoteCacheManager remoteCacheManager, String cacheName, boolean serverObjectStorage) {
        this.marshallerRegistry = remoteCacheManager.getMarshallerRegistry();
        this.defaultMarshaller = remoteCacheManager.getMarshaller();
        RemoteCacheConfiguration remoteCacheConfiguration = remoteCacheManager.getConfiguration().remoteCaches().get(cacheName);
        if (remoteCacheConfiguration != null) {
            Marshaller cacheMarshaller = remoteCacheConfiguration.marshaller();
            if (cacheMarshaller != null) {
                this.defaultMarshaller = cacheMarshaller;
            } else {
                Class<? extends Marshaller> marshallerClass = remoteCacheConfiguration.marshallerClass();
                if (marshallerClass != null) {
                    Marshaller registryMarshaller = this.marshallerRegistry.getMarshaller(marshallerClass);
                    this.defaultMarshaller = registryMarshaller != null ? registryMarshaller : Util.getInstance(marshallerClass);
                }
            }
        }
    }

    public boolean isObjectStorage() {
        return this.server != null && this.server.keyType == MediaType.APPLICATION_OBJECT;
    }

    @Deprecated(forRemoval=true, since="12.0")
    public byte[] keyToBytes(Object key, int estimateKeySize, int estimateValueSize) {
        return this.keyToBytes(key);
    }

    public byte[] keyToBytes(Object key) {
        return this.client.keyToBytes(key);
    }

    @Deprecated(forRemoval=true, since="12.0")
    public byte[] valueToBytes(Object value, int estimateKeySize, int estimateValueSize) {
        return this.valueToBytes(value);
    }

    public byte[] valueToBytes(Object value) {
        return this.client.valueToBytes(value);
    }

    public <T> T keyToObj(byte[] bytes, ClassAllowList allowList) {
        return this.client.bytesToKey(bytes, allowList);
    }

    public <T> T valueToObj(byte[] bytes, ClassAllowList allowList) {
        return this.client.bytesToValue(bytes, allowList);
    }

    public MediaTypeMarshaller server() {
        if (this.server == null || this.server.match(this.client)) {
            return null;
        }
        if (this.isObjectStorage()) {
            return null;
        }
        return this.marshallerRegistry.getMarshaller(this.server.keyType) == null ? null : this.server;
    }

    public MediaTypeMarshaller client() {
        return this.client;
    }

    public String toString() {
        return "DataFormat{client=" + String.valueOf(this.client) + ", server=" + String.valueOf(this.server) + ", marshallerRegistry=" + String.valueOf(this.marshallerRegistry) + ", defaultMarshaller=" + String.valueOf(this.defaultMarshaller) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private final class DataFormatImpl
    implements MediaTypeMarshaller {
        private final MediaType keyType;
        private final MediaType valueType;
        private final Marshaller keyMarshaller;
        private final Marshaller valueMarshaller;

        private DataFormatImpl(MediaType keyType, MediaType valueType, Marshaller keyMarshaller, Marshaller valueMarshaller) {
            this.keyType = keyType;
            this.valueType = valueType;
            this.keyMarshaller = keyMarshaller;
            this.valueMarshaller = valueMarshaller;
        }

        @Override
        public MediaType getKeyType() {
            if (this.keyType != null) {
                return this.keyType;
            }
            Marshaller marshaller = this.resolveKeyMarshaller();
            return marshaller == null ? null : marshaller.mediaType();
        }

        @Override
        public MediaType getValueType() {
            if (this.valueType != null) {
                return this.valueType;
            }
            Marshaller marshaller = this.resolveValueMarshaller();
            return marshaller == null ? null : marshaller.mediaType();
        }

        private Marshaller resolveKeyMarshaller() {
            if (this.keyMarshaller != null) {
                return this.keyMarshaller;
            }
            if (this.keyType == null) {
                return DataFormat.this.defaultMarshaller;
            }
            Marshaller forKeyType = DataFormat.this.marshallerRegistry.getMarshaller(this.keyType);
            if (forKeyType != null) {
                return forKeyType;
            }
            log.debugf("No marshaller registered for %s, using no-op marshaller", (Object)this.keyType);
            return IdentityMarshaller.INSTANCE;
        }

        private Marshaller resolveValueMarshaller() {
            if (this.valueMarshaller != null) {
                return this.valueMarshaller;
            }
            if (this.valueType == null) {
                return DataFormat.this.defaultMarshaller;
            }
            Marshaller forValueType = DataFormat.this.marshallerRegistry.getMarshaller(this.valueType);
            if (forValueType != null) {
                return forValueType;
            }
            log.debugf("No marshaller registered for %s, using no-op marshaller", (Object)this.valueType);
            return IdentityMarshaller.INSTANCE;
        }

        @Override
        public byte[] keyToBytes(Object key) {
            Marshaller keyMarshaller = this.resolveKeyMarshaller();
            return MarshallerUtil.obj2bytes(keyMarshaller, key, DataFormat.this.keySizePredictor);
        }

        @Override
        public byte[] valueToBytes(Object value) {
            Marshaller valueMarshaller = this.resolveValueMarshaller();
            return MarshallerUtil.obj2bytes(valueMarshaller, value, DataFormat.this.valueSizePredictor);
        }

        @Override
        public <T> T bytesToKey(byte[] bytes, ClassAllowList allowList) {
            Marshaller keyMarshaller = this.resolveKeyMarshaller();
            return MarshallerUtil.bytes2obj(keyMarshaller, bytes, DataFormat.this.isObjectStorage(), allowList);
        }

        @Override
        public <T> T bytesToValue(byte[] bytes, ClassAllowList allowList) {
            Marshaller valueMarshaller = this.resolveValueMarshaller();
            return MarshallerUtil.bytes2obj(valueMarshaller, bytes, DataFormat.this.isObjectStorage(), allowList);
        }

        public boolean match(DataFormatImpl other) {
            if (other == null) {
                return false;
            }
            MediaType mt = this.getKeyType();
            return mt != null && other.getKeyType() != null && mt.match(other.getKeyType());
        }

        public String toString() {
            return "DataFormatImpl{keyType=" + String.valueOf(this.keyType) + ", valueType=" + String.valueOf(this.valueType) + ", keyMarshaller=" + String.valueOf(this.keyMarshaller) + ", valueMarshaller=" + String.valueOf(this.valueMarshaller) + "}";
        }
    }

    public static class Builder {
        private MediaType keyType;
        private MediaType valueType;
        private Marshaller valueMarshaller;
        private Marshaller keyMarshaller;
        private Builder serverDataFormat;

        public Builder from(DataFormat dataFormat) {
            this.from(dataFormat.client);
            if (dataFormat.server != null) {
                this.serverDataFormat = new Builder();
                this.serverDataFormat.from(dataFormat.server);
            }
            return this;
        }

        private void from(DataFormatImpl impl) {
            this.keyType = impl.keyType;
            this.valueType = impl.valueType;
            this.keyMarshaller = impl.keyMarshaller;
            this.valueMarshaller = impl.valueMarshaller;
        }

        public Builder valueMarshaller(Marshaller valueMarshaller) {
            this.valueMarshaller = valueMarshaller;
            return this;
        }

        public Builder keyMarshaller(Marshaller keyMarshaller) {
            this.keyMarshaller = keyMarshaller;
            return this;
        }

        public Builder keyType(MediaType keyType) {
            this.keyType = keyType;
            return this;
        }

        public Builder valueType(MediaType valueType) {
            this.valueType = valueType;
            return this;
        }

        public Builder serverDataFormat(Builder format) {
            this.serverDataFormat = format;
            return this;
        }

        public DataFormat build() {
            if (this.serverDataFormat != null) {
                return new DataFormat(this.keyType, this.valueType, this.keyMarshaller, this.valueMarshaller, this.serverDataFormat.keyType, this.serverDataFormat.valueType, this.serverDataFormat.keyMarshaller, this.serverDataFormat.valueMarshaller);
            }
            return new DataFormat(this.keyType, this.valueType, this.keyMarshaller, this.valueMarshaller);
        }
    }
}

