/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorCollection;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.commons.util.RemovableCloseableIterator;

class RemoteCacheValuesCollection<V>
extends AbstractCollection<V>
implements CloseableIteratorCollection<V> {
    private final InternalRemoteCache<?, V> remoteCache;
    private final IntSet segments;

    RemoteCacheValuesCollection(InternalRemoteCache<?, V> remoteCache, IntSet segments) {
        this.remoteCache = remoteCache;
        this.segments = segments;
    }

    @Override
    public CloseableIterator<V> iterator() {
        CloseableIterator<Map.Entry<?, V>> entryIterator = this.remoteCache.entryIterator(this.segments);
        return new IteratorMapper<Map.Entry, Object>(new RemovableCloseableIterator<Map.Entry>(entryIterator, e -> this.remoteCache.remove(e.getKey(), e.getValue())), Map.Entry::getValue);
    }

    @Override
    public CloseableSpliterator<V> spliterator() {
        return Closeables.spliterator(this.iterator(), Long.MAX_VALUE, 4352);
    }

    @Override
    public Stream<V> stream() {
        return Closeables.stream(this.spliterator(), false);
    }

    @Override
    public Stream<V> parallelStream() {
        return Closeables.stream(this.spliterator(), true);
    }

    @Override
    public int size() {
        return this.remoteCache.size();
    }

    @Override
    public void clear() {
        this.remoteCache.clear();
    }

    @Override
    public boolean contains(Object o) {
        try (Stream<V> stream = this.stream();){
            boolean bl = stream.anyMatch(v -> Objects.deepEquals(v, o));
            return bl;
        }
    }

    @Override
    public boolean remove(Object o) {
        Objects.requireNonNull(o);
        try (Iterator iter = this.iterator();){
            while (iter.hasNext()) {
                if (!o.equals(iter.next())) continue;
                iter.remove();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

