/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.DecoderException;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class FaultTolerantPingOperation
extends RetryOnFailureOperation<PingResponse> {
    private final PingResponse.Decoder responseBuilder;

    protected FaultTolerantPingOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg) {
        super((short)23, (short)24, codec, channelFactory, cacheName, clientTopology, flags, cfg, null, null);
        this.responseBuilder = new PingResponse.Decoder(cfg.version());
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.sendHeaderAndRead(channel);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        PingResponse pingResponse;
        this.responseBuilder.processResponse(this.codec, buf, decoder);
        if (HotRodConstants.isSuccess(status)) {
            pingResponse = this.responseBuilder.build(status);
            if (pingResponse.getVersion() != null && this.cfg.version() == ProtocolVersion.PROTOCOL_VERSION_AUTO) {
                this.channelFactory.setNegotiatedCodec(pingResponse.getVersion().getCodec());
            }
        } else {
            String hexStatus = Integer.toHexString(status);
            if (log.isTraceEnabled()) {
                log.tracef("Unknown response status: %s", (Object)hexStatus);
            }
            throw new InvalidResponseException("Unexpected response status: " + hexStatus);
        }
        this.complete(pingResponse);
    }

    @Override
    protected Throwable handleException(Throwable cause, Channel channel, SocketAddress address) {
        while (cause instanceof DecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        PingResponse pingResponse = new PingResponse(cause);
        if (pingResponse.isCacheNotFound()) {
            this.complete(pingResponse);
            return null;
        }
        return super.handleException(cause, channel, address);
    }

    @Override
    protected void reset() {
        super.reset();
        this.responseBuilder.reset();
    }
}

