/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public class ServiceFinder {
    private static final Log LOG = LogFactory.getLog(ServiceFinder.class);

    public static <T> Collection<T> load(Class<T> contract, ClassLoader ... loaders) {
        LinkedHashMap services = new LinkedHashMap();
        if (loaders.length == 0) {
            try {
                ServiceLoader<T> loadedServices = ServiceLoader.load(contract);
                ServiceFinder.addServices(loadedServices, services);
            }
            catch (Exception exception) {}
        } else {
            for (ClassLoader loader : loaders) {
                if (loader == null) {
                    throw new NullPointerException();
                }
                try {
                    ServiceLoader<T> loadedServices = ServiceLoader.load(contract, loader);
                    ServiceFinder.addServices(loadedServices, services);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (services.isEmpty()) {
            LOG.debugf("No service impls found: %s", (Object)contract.getSimpleName());
        }
        return services.values();
    }

    private static <T> void addServices(ServiceLoader<T> loadedServices, Map<String, T> services) {
        Iterator<T> i = loadedServices.iterator();
        while (i.hasNext()) {
            try {
                T service = i.next();
                if (services.putIfAbsent(service.getClass().getName(), service) == null) {
                    LOG.debugf("Loading service impl: %s", (Object)service.getClass().getName());
                    continue;
                }
                LOG.debugf("Ignoring already loaded service: %s", (Object)service.getClass().getName());
            }
            catch (ServiceConfigurationError e) {
                LOG.debug("Skipping service impl", e);
            }
        }
    }
}

