/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.infinispan.InfinispanComponent;
import org.apache.camel.component.infinispan.InfinispanConstants;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConsumer;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteManager;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.service.ServiceHelper;

@UriEndpoint(firstVersion="2.13.0", scheme="infinispan", title="Infinispan", syntax="infinispan:cacheName", category={Category.CACHE, Category.CLUSTERING}, headersClass=InfinispanConstants.class)
public class InfinispanRemoteEndpoint
extends InfinispanEndpoint
implements EndpointServiceLocation {
    @UriPath(description="The name of the cache to use. Use current to use the existing cache name from the currently configured cached manager. Or use default for the default cache manager name.")
    @Metadata(required=true)
    private final String cacheName;
    @UriParam
    private final InfinispanRemoteConfiguration configuration;
    private final InfinispanRemoteManager manager;

    public InfinispanRemoteEndpoint(String uri, String cacheName, InfinispanComponent component, InfinispanRemoteConfiguration configuration) {
        super(uri, component);
        this.cacheName = cacheName;
        this.configuration = configuration;
        this.manager = new InfinispanRemoteManager(component.getCamelContext(), configuration);
    }

    @Override
    public String getServiceUrl() {
        if (this.configuration.getHosts() != null) {
            return this.configuration.getHosts();
        }
        return null;
    }

    @Override
    public String getServiceProtocol() {
        return "infinispan";
    }

    @Override
    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getUsername() != null) {
            return Map.of("username", this.configuration.getUsername());
        }
        return null;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService(this.manager);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService(this.manager);
    }

    @Override
    public Producer createProducer() throws Exception {
        return new InfinispanRemoteProducer((InfinispanEndpoint)this, this.cacheName, this.manager, this.configuration);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        InfinispanRemoteConsumer consumer = new InfinispanRemoteConsumer((InfinispanEndpoint)this, processor, this.cacheName, this.manager, this.configuration);
        this.configureConsumer(consumer);
        return consumer;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public InfinispanRemoteConfiguration getConfiguration() {
        return this.configuration;
    }
}

