/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.engine.AbstractDynamicRegistry;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.NormalizedUri;

public class DefaultEndpointRegistry
extends AbstractDynamicRegistry<NormalizedEndpointUri, Endpoint>
implements EndpointRegistry {
    public DefaultEndpointRegistry(CamelContext context) {
        super(context, CamelContextHelper.getMaximumEndpointCacheSize(context));
    }

    public DefaultEndpointRegistry(CamelContext context, Map<NormalizedEndpointUri, Endpoint> endpoints) {
        this(context);
        if (!context.isStarted()) {
            this.staticMap.putAll(endpoints);
        } else {
            this.putAll(endpoints);
        }
    }

    @Override
    public boolean isStatic(String key) {
        return this.isStatic(NormalizedUri.newNormalizedUri(key, false));
    }

    @Override
    public boolean isDynamic(String key) {
        return this.isDynamic(NormalizedUri.newNormalizedUri(key, false));
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String str = (String)key;
            key = NormalizedUri.newNormalizedUri(str, false);
        }
        return super.containsKey(key);
    }

    @Override
    public String toString() {
        return "EndpointRegistry for " + this.context.getName() + " [capacity: " + this.maxCacheSize + "]";
    }
}

