/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.logging;

import io.netty.channel.Channel;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.client.hotrod.event.IncorrectClientListenerException;
import org.infinispan.client.hotrod.exceptions.CacheNotTransactionalException;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.commons.dataconversion.MediaType;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final AtomicBoolean openTelemetryPropagationEnabled_$Once = new AtomicBoolean(false);
    private static final AtomicBoolean openTelemetryPropagationDisabled_$Once = new AtomicBoolean(false);

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void couldNotFindPropertiesFile(String propertiesFile) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.couldNotFindPropertiesFile$str(), (Object)propertiesFile);
    }

    protected String couldNotFindPropertiesFile$str() {
        return "ISPN004001: Could not find '%s' file in classpath, using defaults.";
    }

    @Override
    public final void unstartedRemoteCacheManager() {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.unstartedRemoteCacheManager$str(), new Object[0]);
    }

    protected String unstartedRemoteCacheManager$str() {
        return "ISPN004002: Cannot perform operations on a cache associated with an unstarted RemoteCacheManager. Use RemoteCacheManager.start before using the remote cache.";
    }

    protected String invalidMagicNumber$str() {
        return "ISPN004003: Invalid magic number. Expected %#x and received %#x";
    }

    @Override
    public final InvalidResponseException invalidMagicNumber(short expectedMagicNumber, short receivedMagic) {
        InvalidResponseException result = new InvalidResponseException(String.format(this.getLoggingLocale(), this.invalidMagicNumber$str(), expectedMagicNumber, receivedMagic));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void errorFromServer(String message) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.errorFromServer$str(), (Object)message);
    }

    protected String errorFromServer$str() {
        return "ISPN004005: Error received from the server: %s";
    }

    @Override
    public final void newTopology(int viewId, int age, int topologySize, Collection<? extends SocketAddress> addresses) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.newTopology$str(), viewId, age, topologySize, addresses);
    }

    protected String newTopology$str() {
        return "ISPN004006: Server sent new topology view (id=%d, age=%d) containing %d addresses: %s";
    }

    @Override
    public final void exceptionAndNoRetriesLeft(int retry, int maxRetries, Throwable te) {
        this.log.logf(FQCN, Logger.Level.ERROR, te, this.exceptionAndNoRetriesLeft$str(), (Object)retry, (Object)maxRetries);
    }

    protected String exceptionAndNoRetriesLeft$str() {
        return "ISPN004007: Exception encountered. Retry %d out of %d";
    }

    @Override
    public final void noHasHFunctionConfigured(int hashFunctionVersion) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.noHasHFunctionConfigured$str(), (Object)hashFunctionVersion);
    }

    protected String noHasHFunctionConfigured$str() {
        return "ISPN004011: No hash function configured for version: %d";
    }

    @Override
    public final void newServerAdded(SocketAddress server) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.newServerAdded$str(), (Object)server);
    }

    protected String newServerAdded$str() {
        return "ISPN004014: New server added(%s), adding to the pool.";
    }

    @Override
    public final void failedAddingNewServer(SocketAddress server, Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.failedAddingNewServer$str(), (Object)server);
    }

    protected String failedAddingNewServer$str() {
        return "ISPN004015: Failed adding new server %s";
    }

    @Override
    public final void removingServer(SocketAddress server) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.removingServer$str(), (Object)server);
    }

    protected String removingServer$str() {
        return "ISPN004016: Server not in cluster anymore(%s), removing from the pool.";
    }

    @Override
    public final void version(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.version$str(), (Object)version);
    }

    protected String version$str() {
        return "ISPN004021: Infinispan version: %s";
    }

    protected String noSSLTrustManagerConfiguration$str() {
        return "ISPN004024: SSL Enabled but no TrustStore specified";
    }

    @Override
    public final CacheConfigurationException noSSLTrustManagerConfiguration() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.noSSLTrustManagerConfiguration$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingKeyStorePassword$str() {
        return "ISPN004025: A password is required to open the KeyStore '%s'";
    }

    @Override
    public final CacheConfigurationException missingKeyStorePassword(String keyStore) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingKeyStorePassword$str(), keyStore));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingTrustStorePassword$str() {
        return "ISPN004026: A password is required to open the TrustStore '%s'";
    }

    @Override
    public final CacheConfigurationException missingTrustStorePassword(String trustStore) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingTrustStorePassword$str(), trustStore));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xorSSLContext$str() {
        return "ISPN004027: Cannot configure custom KeyStore and/or TrustStore when specifying a SSLContext";
    }

    @Override
    public final CacheConfigurationException xorSSLContext() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.xorSSLContext$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String parseErrorServerAddress$str() {
        return "ISPN004028: Unable to parse server IP address %s";
    }

    @Override
    public final CacheConfigurationException parseErrorServerAddress(String server) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.parseErrorServerAddress$str(), server));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMaxRetries$str() {
        return "ISPN004029: Invalid max_retries (value=%s). Value should be greater or equal than zero.";
    }

    @Override
    public final CacheConfigurationException invalidMaxRetries(int retriesPerServer) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidMaxRetries$str(), retriesPerServer));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAuthenticationConfiguration$str() {
        return "ISPN004030: Cannot enable authentication without specifying either a username, a token, a client Subject or a CallbackHandler";
    }

    @Override
    public final CacheConfigurationException invalidAuthenticationConfiguration() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidAuthenticationConfiguration$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedMech$str() {
        return "ISPN004031: The selected authentication mechanism '%s' is not among the supported server mechanisms: %s";
    }

    @Override
    public final SecurityException unsupportedMech(String authMech, List<String> serverMechs) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.unsupportedMech$str(), authMech, serverMechs));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToUnmarshallBytes$str() {
        return "ISPN004034: Unable to unmarshall bytes %s";
    }

    @Override
    public final HotRodClientException unableToUnmarshallBytes(String bytes, Exception e) {
        HotRodClientException result = new HotRodClientException(String.format(this.getLoggingLocale(), this.unableToUnmarshallBytes$str(), bytes), e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String exceptionInvokingListener$str() {
        return "ISPN004035: Caught exception [%s] while invoking method [%s] on listener instance: %s";
    }

    @Override
    public final CacheListenerException exceptionInvokingListener(String name, Method m, Object target, Throwable cause) {
        CacheListenerException result = new CacheListenerException(String.format(this.getLoggingLocale(), this.exceptionInvokingListener$str(), name, m, target), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incorrectClientListener2$str() {
        return "ISPN004036: Methods annotated with %s must accept exactly one parameter, of assignable from type %s";
    }

    @Override
    public final IncorrectClientListenerException incorrectClientListener(String annotationName, Collection<?> allowedParameters) {
        IncorrectClientListenerException result = new IncorrectClientListenerException(String.format(this.getLoggingLocale(), this.incorrectClientListener2$str(), annotationName, allowedParameters));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incorrectClientListener1$str() {
        return "ISPN004037: Methods annotated with %s should have a return type of void.";
    }

    @Override
    public final IncorrectClientListenerException incorrectClientListener(String annotationName) {
        IncorrectClientListenerException result = new IncorrectClientListenerException(String.format(this.getLoggingLocale(), this.incorrectClientListener1$str(), annotationName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unexpectedErrorConsumingEvent(Object event, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unexpectedErrorConsumingEvent$str(), event);
    }

    protected String unexpectedErrorConsumingEvent$str() {
        return "ISPN004038: Unexpected error consuming event %s";
    }

    @Override
    public final void unableToReadEventFromServer(Throwable t, SocketAddress server) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.unableToReadEventFromServer$str(), (Object)server);
    }

    protected String unableToReadEventFromServer$str() {
        return "ISPN004039: Unable to complete reading event from server %s";
    }

    protected String missingClientListenerAnnotation$str() {
        return "ISPN004040: Cache listener class %s must be annotated with org.infinispan.client.hotrod.annotation.ClientListener";
    }

    @Override
    public final IncorrectClientListenerException missingClientListenerAnnotation(String className) {
        IncorrectClientListenerException result = new IncorrectClientListenerException(String.format(this.getLoggingLocale(), this.missingClientListenerAnnotation$str(), className));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownEvent$str() {
        return "ISPN004041: Unknown event type %s received";
    }

    @Override
    public final HotRodClientException unknownEvent(short eventTypeId) {
        HotRodClientException result = new HotRodClientException(String.format(this.getLoggingLocale(), this.unknownEvent$str(), eventTypeId));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nearCacheMaxEntriesUndefined$str() {
        return "ISPN004045: When enabling near caching, number of max entries must be configured";
    }

    @Override
    public final CacheConfigurationException nearCacheMaxEntriesUndefined() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.nearCacheMaxEntriesUndefined$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void iterationClosed(String iterationId) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.iterationClosed$str(), (Object)iterationId);
    }

    protected String iterationClosed$str() {
        return "ISPN004046: Successfully closed remote iterator '%s'";
    }

    protected String errorClosingIteration$str() {
        return "ISPN004047: Invalid iteration id '%s'";
    }

    @Override
    public final IllegalStateException errorClosingIteration(String iterationId) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.errorClosingIteration$str(), iterationId));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorRetrievingNext$str() {
        return "ISPN004048: Invalid iteration id '%s'";
    }

    @Override
    public final NoSuchElementException errorRetrievingNext(String iterationId) {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.errorRetrievingNext$str(), iterationId));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void switchedToCluster(String clusterName) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.switchedToCluster$str(), (Object)clusterName);
    }

    protected String switchedToCluster$str() {
        return "ISPN004050: Switched to cluster '%s'";
    }

    @Override
    public final void switchedBackToMainCluster() {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.switchedBackToMainCluster$str(), new Object[0]);
    }

    protected String switchedBackToMainCluster$str() {
        return "ISPN004051: Switched back to main cluster";
    }

    @Override
    public final void manuallySwitchedToCluster(String clusterName) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.manuallySwitchedToCluster$str(), (Object)clusterName);
    }

    protected String manuallySwitchedToCluster$str() {
        return "ISPN004052: Manually switched to cluster '%s'";
    }

    @Override
    public final void manuallySwitchedBackToMainCluster() {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.manuallySwitchedBackToMainCluster$str(), new Object[0]);
    }

    protected String manuallySwitchedBackToMainCluster$str() {
        return "ISPN004053: Manually switched back to main cluster";
    }

    protected String missingClusterNameDefinition$str() {
        return "ISPN004054: Name of the failover cluster needs to be specified";
    }

    @Override
    public final CacheConfigurationException missingClusterNameDefinition() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingClusterNameDefinition$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingHostDefinition$str() {
        return "ISPN004055: Host needs to be specified in server definition of failover cluster";
    }

    @Override
    public final CacheConfigurationException missingHostDefinition() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingHostDefinition$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingClusterServersDefinition$str() {
        return "ISPN004056: At least one server address needs to be specified for failover cluster %s";
    }

    @Override
    public final CacheConfigurationException missingClusterServersDefinition(String siteName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingClusterServersDefinition$str(), siteName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateClusterDefinition$str() {
        return "ISPN004057: Duplicate failover cluster %s has been specified";
    }

    @Override
    public final CacheConfigurationException duplicateClusterDefinition(String siteName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateClusterDefinition$str(), siteName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String clientListenerMustUseRawData$str() {
        return "ISPN004058: The client listener must use raw data when it uses a query as a filter: %s";
    }

    @Override
    public final IncorrectClientListenerException clientListenerMustUseRawData(String className) {
        IncorrectClientListenerException result = new IncorrectClientListenerException(String.format(this.getLoggingLocale(), this.clientListenerMustUseRawData$str(), className));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String clientListenerMustUseDesignatedFilterConverterFactory$str() {
        return "ISPN004059: The client listener must use the '%s' filter/converter factory";
    }

    @Override
    public final IncorrectClientListenerException clientListenerMustUseDesignatedFilterConverterFactory(String filterConverterFactoryName) {
        IncorrectClientListenerException result = new IncorrectClientListenerException(String.format(this.getLoggingLocale(), this.clientListenerMustUseDesignatedFilterConverterFactory$str(), filterConverterFactoryName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void ignoringErrorDuringIterationClose(String iterationId, Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.ignoringErrorDuringIterationClose$str(), (Object)iterationId);
    }

    protected String ignoringErrorDuringIterationClose$str() {
        return "ISPN004061: Ignoring error when closing iteration '%s'";
    }

    @Override
    public final void startedIteration(String iterationId) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.startedIteration$str(), (Object)iterationId);
    }

    protected String startedIteration$str() {
        return "ISPN004062: Started iteration '%s'";
    }

    @Override
    public final void iterationTransportObtained(SocketAddress address, String iterationId) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.iterationTransportObtained$str(), (Object)address, (Object)iterationId);
    }

    protected String iterationTransportObtained$str() {
        return "ISPN004063: Channel to %s obtained for iteration '%s'";
    }

    @Override
    public final void trackingSegmentKey(String key, int segment, boolean isTracked) {
        this.log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, this.trackingSegmentKey$str(), (Object)key, (Object)segment, (Object)isTracked);
    }

    protected String trackingSegmentKey$str() {
        return "ISPN004064: Tracking key %s belonging to segment %d, already tracked? = %b";
    }

    protected String callbackHandlerAndUsernameMutuallyExclusive$str() {
        return "ISPN004067: Cannot specify both a callback handler and a username/token for authentication";
    }

    @Override
    public final CacheConfigurationException callbackHandlerAndUsernameMutuallyExclusive() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.callbackHandlerAndUsernameMutuallyExclusive$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String channelInactive$str() {
        return "ISPN004069: Connection to %s is not active.";
    }

    @Override
    public final TransportException channelInactive(SocketAddress address1, SocketAddress address2) {
        TransportException result = new TransportException(String.format(this.getLoggingLocale(), this.channelInactive$str(), address2), address1);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToAddListener$str() {
        return "ISPN004070: Failed to add client listener %s, server responded with status %d";
    }

    @Override
    public final HotRodClientException failedToAddListener(Object listener, short status) {
        HotRodClientException result = new HotRodClientException(String.format(this.getLoggingLocale(), this.failedToAddListener$str(), listener, status));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String connectionClosed$str() {
        return "ISPN004071: Connection to %s was closed while waiting for response.";
    }

    @Override
    public final TransportException connectionClosed(SocketAddress address1, SocketAddress address2) {
        TransportException result = new TransportException(String.format(this.getLoggingLocale(), this.connectionClosed$str(), address2), address1);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void cannotCreateAsyncThread(int maxPoolSize) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.cannotCreateAsyncThread$str(), (Object)maxPoolSize);
    }

    protected String cannotCreateAsyncThread$str() {
        return "ISPN004072: Cannot create another async thread. Please increase 'infinispan.client.hotrod.default_executor_factory.pool_size' (current value is %d).";
    }

    @Override
    public final void epollNotAvailable(String cause) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.epollNotAvailable$str(), (Object)cause);
    }

    protected String epollNotAvailable$str() {
        return "ISPN004074: Native Epoll transport not available, using NIO instead: %s";
    }

    protected String trustStoreFileAndPathExclusive$str() {
        return "ISPN004075: TrustStoreFileName and TrustStorePath are mutually exclusive";
    }

    @Override
    public final CacheConfigurationException trustStoreFileAndPathExclusive() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.trustStoreFileAndPathExclusive$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownMessageId$str() {
        return "ISPN004076: Unknown message id %d; cannot find matching request";
    }

    @Override
    public final IllegalStateException unknownMessageId(long messageId) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownMessageId$str(), messageId));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorFromUnknownOperation$str() {
        return "ISPN004077: Closing channel %s due to error in unknown operation.";
    }

    @Override
    public final TransportException errorFromUnknownOperation(Channel channel, Throwable cause, SocketAddress address) {
        TransportException result = new TransportException(String.format(this.getLoggingLocale(), this.errorFromUnknownOperation$str(), channel), cause, address);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noMoreOperationsAllowed$str() {
        return "ISPN004078: This channel is about to be closed and does not accept any further operations.";
    }

    @Override
    public final HotRodClientException noMoreOperationsAllowed() {
        HotRodClientException result = new HotRodClientException(String.format(this.getLoggingLocale(), this.noMoreOperationsAllowed$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedListenerId$str() {
        return "ISPN004079: Unexpected listenerId %s";
    }

    @Override
    public final IllegalStateException unexpectedListenerId(String listenerId) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unexpectedListenerId$str(), listenerId));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String operationIsNotAddClientListener$str() {
        return "ISPN004080: Event should use messageId of previous Add Client Listener operation but id is %d and operation is %s";
    }

    @Override
    public final IllegalStateException operationIsNotAddClientListener(long messageId, String operation) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.operationIsNotAddClientListener$str(), messageId, operation));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTransactionMode$str() {
        return "ISPN004082: TransactionMode must be non-null.";
    }

    @Override
    public final CacheConfigurationException invalidTransactionMode() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidTransactionMode$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTransactionManagerLookup$str() {
        return "ISPN004083: TransactionManagerLookup must be non-null";
    }

    @Override
    public final CacheConfigurationException invalidTransactionManagerLookup() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidTransactionManagerLookup$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheDoesNotSupportTransactions$str() {
        return "ISPN004084: Cache %s doesn't support transactions. Please check the documentation how to configure it properly.";
    }

    @Override
    public final CacheNotTransactionalException cacheDoesNotSupportTransactions(String name) {
        CacheNotTransactionalException result = new CacheNotTransactionalException(String.format(this.getLoggingLocale(), this.cacheDoesNotSupportTransactions$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void invalidTxServerConfig(String name, Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.ERROR, throwable, this.invalidTxServerConfig$str(), (Object)name);
    }

    protected String invalidTxServerConfig$str() {
        return "ISPN004085: Error checking server configuration for transactional cache %s";
    }

    @Override
    public final void exceptionDuringPrepare(Xid xid, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.exceptionDuringPrepare$str(), (Object)xid);
    }

    protected String exceptionDuringPrepare$str() {
        return "ISPN004086: Exception caught while preparing transaction %s";
    }

    @Override
    public final void nearCacheMaxIdleUnsupported() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.nearCacheMaxIdleUnsupported$str(), new Object[0]);
    }

    protected String nearCacheMaxIdleUnsupported$str() {
        return "ISPN004087: Use of maxIdle expiration with a near cache is unsupported.";
    }

    protected String invalidTransactionTimeout$str() {
        return "ISPN004088: Transactions timeout must be positive";
    }

    @Override
    public final HotRodClientException invalidTransactionTimeout() {
        HotRodClientException result = new HotRodClientException(String.format(this.getLoggingLocale(), this.invalidTransactionTimeout$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String transactionTableNotStarted$str() {
        return "ISPN004089: TransactionTable is not started!";
    }

    @Override
    public final HotRodClientException transactionTableNotStarted() {
        HotRodClientException result = new HotRodClientException(String.format(this.getLoggingLocale(), this.transactionTableNotStarted$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidResponse$str() {
        return "ISPN004090: [%s] Invalid response operation. Expected %#x and received %#x";
    }

    @Override
    public final InvalidResponseException invalidResponse(String cacheName, short opRespCode, double receivedOpCode) {
        InvalidResponseException result = new InvalidResponseException(String.format(this.getLoggingLocale(), this.invalidResponse$str(), cacheName, opRespCode, receivedOpCode));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jmxRegistrationFailure$str() {
        return "ISPN004091: MBean registration failed";
    }

    @Override
    public final HotRodClientException jmxRegistrationFailure(Throwable cause) {
        HotRodClientException result = new HotRodClientException(String.format(this.getLoggingLocale(), this.jmxRegistrationFailure$str(), new Object[0]), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jmxUnregistrationFailure$str() {
        return "ISPN004092: MBean unregistration failed";
    }

    @Override
    public final HotRodClientException jmxUnregistrationFailure(Throwable cause) {
        HotRodClientException result = new HotRodClientException(String.format(this.getLoggingLocale(), this.jmxUnregistrationFailure$str(), new Object[0]), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String oauthBearerWithoutToken$str() {
        return "ISPN004093: OAUTHBEARER mechanism selected without providing a token";
    }

    @Override
    public final CacheConfigurationException oauthBearerWithoutToken() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.oauthBearerWithoutToken$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String remoteCacheTemplateNameXorConfiguration$str() {
        return "ISPN004094: Cannot specify both template name and configuration for '%s'";
    }

    @Override
    public final CacheConfigurationException remoteCacheTemplateNameXorConfiguration(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.remoteCacheTemplateNameXorConfiguration$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notaHotRodURI$str() {
        return "ISPN004095: Not a Hot Rod URI: %s";
    }

    @Override
    public final IllegalArgumentException notaHotRodURI(String uri) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.notaHotRodURI$str(), uri));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPropertyFormat$str() {
        return "ISPN004096: Invalid property format in URI: %s";
    }

    @Override
    public final IllegalArgumentException invalidPropertyFormat(String part) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidPropertyFormat$str(), part));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateCacheConfiguration$str() {
        return "ISPN004097: Illegal attempt to redefine an already existing cache configuration: %s";
    }

    @Override
    public final IllegalArgumentException duplicateCacheConfiguration(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.duplicateCacheConfiguration$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void closingChannelAfterError(Channel channel, Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.closingChannelAfterError$str(), (Object)channel);
    }

    protected String closingChannelAfterError$str() {
        return "ISPN004098: Closing connection %s due to transport error";
    }

    @Override
    public final void warnPerfRemoteIterationWithoutPagination(String query) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.warnPerfRemoteIterationWithoutPagination$str(), (Object)query);
    }

    protected String warnPerfRemoteIterationWithoutPagination$str() {
        return "ISPN004099: Remote iteration over the entire result set of query '%s' without using pagination options is inefficient for large result sets. Please consider using 'startOffset' and 'maxResults' options.";
    }

    @Override
    public final void throwableDuringPublisher(Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.throwableDuringPublisher$str(), new Object[0]);
    }

    protected String throwableDuringPublisher$str() {
        return "ISPN004100: Error reaching the server during iteration";
    }

    @Override
    public final void deprecatedConfigurationProperty(String property) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.deprecatedConfigurationProperty$str(), (Object)property);
    }

    protected String deprecatedConfigurationProperty$str() {
        return "ISPN004101: Configuration property '%s' has been deprecated";
    }

    protected String nearCacheMaxEntriesPositiveWithBloom$str() {
        return "ISPN004102: Near cache number of max entries must be a positive number when using bloom filter optimization, it was %d";
    }

    @Override
    public final CacheConfigurationException nearCacheMaxEntriesPositiveWithBloom(int maxEntries) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.nearCacheMaxEntriesPositiveWithBloom$str(), maxEntries));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String bloomFilterRequiresMaxActiveOneAndWait$str() {
        return "ISPN004103: Near cache with bloom filter requires pool max active to be 1, was %s, and exhausted action to be WAIT, was %s";
    }

    @Override
    public final CacheConfigurationException bloomFilterRequiresMaxActiveOneAndWait(int maxActive, ExhaustedAction action) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.bloomFilterRequiresMaxActiveOneAndWait$str(), new Object[]{maxActive, action}));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToCreatePredefinedSerializationContextInitializer(String className, Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.WARN, throwable, this.failedToCreatePredefinedSerializationContextInitializer$str(), (Object)className);
    }

    protected String failedToCreatePredefinedSerializationContextInitializer$str() {
        return "ISPN004104: Failed to load and create an optional ProtoStream serialization context initializer: %s";
    }

    @Override
    public final void revertCacheToInitialServerList(Collection<String> cacheName) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.revertCacheToInitialServerList$str(), (Object)cacheName);
    }

    protected String revertCacheToInitialServerList$str() {
        return "ISPN004105: Reverting to the initial server list for caches %s";
    }

    @Override
    public final void invalidActiveCountAfterClose(Channel channel) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.invalidActiveCountAfterClose$str(), (Object)channel);
    }

    protected String invalidActiveCountAfterClose$str() {
        return "ISPN004106: Invalid active count after closing channel %s";
    }

    @Override
    public final void invalidCreatedCountAfterClose(Channel channel) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.invalidCreatedCountAfterClose$str(), (Object)channel);
    }

    protected String invalidCreatedCountAfterClose$str() {
        return "ISPN004107: Invalid created count after closing channel %s";
    }

    @Override
    public final void ioUringNotAvailable(String cause) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.ioUringNotAvailable$str(), (Object)cause);
    }

    protected String ioUringNotAvailable$str() {
        return "ISPN004108: Native IOUring transport not available, using NIO instead: %s";
    }

    @Override
    public final void noOpenTelemetryAPI() {
        this.log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, this.noOpenTelemetryAPI$str(), new Object[0]);
    }

    protected String noOpenTelemetryAPI$str() {
        return "ISPN004109: OpenTelemetry API is not present in the classpath. Client context tracing will not be propagated.";
    }

    @Override
    public final void openTelemetryPropagationEnabled() {
        if (this.log.isEnabled(Logger.Level.TRACE) && openTelemetryPropagationEnabled_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, this.openTelemetryPropagationEnabled$str(), new Object[0]);
        }
    }

    protected String openTelemetryPropagationEnabled$str() {
        return "ISPN004110: OpenTelemetry API is present in the classpath and the tracing propagation is enabled. Client context tracing will be propagated.";
    }

    @Override
    public final void openTelemetryPropagationDisabled() {
        if (this.log.isEnabled(Logger.Level.TRACE) && openTelemetryPropagationDisabled_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, this.openTelemetryPropagationDisabled$str(), new Object[0]);
        }
    }

    protected String openTelemetryPropagationDisabled$str() {
        return "ISPN004111: OpenTelemetry API is present in the classpath, but the tracing propagation is not enabled. Client context tracing will not be propagated.";
    }

    protected String missingSniHostName$str() {
        return "ISPN004112: The SNI hostname is required when hostname validation is enabled";
    }

    @Override
    public final CacheConfigurationException missingSniHostName() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingSniHostName$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void queryDisabled() {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.queryDisabled$str(), new Object[0]);
    }

    protected String queryDisabled$str() {
        return "ISPN004113: Query module not found. Queries are disabled.";
    }

    protected String queryNotSupported$str() {
        return "ISPN004114: Query module not found. Add remote-query-client to the classpath.";
    }

    @Override
    public final HotRodClientException queryNotSupported() {
        HotRodClientException result = new HotRodClientException(String.format(this.getLoggingLocale(), this.queryNotSupported$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void errorCreatingPropagationContext(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.WARN, throwable, this.errorCreatingPropagationContext$str(), new Object[0]);
    }

    protected String errorCreatingPropagationContext$str() {
        return "ISPN004115: Unexpected error while creating the tracing propagation context. Client context tracing will not be propagated.";
    }

    @Override
    public final void serverKeyTypeNotRecognized(MediaType serverKeyType) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.serverKeyTypeNotRecognized$str(), (Object)serverKeyType);
    }

    protected String serverKeyTypeNotRecognized$str() {
        return "ISPN004116: Client cannot marshall the server's key media type ('%s'). This could cause poor performance.";
    }

    @Override
    public final void invalidateNearDefaultMarshallerMismatch(String cacheName, Class<?> clazz, MediaType serverKeyType) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.invalidateNearDefaultMarshallerMismatch$str(), (Object)cacheName, (Object)clazz, (Object)serverKeyType);
    }

    protected String invalidateNearDefaultMarshallerMismatch$str() {
        return "ISPN004117: Cache '%s' with marshaller %s does not handle server storage type '%s'. Configure the cache or default marshaller.";
    }
}

