/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.dto;

import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import okio.Buffer;
import org.influxdb.InfluxDBIOException;
import org.influxdb.dto.Query;

public final class BoundParameterQuery
extends Query {
    private final Map<String, Object> params = new HashMap<String, Object>();

    private BoundParameterQuery(String command, String database) {
        super(command, database, true);
    }

    public String getParameterJsonWithUrlEncoded() {
        try {
            String jsonParameterObject = this.createJsonObject(this.params);
            String urlEncodedJsonParameterObject = BoundParameterQuery.encode(jsonParameterObject);
            return urlEncodedJsonParameterObject;
        }
        catch (IOException e) {
            throw new InfluxDBIOException(e);
        }
    }

    private String createJsonObject(Map<String, Object> parameterMap) throws IOException {
        Buffer b = new Buffer();
        JsonWriter writer = JsonWriter.of(b);
        writer.beginObject();
        for (Map.Entry<String, Object> pair : parameterMap.entrySet()) {
            String name = pair.getKey();
            Object value = pair.getValue();
            if (value instanceof Number) {
                Number number = (Number)value;
                writer.name(name).value(number);
                continue;
            }
            if (value instanceof String) {
                writer.name(name).value((String)value);
                continue;
            }
            if (value instanceof Boolean) {
                writer.name(name).value((Boolean)value);
                continue;
            }
            writer.name(name).value(String.valueOf(value));
        }
        writer.endObject();
        return b.readString(Charset.forName("utf-8"));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.params.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BoundParameterQuery other = (BoundParameterQuery)obj;
        return this.params.equals(other.params);
    }

    public static class QueryBuilder {
        private BoundParameterQuery query;
        private String influxQL;

        public static QueryBuilder newQuery(String influxQL) {
            QueryBuilder instance = new QueryBuilder();
            instance.influxQL = influxQL;
            return instance;
        }

        public QueryBuilder forDatabase(String database) {
            this.query = new BoundParameterQuery(this.influxQL, database);
            return this;
        }

        public QueryBuilder bind(String placeholder, Object value) {
            if (this.query == null) {
                this.query = new BoundParameterQuery(this.influxQL, null);
            }
            this.query.params.put(placeholder, value);
            return this;
        }

        public BoundParameterQuery create() {
            return this.query;
        }
    }
}

