/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonValueReader;
import com.squareup.moshi.JsonValueWriter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public abstract class JsonAdapter<T> {
    @CheckReturnValue
    @Nullable
    public abstract T fromJson(JsonReader var1) throws IOException;

    @CheckReturnValue
    @Nullable
    public final T fromJson(BufferedSource source2) throws IOException {
        return this.fromJson(JsonReader.of(source2));
    }

    @CheckReturnValue
    @Nullable
    public final T fromJson(String string) throws IOException {
        JsonReader reader = JsonReader.of(new Buffer().writeUtf8(string));
        T result = this.fromJson(reader);
        if (!this.isLenient() && reader.peek() != JsonReader.Token.END_DOCUMENT) {
            throw new JsonDataException("JSON document was not fully consumed.");
        }
        return result;
    }

    public abstract void toJson(JsonWriter var1, @Nullable T var2) throws IOException;

    public final void toJson(BufferedSink sink2, @Nullable T value) throws IOException {
        JsonWriter writer = JsonWriter.of(sink2);
        this.toJson(writer, value);
    }

    @CheckReturnValue
    public final String toJson(@Nullable T value) {
        Buffer buffer = new Buffer();
        try {
            this.toJson(buffer, value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return buffer.readUtf8();
    }

    @CheckReturnValue
    @Nullable
    public final Object toJsonValue(@Nullable T value) {
        JsonValueWriter writer = new JsonValueWriter();
        try {
            this.toJson(writer, value);
            return writer.root();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @CheckReturnValue
    @Nullable
    public final T fromJsonValue(@Nullable Object value) {
        JsonValueReader reader = new JsonValueReader(value);
        try {
            return this.fromJson(reader);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @CheckReturnValue
    public final JsonAdapter<T> serializeNulls() {
        final JsonAdapter delegate = this;
        return new JsonAdapter<T>(){

            @Override
            @Nullable
            public T fromJson(JsonReader reader) throws IOException {
                return delegate.fromJson(reader);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void toJson(JsonWriter writer, @Nullable T value) throws IOException {
                boolean serializeNulls = writer.getSerializeNulls();
                writer.setSerializeNulls(true);
                try {
                    delegate.toJson(writer, value);
                }
                finally {
                    writer.setSerializeNulls(serializeNulls);
                }
            }

            @Override
            boolean isLenient() {
                return delegate.isLenient();
            }

            public String toString() {
                return delegate + ".serializeNulls()";
            }
        };
    }

    @CheckReturnValue
    public final JsonAdapter<T> nullSafe() {
        final JsonAdapter delegate = this;
        return new JsonAdapter<T>(){

            @Override
            @Nullable
            public T fromJson(JsonReader reader) throws IOException {
                if (reader.peek() == JsonReader.Token.NULL) {
                    return reader.nextNull();
                }
                return delegate.fromJson(reader);
            }

            @Override
            public void toJson(JsonWriter writer, @Nullable T value) throws IOException {
                if (value == null) {
                    writer.nullValue();
                } else {
                    delegate.toJson(writer, value);
                }
            }

            @Override
            boolean isLenient() {
                return delegate.isLenient();
            }

            public String toString() {
                return delegate + ".nullSafe()";
            }
        };
    }

    @CheckReturnValue
    public final JsonAdapter<T> nonNull() {
        final JsonAdapter delegate = this;
        return new JsonAdapter<T>(){

            @Override
            @Nullable
            public T fromJson(JsonReader reader) throws IOException {
                if (reader.peek() == JsonReader.Token.NULL) {
                    throw new JsonDataException("Unexpected null at " + reader.getPath());
                }
                return delegate.fromJson(reader);
            }

            @Override
            public void toJson(JsonWriter writer, @Nullable T value) throws IOException {
                if (value == null) {
                    throw new JsonDataException("Unexpected null at " + writer.getPath());
                }
                delegate.toJson(writer, value);
            }

            @Override
            boolean isLenient() {
                return delegate.isLenient();
            }

            public String toString() {
                return delegate + ".nonNull()";
            }
        };
    }

    @CheckReturnValue
    public final JsonAdapter<T> lenient() {
        final JsonAdapter delegate = this;
        return new JsonAdapter<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public T fromJson(JsonReader reader) throws IOException {
                boolean lenient = reader.isLenient();
                reader.setLenient(true);
                try {
                    Object t = delegate.fromJson(reader);
                    return t;
                }
                finally {
                    reader.setLenient(lenient);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void toJson(JsonWriter writer, @Nullable T value) throws IOException {
                boolean lenient = writer.isLenient();
                writer.setLenient(true);
                try {
                    delegate.toJson(writer, value);
                }
                finally {
                    writer.setLenient(lenient);
                }
            }

            @Override
            boolean isLenient() {
                return true;
            }

            public String toString() {
                return delegate + ".lenient()";
            }
        };
    }

    @CheckReturnValue
    public final JsonAdapter<T> failOnUnknown() {
        final JsonAdapter delegate = this;
        return new JsonAdapter<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public T fromJson(JsonReader reader) throws IOException {
                boolean skipForbidden = reader.failOnUnknown();
                reader.setFailOnUnknown(true);
                try {
                    Object t = delegate.fromJson(reader);
                    return t;
                }
                finally {
                    reader.setFailOnUnknown(skipForbidden);
                }
            }

            @Override
            public void toJson(JsonWriter writer, @Nullable T value) throws IOException {
                delegate.toJson(writer, value);
            }

            @Override
            boolean isLenient() {
                return delegate.isLenient();
            }

            public String toString() {
                return delegate + ".failOnUnknown()";
            }
        };
    }

    @CheckReturnValue
    public JsonAdapter<T> indent(final String indent) {
        if (indent == null) {
            throw new NullPointerException("indent == null");
        }
        final JsonAdapter delegate = this;
        return new JsonAdapter<T>(){

            @Override
            @Nullable
            public T fromJson(JsonReader reader) throws IOException {
                return delegate.fromJson(reader);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void toJson(JsonWriter writer, @Nullable T value) throws IOException {
                String originalIndent = writer.getIndent();
                writer.setIndent(indent);
                try {
                    delegate.toJson(writer, value);
                }
                finally {
                    writer.setIndent(originalIndent);
                }
            }

            @Override
            boolean isLenient() {
                return delegate.isLenient();
            }

            public String toString() {
                return delegate + ".indent(\"" + indent + "\")";
            }
        };
    }

    boolean isLenient() {
        return false;
    }

    public static interface Factory {
        @CheckReturnValue
        @Nullable
        public JsonAdapter<?> create(Type var1, Set<? extends Annotation> var2, Moshi var3);
    }
}

