/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.influxdb2;

import com.influxdb.client.InfluxDBClient;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.influxdb2.InfluxDb2Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;

@Component(value="influxdb2")
public class InfluxDb2Component
extends DefaultComponent {
    @Metadata(autowired=true)
    private InfluxDBClient influxDBClient;

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        InfluxDb2Endpoint endpoint = new InfluxDb2Endpoint(uri, this);
        endpoint.setConnectionBean(remaining);
        InfluxDBClient target = this.influxDBClient;
        if (target == null) {
            target = CamelContextHelper.mandatoryLookup(this.getCamelContext(), remaining, InfluxDBClient.class);
        }
        endpoint.setInfluxDBClient(target);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    public InfluxDBClient getInfluxDBClient() {
        return this.influxDBClient;
    }

    public void setInfluxDBClient(InfluxDBClient influxDBClient) {
        this.influxDBClient = influxDBClient;
    }
}

