/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.influxdb2;

import com.influxdb.client.BucketsQuery;
import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.OrganizationsQuery;
import com.influxdb.client.domain.Bucket;
import com.influxdb.client.domain.Organization;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.exceptions.NotFoundException;
import java.util.List;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.influxdb2.InfluxDb2Component;
import org.apache.camel.component.influxdb2.InfluxDb2Constants;
import org.apache.camel.component.influxdb2.InfluxDb2Producer;
import org.apache.camel.component.influxdb2.enums.Operation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.20.0", scheme="influxdb2", title="InfluxDB2", syntax="influxdb2:connectionBean", category={Category.DATABASE}, producerOnly=true, headersClass=InfluxDb2Constants.class)
public class InfluxDb2Endpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDb2Endpoint.class);
    private InfluxDBClient influxDBClient;
    @UriPath
    @Metadata(required=true, description="Connection to the Influx database, of class com.influxdb.client.InfluxDBClient.class.")
    private String connectionBean;
    @UriParam
    @Metadata(required=true, description="The name of the organization where the time series will be stored.")
    private String org;
    @UriParam
    @Metadata(required=true, description="The name of the bucket where the time series will be stored.")
    private String bucket;
    @UriParam(defaultValue="default", description="Define the retention policy to the data created by the endpoint.")
    private String retentionPolicy = "default";
    @UriParam(defaultValue="INSERT", description="Define if this operation is an insert of ping.")
    private Operation operation = Operation.INSERT;
    @UriParam(defaultValue="true", description="Define if we want to auto create the organization if it's not present.")
    private boolean autoCreateOrg = true;
    @UriParam(defaultValue="true", description="Define if we want to auto create the bucket if it's not present.")
    private boolean autoCreateBucket = true;
    @UriParam(defaultValue="ms", description="The format or precision of time series timestamps.")
    private WritePrecision writePrecision = WritePrecision.MS;
    private String orgID;

    public InfluxDb2Endpoint(String uri, InfluxDb2Component component) {
        super(uri, component);
    }

    public InfluxDb2Endpoint() {
    }

    public InfluxDBClient getInfluxDBClient() {
        return this.influxDBClient;
    }

    public void setInfluxDBClient(InfluxDBClient influxDBClient) {
        this.influxDBClient = influxDBClient;
    }

    public String getConnectionBean() {
        return this.connectionBean;
    }

    public void setConnectionBean(String connectionBean) {
        this.connectionBean = connectionBean;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public void setRetentionPolicy(String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public boolean isAutoCreateOrg() {
        return this.autoCreateOrg;
    }

    public void setAutoCreateOrg(boolean autoCreateOrg) {
        this.autoCreateOrg = autoCreateOrg;
    }

    public boolean isAutoCreateBucket() {
        return this.autoCreateBucket;
    }

    public void setAutoCreateBucket(boolean autoCreateBucket) {
        this.autoCreateBucket = autoCreateBucket;
    }

    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    public WritePrecision getWritePrecision() {
        return this.writePrecision;
    }

    public void setWritePrecision(WritePrecision writePrecision) {
        this.writePrecision = writePrecision;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new InfluxDb2Producer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        this.ensureOrgExists();
        this.ensureBucketExists();
    }

    private void ensureOrgExists() {
        Organization organization = null;
        OrganizationsQuery organizationsQuery = new OrganizationsQuery();
        organizationsQuery.setOrg(this.org);
        boolean exists = false;
        try {
            List<Organization> organizations = this.getInfluxDBClient().getOrganizationsApi().findOrganizations(organizationsQuery);
            if (organizations.stream().anyMatch(o -> o.getName().equals(this.org))) {
                exists = true;
                organization = organizations.stream().filter(o -> o.getName().equals(this.org)).findFirst().get();
            }
        }
        catch (NotFoundException ex) {
            exists = false;
        }
        if (!exists && this.autoCreateOrg) {
            LOG.debug("Organization {} doesn't exist. Creating it...", (Object)this.org);
            organization = this.getInfluxDBClient().getOrganizationsApi().createOrganization(this.org);
        }
        if (organization != null) {
            this.setOrgID(organization.getId());
        }
    }

    private void ensureBucketExists() {
        this.ensureOrgExists();
        boolean exists = false;
        BucketsQuery bucketsQuery = new BucketsQuery();
        bucketsQuery.setOrg(this.org);
        bucketsQuery.setName(this.bucket);
        try {
            List<Bucket> buckets = this.getInfluxDBClient().getBucketsApi().findBuckets(bucketsQuery);
            if (buckets.stream().anyMatch(b -> b.getName().equals(this.bucket))) {
                exists = true;
            }
        }
        catch (NotFoundException ex) {
            exists = false;
        }
        if (!exists && this.autoCreateBucket) {
            LOG.debug("Bucket {} doesn't exist. Creating it...", (Object)this.bucket);
            this.getInfluxDBClient().getBucketsApi().createBucket(this.bucket, this.getOrgID());
        }
    }
}

