/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.client.ChecksApi;
import com.influxdb.client.FindOptions;
import com.influxdb.client.domain.Check;
import com.influxdb.client.domain.CheckPatch;
import com.influxdb.client.domain.CheckStatusLevel;
import com.influxdb.client.domain.Checks;
import com.influxdb.client.domain.DashboardQuery;
import com.influxdb.client.domain.DeadmanCheck;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.QueryEditMode;
import com.influxdb.client.domain.TaskStatusType;
import com.influxdb.client.domain.Threshold;
import com.influxdb.client.domain.ThresholdCheck;
import com.influxdb.client.service.ChecksService;
import com.influxdb.internal.AbstractRestClient;
import com.influxdb.utils.Arguments;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import retrofit2.Call;

final class ChecksApiImpl
extends AbstractRestClient
implements ChecksApi {
    private final ChecksService service;

    ChecksApiImpl(ChecksService service) {
        Arguments.checkNotNull(service, "checksService");
        this.service = service;
    }

    @Override
    @Nonnull
    public ThresholdCheck createThresholdCheck(@Nonnull String name, @Nonnull String query, @Nonnull String every, @Nonnull String messageTemplate, @Nonnull Threshold threshold, @Nonnull String orgID) {
        Arguments.checkNotNull(threshold, "threshold");
        List<Threshold> thresholds = Collections.singletonList(threshold);
        return this.createThresholdCheck(name, query, every, messageTemplate, thresholds, orgID);
    }

    @Override
    @Nonnull
    public ThresholdCheck createThresholdCheck(@Nonnull String name, @Nonnull String query, @Nonnull String every, @Nonnull String messageTemplate, @Nonnull List<Threshold> thresholds, @Nonnull String orgID) {
        Arguments.checkNonEmpty(name, "name");
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkDuration(every, "every");
        Arguments.checkNonEmpty(messageTemplate, "messageTemplate");
        Arguments.checkNotNull(thresholds, "thresholds");
        Arguments.checkNonEmpty(orgID, "orgID");
        ThresholdCheck threshold = new ThresholdCheck();
        threshold.every(every).statusMessageTemplate(messageTemplate).thresholds(thresholds).name(name).orgID(orgID).query(this.createDashboardQuery(query)).status(TaskStatusType.ACTIVE);
        return (ThresholdCheck)this.createCheck(threshold);
    }

    @Override
    @Nonnull
    public DeadmanCheck createDeadmanCheck(@Nonnull String name, @Nonnull String query, @Nonnull String every, @Nonnull String timeSince, @Nonnull String staleTime, @Nonnull String messageTemplate, @Nonnull CheckStatusLevel level, @Nonnull String orgID) {
        Arguments.checkNonEmpty(name, "name");
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkDuration(every, "every");
        Arguments.checkDuration(timeSince, "timeSince");
        Arguments.checkDuration(staleTime, "staleTime");
        Arguments.checkNonEmpty(messageTemplate, "messageTemplate");
        Arguments.checkNotNull((Object)level, "level");
        Arguments.checkNonEmpty(orgID, "orgID");
        DeadmanCheck deadman = new DeadmanCheck();
        deadman.every(every).statusMessageTemplate(messageTemplate).level(level).staleTime(staleTime).timeSince(timeSince).name(name).orgID(orgID).query(this.createDashboardQuery(query)).status(TaskStatusType.ACTIVE);
        return (DeadmanCheck)this.createCheck(deadman);
    }

    @Override
    @Nonnull
    public Check createCheck(@Nonnull Check check2) {
        Arguments.checkNotNull(check2, "check");
        Call<Check> call = this.service.createCheck(check2);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public Check updateCheck(@Nonnull Check check2) {
        Arguments.checkNotNull(check2, "check");
        CheckPatch patch = new CheckPatch().name(check2.getName()).description(check2.getDescription()).status(CheckPatch.StatusEnum.fromValue(check2.getStatus().getValue()));
        return this.updateCheck(check2.getId(), patch);
    }

    @Override
    @Nonnull
    public Check updateCheck(@Nonnull String checkID, @Nonnull CheckPatch patch) {
        Arguments.checkNotNull(checkID, "checkID");
        Arguments.checkNotNull(patch, "patch");
        Call<Check> call = this.service.patchChecksID(checkID, patch, null);
        return this.execute(call);
    }

    @Override
    public void deleteCheck(@Nonnull Check check2) {
        Arguments.checkNotNull(check2, "check");
        this.deleteCheck(check2.getId());
    }

    @Override
    public void deleteCheck(@Nonnull String checkID) {
        Arguments.checkNotNull(checkID, "checkID");
        Call<Void> call = this.service.deleteChecksID(checkID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Check findCheckByID(@Nonnull String checkID) {
        Arguments.checkNotNull(checkID, "checkID");
        Call<Check> call = this.service.getChecksID(checkID, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public List<Check> findChecks(@Nonnull String orgID) {
        Arguments.checkNonEmpty(orgID, "orgID");
        return this.findChecks(orgID, new FindOptions()).getChecks();
    }

    @Override
    @Nonnull
    public Checks findChecks(@Nonnull String orgID, @Nonnull FindOptions findOptions) {
        Arguments.checkNonEmpty(orgID, "orgID");
        Arguments.checkNotNull(findOptions, "findOptions");
        Call<Checks> call = this.service.getChecks(orgID, null, findOptions.getOffset(), findOptions.getLimit());
        return this.execute(call);
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull Check check2) {
        Arguments.checkNotNull(check2, "check");
        return this.getLabels(check2.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String checkID) {
        Arguments.checkNonEmpty(checkID, "checkID");
        Call<LabelsResponse> call = this.service.getChecksIDLabels(checkID, null);
        return this.execute(call).getLabels();
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull Label label, @Nonnull Check check2) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(check2, "check");
        return this.addLabel(label.getId(), check2.getId());
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull String labelID, @Nonnull String checkID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(checkID, "checkID");
        LabelMapping labelMapping = new LabelMapping();
        labelMapping.setLabelID(labelID);
        Call<LabelResponse> call = this.service.postChecksIDLabels(checkID, labelMapping, null);
        return this.execute(call);
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull Check check2) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(check2, "check");
        this.deleteLabel(label.getId(), check2.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String checkID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(checkID, "checkID");
        Call<Void> call = this.service.deleteChecksIDLabelsID(checkID, labelID, null);
        this.execute(call);
    }

    @Nonnull
    private DashboardQuery createDashboardQuery(@Nonnull String query) {
        return new DashboardQuery().editMode(QueryEditMode.ADVANCED).text(query);
    }
}

