/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.irc.IrcEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.schwering.irc.lib.ssl.SSLTrustManager;

public class IrcEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        IrcEndpoint target = (IrcEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autorejoin": 
            case "autoRejoin": {
                target.getConfiguration().setAutoRejoin(IrcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(IrcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "channels": {
                target.getConfiguration().setChannels(IrcEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "colors": {
                target.getConfiguration().setColors(IrcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "commandtimeout": 
            case "commandTimeout": {
                target.getConfiguration().setCommandTimeout(IrcEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(IrcEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(IrcEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "keys": {
                target.getConfiguration().setKeys(IrcEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(IrcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "namesonjoin": 
            case "namesOnJoin": {
                target.getConfiguration().setNamesOnJoin(IrcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "nickpassword": 
            case "nickPassword": {
                target.getConfiguration().setNickPassword(IrcEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "nickname": {
                target.getConfiguration().setNickname(IrcEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "onjoin": 
            case "onJoin": {
                target.getConfiguration().setOnJoin(IrcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "onkick": 
            case "onKick": {
                target.getConfiguration().setOnKick(IrcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "onmode": 
            case "onMode": {
                target.getConfiguration().setOnMode(IrcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "onnick": 
            case "onNick": {
                target.getConfiguration().setOnNick(IrcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "onpart": 
            case "onPart": {
                target.getConfiguration().setOnPart(IrcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "onprivmsg": 
            case "onPrivmsg": {
                target.getConfiguration().setOnPrivmsg(IrcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "onquit": 
            case "onQuit": {
                target.getConfiguration().setOnQuit(IrcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "onreply": 
            case "onReply": {
                target.getConfiguration().setOnReply(IrcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "ontopic": 
            case "onTopic": {
                target.getConfiguration().setOnTopic(IrcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "password": {
                target.getConfiguration().setPassword(IrcEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "persistent": {
                target.getConfiguration().setPersistent(IrcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "realname": {
                target.getConfiguration().setRealname(IrcEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                target.getConfiguration().setSslContextParameters(IrcEndpointConfigurer.property(camelContext, SSLContextParameters.class, value));
                return true;
            }
            case "trustmanager": 
            case "trustManager": {
                target.getConfiguration().setTrustManager(IrcEndpointConfigurer.property(camelContext, SSLTrustManager.class, value));
                return true;
            }
            case "username": {
                target.getConfiguration().setUsername(IrcEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autorejoin": 
            case "autoRejoin": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "channels": {
                return String.class;
            }
            case "colors": {
                return Boolean.TYPE;
            }
            case "commandtimeout": 
            case "commandTimeout": {
                return Long.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "keys": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "namesonjoin": 
            case "namesOnJoin": {
                return Boolean.TYPE;
            }
            case "nickpassword": 
            case "nickPassword": {
                return String.class;
            }
            case "nickname": {
                return String.class;
            }
            case "onjoin": 
            case "onJoin": {
                return Boolean.TYPE;
            }
            case "onkick": 
            case "onKick": {
                return Boolean.TYPE;
            }
            case "onmode": 
            case "onMode": {
                return Boolean.TYPE;
            }
            case "onnick": 
            case "onNick": {
                return Boolean.TYPE;
            }
            case "onpart": 
            case "onPart": {
                return Boolean.TYPE;
            }
            case "onprivmsg": 
            case "onPrivmsg": {
                return Boolean.TYPE;
            }
            case "onquit": 
            case "onQuit": {
                return Boolean.TYPE;
            }
            case "onreply": 
            case "onReply": {
                return Boolean.TYPE;
            }
            case "ontopic": 
            case "onTopic": {
                return Boolean.TYPE;
            }
            case "password": {
                return String.class;
            }
            case "persistent": {
                return Boolean.TYPE;
            }
            case "realname": {
                return String.class;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return SSLContextParameters.class;
            }
            case "trustmanager": 
            case "trustManager": {
                return SSLTrustManager.class;
            }
            case "username": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        IrcEndpoint target = (IrcEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autorejoin": 
            case "autoRejoin": {
                return target.getConfiguration().isAutoRejoin();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "channels": {
                return target.getConfiguration().getChannels();
            }
            case "colors": {
                return target.getConfiguration().isColors();
            }
            case "commandtimeout": 
            case "commandTimeout": {
                return target.getConfiguration().getCommandTimeout();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "keys": {
                return target.getConfiguration().getKeys();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "namesonjoin": 
            case "namesOnJoin": {
                return target.getConfiguration().isNamesOnJoin();
            }
            case "nickpassword": 
            case "nickPassword": {
                return target.getConfiguration().getNickPassword();
            }
            case "nickname": {
                return target.getConfiguration().getNickname();
            }
            case "onjoin": 
            case "onJoin": {
                return target.getConfiguration().isOnJoin();
            }
            case "onkick": 
            case "onKick": {
                return target.getConfiguration().isOnKick();
            }
            case "onmode": 
            case "onMode": {
                return target.getConfiguration().isOnMode();
            }
            case "onnick": 
            case "onNick": {
                return target.getConfiguration().isOnNick();
            }
            case "onpart": 
            case "onPart": {
                return target.getConfiguration().isOnPart();
            }
            case "onprivmsg": 
            case "onPrivmsg": {
                return target.getConfiguration().isOnPrivmsg();
            }
            case "onquit": 
            case "onQuit": {
                return target.getConfiguration().isOnQuit();
            }
            case "onreply": 
            case "onReply": {
                return target.getConfiguration().isOnReply();
            }
            case "ontopic": 
            case "onTopic": {
                return target.getConfiguration().isOnTopic();
            }
            case "password": {
                return target.getConfiguration().getPassword();
            }
            case "persistent": {
                return target.getConfiguration().isPersistent();
            }
            case "realname": {
                return target.getConfiguration().getRealname();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return target.getConfiguration().getSslContextParameters();
            }
            case "trustmanager": 
            case "trustManager": {
                return target.getConfiguration().getTrustManager();
            }
            case "username": {
                return target.getConfiguration().getUsername();
            }
        }
        return null;
    }
}

