/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.TimeUnit;
import org.apache.camel.clock.Clock;

public final class ResetableClock
implements Clock {
    private long created;
    private long createdNano;

    public ResetableClock(Clock clock) {
        this.created = clock.getCreated();
        this.createdNano = System.nanoTime();
    }

    public ResetableClock() {
        this.created = System.currentTimeMillis();
        this.createdNano = System.nanoTime();
    }

    @Override
    public long elapsed() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.createdNano);
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    public void reset() {
        this.created = System.currentTimeMillis();
        this.createdNano = System.nanoTime();
    }

    void unset() {
        this.created = 0L;
        this.createdNano = 0L;
    }
}

