/*
 * Decompiled with CFR 0.152.
 */
package io.iron.ironmq;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import io.iron.ironmq.Cloud;
import io.iron.ironmq.HTTPException;
import io.iron.ironmq.IronReader;
import io.iron.ironmq.IronTokenContainer;
import io.iron.ironmq.Queue;
import io.iron.ironmq.TokenContainer;
import io.iron.ironmq.keystone.KeystoneIdentity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Client {
    private static final String defaultApiVersion = "3";
    private static final Gson gson = new Gson();
    private final String apiVersion;
    static final Random rand = new Random();
    private static final HashMap<String, Object> defaultOptions = new HashMap();
    private String projectId;
    private TokenContainer tokenContainer;
    private Cloud cloud;
    private String[] optionsList;
    private Map<String, Object> options;
    private String env;

    public Client() {
        this(null, (String)null, null, null);
    }

    public Client(String projectId, String token) {
        this(projectId, token, null, null);
    }

    public Client(String projectId, String token, Cloud cloud) {
        this(projectId, token, cloud, null);
    }

    public Client(String projectId, String token, Cloud cloud, Integer apiVersion) {
        HashMap<String, Object> userOptions = new HashMap<String, Object>();
        userOptions.put("project_id", projectId);
        userOptions.put("token", token);
        if (cloud != null) {
            userOptions.put("cloud", cloud);
        }
        this.apiVersion = apiVersion == null || apiVersion < 1 ? defaultApiVersion : apiVersion.toString();
        this.loadConfiguration("iron", "mq", userOptions, new String[]{"project_id", "token", "cloud"});
    }

    public Client(String projectId, KeystoneIdentity identity, Cloud cloud, Integer apiVersion) {
        HashMap<String, Object> userOptions = new HashMap<String, Object>();
        userOptions.put("project_id", projectId);
        userOptions.put("keystone", identity.toHash());
        if (cloud != null) {
            userOptions.put("cloud", cloud);
        }
        this.apiVersion = apiVersion == null || apiVersion < 1 ? defaultApiVersion : apiVersion.toString();
        this.loadConfiguration("iron", "mq", userOptions, new String[]{"project_id", "token", "cloud"});
    }

    public Client(String projectId, String token, Cloud cloud, Integer apiVersion, int lookUpLimit) {
        HashMap<String, Object> userOptions = new HashMap<String, Object>();
        userOptions.put("project_id", projectId);
        userOptions.put("token", token);
        if (cloud != null) {
            userOptions.put("cloud", cloud);
        }
        this.apiVersion = apiVersion == null || apiVersion < 1 ? defaultApiVersion : apiVersion.toString();
        this.loadConfiguration("iron", "mq", userOptions, new String[]{"project_id", "token", "cloud"}, lookUpLimit);
    }

    public Queue queue(String name) {
        return new Queue(this, name);
    }

    IronReader delete(String endpoint) throws IOException {
        return this.request("DELETE", endpoint, null);
    }

    IronReader delete(String endpoint, String body) throws IOException {
        return this.request("DELETE", endpoint, body);
    }

    IronReader get(String endpoint) throws IOException {
        return this.request("GET", endpoint, null);
    }

    IronReader post(String endpoint, String body) throws IOException {
        return this.request("POST", endpoint, body);
    }

    IronReader post(String endpoint, Object body) throws IOException {
        return this.request("POST", endpoint, body);
    }

    IronReader put(String endpoint, String body) throws IOException {
        return this.request("PUT", endpoint, body);
    }

    IronReader patch(String endpoint, String body) throws IOException {
        return this.request("PATCH", endpoint, body);
    }

    private IronReader request(String method, String endpoint, Object body) throws IOException {
        String path = "/" + this.apiVersion + "/projects/" + this.projectId + "/" + endpoint;
        URL url = new URL(this.cloud.scheme, this.cloud.host, this.cloud.port, this.cloud.pathPrefix + path);
        int maxRetries = 5;
        int retries = 0;
        while (true) {
            try {
                return this.singleRequest(method, url, body);
            }
            catch (HTTPException e) {
                if (e.getStatusCode() != 503 || retries >= 5) {
                    throw e;
                }
                int pow = (1 << 2 * ++retries) * 100;
                int delay = rand.nextInt(pow);
                try {
                    Thread.sleep(delay);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IronReader singleRequest(String method, URL url, Object body) throws IOException {
        int status;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (method.equals("DELETE") || method.equals("PATCH")) {
            conn.setRequestMethod("POST");
            conn.setRequestProperty("X-HTTP-Method-Override", method);
        } else {
            conn.setRequestMethod(method);
        }
        conn.setRequestProperty("Authorization", "OAuth " + this.tokenContainer.getToken());
        conn.setRequestProperty("User-Agent", "IronMQ Java Client");
        if (body != null) {
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
        }
        conn.setConnectTimeout(60000);
        conn.setReadTimeout(60000);
        conn.connect();
        if (body != null) {
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            if (body instanceof String) {
                out.write((String)body);
                out.close();
            } else {
                JsonWriter jwriter = new JsonWriter(out);
                gson.toJson(body, body.getClass(), jwriter);
                jwriter.close();
            }
        }
        if ((status = conn.getResponseCode()) < 200 || status >= 300) {
            String msg;
            if (conn.getContentLength() > 0 && conn.getContentType().equals("application/json")) {
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader(conn.getErrorStream());
                    Error error = gson.fromJson((Reader)reader, Error.class);
                    msg = error.msg;
                }
                catch (JsonSyntaxException e) {
                    msg = "IronMQ's response contained invalid JSON";
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            } else {
                msg = "Empty or non-JSON response";
            }
            throw new HTTPException(status, msg);
        }
        return new IronReader(new InputStreamReader(conn.getInputStream()), conn);
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public Object getOption(String name) {
        return this.options.get(name);
    }

    public String getEnv() {
        return this.env;
    }

    private void loadConfiguration(String company, String product, Map<String, Object> userOptions, String[] extraOptionsList) {
        this.loadConfiguration(company, product, userOptions, extraOptionsList, 0);
    }

    private void loadConfiguration(String company, String product, Map<String, Object> userOptions, String[] extraOptionsList, int lookUpLimit) {
        this.optionsList = ArrayUtils.addAll(new String[]{"scheme", "host", "port", "user_agent", "keystone"}, extraOptionsList);
        this.options = new HashMap<String, Object>();
        this.env = (String)userOptions.get("env");
        if (this.env == null) {
            this.env = System.getenv(company.toUpperCase() + "_" + product.toUpperCase() + "_ENV");
        }
        if (this.env == null) {
            this.env = System.getenv(company.toUpperCase() + "_ENV");
        }
        if (this.env == null) {
            this.env = (String)defaultOptions.get("env");
        }
        this.loadFromHash(userOptions);
        this.loadFromConfig(company, product, (String)userOptions.get("config"));
        this.loadFromConfig(company, product, System.getenv(company.toUpperCase() + "_" + product.toUpperCase() + "_CONFIG"));
        this.loadFromConfig(company, product, System.getenv(company.toUpperCase() + "_CONFIG"));
        this.loadFromEnv(company.toUpperCase() + "_" + product.toUpperCase());
        this.loadFromEnv(company.toUpperCase());
        ArrayList<String> suffixes = new ArrayList<String>();
        if (this.env != null) {
            suffixes.add("-" + this.env);
            suffixes.add("_" + this.env);
        }
        suffixes.add("");
        for (String suffix : suffixes) {
            for (String configBase : new String[]{company + "-" + product, company + "_" + product, company}) {
                if (lookUpLimit > 0) {
                    File parent = new File(System.getProperty("user.dir")).getParentFile();
                    for (int i = lookUpLimit; i > 0 && parent != null; parent = parent.getParentFile(), --i) {
                        String name = parent.getAbsolutePath();
                        this.loadFromConfig(company, product, name + "/" + configBase + suffix + ".json");
                        this.loadFromConfig(company, product, name + "/." + configBase + suffix + ".json");
                    }
                }
                this.loadFromConfig(company, product, System.getProperty("user.dir") + "/" + configBase + suffix + ".json");
                this.loadFromConfig(company, product, System.getProperty("user.dir") + "/." + configBase + suffix + ".json");
                this.loadFromConfig(company, product, System.getProperty("user.dir") + "/config/" + configBase + suffix + ".json");
                this.loadFromConfig(company, product, System.getProperty("user.dir") + "/config/." + configBase + suffix + ".json");
                this.loadFromConfig(company, product, System.getProperty("user.home") + "/" + configBase + suffix + ".json");
                this.loadFromConfig(company, product, System.getProperty("user.home") + "/." + configBase + suffix + ".json");
            }
        }
        this.loadFromConfig(company, product, (String)defaultOptions.get("config"));
        this.loadFromHash(defaultOptions);
        this.projectId = (String)this.getOption("project_id");
        String token = (String)this.getOption("token");
        HashMap keystoneHash = (HashMap)this.getOption("keystone");
        if (keystoneHash != null && keystoneHash.containsKey("server") && keystoneHash.containsKey("tenant") && keystoneHash.containsKey("username") && keystoneHash.containsKey("password")) {
            this.tokenContainer = KeystoneIdentity.fromHash(keystoneHash);
        } else if (StringUtils.isNotBlank(token)) {
            this.tokenContainer = new IronTokenContainer(token);
        } else {
            throw new IllegalArgumentException("You should specify Iron token or Keystone credentials");
        }
        if (userOptions.containsKey("cloud")) {
            Object cloudOption = userOptions.get("cloud");
            if (cloudOption != null && cloudOption instanceof Cloud) {
                this.cloud = (Cloud)cloudOption;
            }
        } else {
            this.cloud = new Cloud((String)this.getOption("scheme"), (String)this.getOption("host"), ((Number)this.getOption("port")).intValue());
        }
    }

    private void setOption(String name, Object value) {
        if (ArrayUtils.contains(this.optionsList, name) && this.options.get(name) == null && value != null) {
            this.options.put(name, value);
        }
    }

    private Map<String, Object> getSubHash(Map<String, Object> hash, String[] subs) {
        Map result = hash;
        for (String sub : subs) {
            if (result.get(sub) == null) {
                return null;
            }
            result = (Map)result.get(sub);
        }
        return result;
    }

    private void loadFromHash(Map<String, Object> hash) {
        if (hash == null) {
            return;
        }
        for (String option : this.optionsList) {
            this.setOption(option, hash.get(option));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromConfig(String company, String product, String configFile) {
        Map configHash;
        Reader configReader;
        if (configFile == null) {
            return;
        }
        File config = new File(configFile);
        if (!config.exists()) {
            return;
        }
        try {
            configReader = new FileReader(config);
        }
        catch (FileNotFoundException e) {
            return;
        }
        configReader = new BufferedReader(configReader);
        try {
            configHash = gson.fromJson(configReader, Map.class);
        }
        finally {
            try {
                configReader.close();
            }
            catch (IOException iOException) {}
        }
        if (this.env != null) {
            this.loadFromHash(this.getSubHash(configHash, new String[]{this.env, company + "_" + product}));
            this.loadFromHash(this.getSubHash(configHash, new String[]{this.env, company, product}));
            this.loadFromHash(this.getSubHash(configHash, new String[]{this.env, product}));
            this.loadFromHash(this.getSubHash(configHash, new String[]{this.env, company}));
            this.loadFromHash(this.getSubHash(configHash, new String[]{company + "_" + product, this.env}));
            this.loadFromHash(this.getSubHash(configHash, new String[]{company, product, this.env}));
            this.loadFromHash(this.getSubHash(configHash, new String[]{product, this.env}));
            this.loadFromHash(this.getSubHash(configHash, new String[]{company, this.env}));
            this.loadFromHash(this.getSubHash(configHash, new String[]{this.env}));
        }
        this.loadFromHash(this.getSubHash(configHash, new String[]{company + "_" + product}));
        this.loadFromHash(this.getSubHash(configHash, new String[]{company, product}));
        this.loadFromHash(this.getSubHash(configHash, new String[]{product}));
        this.loadFromHash(this.getSubHash(configHash, new String[]{company}));
        this.loadFromHash(this.getSubHash(configHash, new String[0]));
    }

    private void loadFromEnv(String prefix) {
        for (String option : this.optionsList) {
            this.setOption(option, System.getenv(prefix + "_" + option.toUpperCase()));
        }
    }

    static {
        defaultOptions.put("scheme", Cloud.ironAWSUSEast.getScheme());
        defaultOptions.put("host", Cloud.ironAWSUSEast.getHost());
        defaultOptions.put("port", Cloud.ironAWSUSEast.getPort());
    }

    private static class Error
    implements Serializable {
        String msg;

        private Error() {
        }
    }
}

