/*
 * Decompiled with CFR 0.152.
 */
package io.iron.ironmq;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.iron.ironmq.HTTPException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class HttpClient {
    private boolean forMq;

    private HttpClient() {
    }

    public HttpClient(boolean forMq) {
        this.forMq = forMq;
    }

    public static HttpClient create() {
        return new HttpClient(false);
    }

    public static HttpClient createForMq() {
        return new HttpClient(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader singleRequest(String method, URL url, String body, HashMap<String, String> headers) throws IOException {
        int status;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (method.equals("DELETE") || method.equals("PATCH")) {
            conn.setRequestMethod("POST");
            conn.setRequestProperty("X-HTTP-Method-Override", method);
        } else {
            conn.setRequestMethod(method);
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (body != null) {
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
        }
        conn.connect();
        if (body != null) {
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            out.write(body);
            out.close();
        }
        if ((status = conn.getResponseCode()) != 200) {
            if (this.forMq) {
                String msg;
                if (conn.getContentLength() > 0 && conn.getContentType().equals("application/json")) {
                    InputStreamReader reader = null;
                    try {
                        reader = new InputStreamReader(conn.getErrorStream());
                        Gson gson = new Gson();
                        Error error = gson.fromJson((Reader)reader, Error.class);
                        msg = error.msg;
                    }
                    catch (JsonSyntaxException e) {
                        msg = "IronMQ's response contained invalid JSON";
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                } else {
                    msg = "Empty or non-JSON response";
                }
                throw new HTTPException(status, msg);
            }
            throw new HTTPException(status, conn.getResponseMessage());
        }
        return new InputStreamReader(conn.getInputStream());
    }

    private static class Error
    implements Serializable {
        String msg;

        private Error() {
        }
    }
}

