/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ironmq;

import io.iron.ironmq.Queue;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.ironmq.GsonUtil;
import org.apache.camel.component.ironmq.IronMQConfiguration;
import org.apache.camel.component.ironmq.IronMQEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IronMQProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(IronMQProducer.class);
    private final Queue ironQueue;

    public IronMQProducer(IronMQEndpoint endpoint, Queue ironQueue) {
        super(endpoint);
        this.ironQueue = ironQueue;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        IronMQConfiguration configuration = this.getEndpoint().getConfiguration();
        if ("CamelIronMQClearQueue".equals(exchange.getIn().getHeader("CamelIronMQOperation", String.class))) {
            this.ironQueue.clear();
        } else {
            Object messageId = null;
            Object body = exchange.getIn().getBody();
            if (body instanceof String[]) {
                messageId = this.ironQueue.pushMessages((String[])body, configuration.getVisibilityDelay());
            } else if (body instanceof String) {
                if (configuration.isPreserveHeaders()) {
                    body = GsonUtil.getBodyFromMessage(exchange.getIn());
                }
                messageId = this.ironQueue.push((String)body, configuration.getVisibilityDelay());
            } else {
                throw new InvalidPayloadException(exchange, String.class);
            }
            LOG.trace("Send request [{}] from exchange [{}]...", body, (Object)exchange);
            LOG.trace("Received messageId [{}]", messageId);
            Message message = this.getMessageForResponse(exchange);
            message.setHeader("CamelIronMQMessageId", messageId);
        }
    }

    private Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }

    @Override
    public IronMQEndpoint getEndpoint() {
        return (IronMQEndpoint)super.getEndpoint();
    }
}

