/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jacksonxml.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.TypeConverterRegistry;

@Converter(generateLoader=true)
public final class JacksonXMLTypeConverters {
    private final XmlMapper defaultMapper = new XmlMapper();
    private boolean init;
    private Boolean enabled;

    @Converter(fallback=true)
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        ObjectMapper mapper;
        if (!this.init && exchange != null) {
            String text = exchange.getContext().getGlobalOptions().get("CamelJacksonXmlEnableTypeConverter");
            this.enabled = "true".equalsIgnoreCase(text);
            this.init = true;
        }
        if (this.enabled == null || !this.enabled.booleanValue()) {
            return null;
        }
        if (JacksonXMLTypeConverters.isNotPojoType(type)) {
            return null;
        }
        if (exchange != null && value instanceof Map && (mapper = this.resolveObjectMapper(exchange.getContext().getRegistry())).canSerialize(type)) {
            return mapper.convertValue(value, type);
        }
        return null;
    }

    private static boolean isNotPojoType(Class<?> type) {
        boolean isString = String.class.isAssignableFrom(type);
        boolean isNumber = Number.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type);
        return isString || isNumber;
    }

    private ObjectMapper resolveObjectMapper(Registry registry) {
        Set<XmlMapper> mappers = registry.findByType(XmlMapper.class);
        if (mappers.size() == 1) {
            return mappers.iterator().next();
        }
        return this.defaultMapper;
    }
}

