/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.AggregationStrategyAwareDefinition;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OptimisticLockRetryPolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.aggregate.AggregateController;
import org.apache.camel.processor.aggregate.AggregateProcessor;
import org.apache.camel.processor.aggregate.OptimisticLockRetryPolicy;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.InternalProcessor;
import org.apache.camel.support.PluginHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateReifier
extends ProcessorReifier<AggregateDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateReifier.class);

    public AggregateReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (AggregateDefinition)AggregateDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        return this.createAggregator();
    }

    protected AggregateProcessor createAggregator() throws Exception {
        Long completionTimeoutCheckerInterval;
        Boolean completeAllOnStop;
        Boolean forceCompletionOnStop;
        Boolean discardOnAggregationFailure;
        Boolean discardOnCompletionTimeout;
        Integer closeCorrelationKeyOnCompletion;
        Boolean ignoreInvalidCorrelationKeys;
        Boolean eagerCheckCompletion;
        Boolean completionOnNewCorrelationGroup;
        Boolean completionFromBatchConsumer;
        Integer completionSize;
        Long completionInterval;
        Long completionTimeout;
        AggregateController controller;
        Processor childProcessor = this.createChildProcessor(true);
        InternalProcessor target = PluginHelper.getInternalProcessorFactory(this.camelContext).addUnitOfWorkProcessorAdvice(this.camelContext, childProcessor, this.route);
        if (((AggregateDefinition)this.definition).getExpression() == null) {
            throw new IllegalArgumentException("CorrelationExpression must be set on " + String.valueOf(this.definition));
        }
        Expression correlation = this.createExpression(((AggregateDefinition)this.definition).getExpression());
        AggregationStrategy strategy = this.getConfiguredAggregationStrategy((AggregationStrategyAwareDefinition)((Object)this.definition));
        if (strategy == null) {
            throw new IllegalArgumentException("AggregationStrategy must be set on " + String.valueOf(this.definition));
        }
        boolean parallel = this.parseBoolean(((AggregateDefinition)this.definition).getParallelProcessing(), false);
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)((Object)this.definition), parallel);
        ExecutorService threadPool = this.getConfiguredExecutorService("Aggregator", (ExecutorServiceAwareDefinition)((Object)this.definition), parallel);
        if (threadPool == null && !parallel) {
            ExecutorServiceManager manager = this.camelContext.getExecutorServiceManager();
            threadPool = manager.newSingleThreadExecutor(this.definition, "Aggregator");
            shutdownThreadPool = true;
        }
        AggregateProcessor answer = new AggregateProcessor(this.camelContext, target, correlation, strategy, threadPool, shutdownThreadPool);
        AggregationRepository repository = this.createAggregationRepository();
        if (repository != null) {
            answer.setAggregationRepository(repository);
        }
        if ((controller = this.createAggregateController()) != null) {
            answer.setAggregateController(controller);
        }
        boolean shutdownTimeoutThreadPool = false;
        ScheduledExecutorService timeoutThreadPool = ((AggregateDefinition)this.definition).getTimeoutCheckerExecutorServiceBean();
        if (timeoutThreadPool == null && ((AggregateDefinition)this.definition).getTimeoutCheckerExecutorService() != null && (timeoutThreadPool = this.lookupByNameAndType(((AggregateDefinition)this.definition).getTimeoutCheckerExecutorService(), ScheduledExecutorService.class)) == null) {
            timeoutThreadPool = this.camelContext.getExecutorServiceManager().newScheduledThreadPool((Object)this, "AggregateTimeoutChecker", ((AggregateDefinition)this.definition).getTimeoutCheckerExecutorService());
            if (timeoutThreadPool == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + ((AggregateDefinition)this.definition).getTimeoutCheckerExecutorService() + " not found in registry (as an ScheduledExecutorService instance) or as a thread pool profile.");
            }
            shutdownTimeoutThreadPool = true;
        }
        answer.setTimeoutCheckerExecutorService(timeoutThreadPool);
        answer.setShutdownTimeoutCheckerExecutorService(shutdownTimeoutThreadPool);
        if (this.parseBoolean(((AggregateDefinition)this.definition).getCompletionFromBatchConsumer(), false) && this.parseBoolean(((AggregateDefinition)this.definition).getDiscardOnAggregationFailure(), false)) {
            throw new IllegalArgumentException("Cannot use both completionFromBatchConsumer and discardOnAggregationFailure on: " + String.valueOf(this.definition));
        }
        answer.setParallelProcessing(parallel);
        Boolean optimisticLocking = this.parseBoolean(((AggregateDefinition)this.definition).getOptimisticLocking());
        if (optimisticLocking != null) {
            answer.setOptimisticLocking(optimisticLocking);
        }
        if (((AggregateDefinition)this.definition).getCompletionPredicate() != null) {
            Predicate predicate = this.createPredicate(((AggregateDefinition)this.definition).getCompletionPredicate());
            answer.setCompletionPredicate(predicate);
        } else if (strategy instanceof Predicate) {
            Predicate predicate = (Predicate)((Object)strategy);
            LOG.debug("Using AggregationStrategy as completion predicate: {}", (Object)strategy);
            answer.setCompletionPredicate(predicate);
        }
        if (((AggregateDefinition)this.definition).getCompletionTimeoutExpression() != null) {
            Expression expression = this.createExpression(((AggregateDefinition)this.definition).getCompletionTimeoutExpression());
            answer.setCompletionTimeoutExpression(expression);
        }
        if ((completionTimeout = this.parseDuration(((AggregateDefinition)this.definition).getCompletionTimeout())) != null) {
            answer.setCompletionTimeout(completionTimeout);
        }
        if ((completionInterval = this.parseDuration(((AggregateDefinition)this.definition).getCompletionInterval())) != null) {
            answer.setCompletionInterval(completionInterval);
        }
        if (((AggregateDefinition)this.definition).getCompletionSizeExpression() != null) {
            Expression expression = this.createExpression(((AggregateDefinition)this.definition).getCompletionSizeExpression());
            answer.setCompletionSizeExpression(expression);
        }
        if ((completionSize = this.parseInt(((AggregateDefinition)this.definition).getCompletionSize())) != null) {
            answer.setCompletionSize(completionSize);
        }
        if ((completionFromBatchConsumer = this.parseBoolean(((AggregateDefinition)this.definition).getCompletionFromBatchConsumer())) != null) {
            answer.setCompletionFromBatchConsumer(completionFromBatchConsumer);
        }
        if ((completionOnNewCorrelationGroup = this.parseBoolean(((AggregateDefinition)this.definition).getCompletionOnNewCorrelationGroup())) != null) {
            answer.setCompletionOnNewCorrelationGroup(completionOnNewCorrelationGroup);
        }
        if ((eagerCheckCompletion = this.parseBoolean(((AggregateDefinition)this.definition).getEagerCheckCompletion())) != null) {
            answer.setEagerCheckCompletion(eagerCheckCompletion);
        }
        if ((ignoreInvalidCorrelationKeys = this.parseBoolean(((AggregateDefinition)this.definition).getIgnoreInvalidCorrelationKeys())) != null) {
            answer.setIgnoreInvalidCorrelationKeys(ignoreInvalidCorrelationKeys);
        }
        if ((closeCorrelationKeyOnCompletion = this.parseInt(((AggregateDefinition)this.definition).getCloseCorrelationKeyOnCompletion())) != null) {
            answer.setCloseCorrelationKeyOnCompletion(closeCorrelationKeyOnCompletion);
        }
        if ((discardOnCompletionTimeout = this.parseBoolean(((AggregateDefinition)this.definition).getDiscardOnCompletionTimeout())) != null) {
            answer.setDiscardOnCompletionTimeout(discardOnCompletionTimeout);
        }
        if ((discardOnAggregationFailure = this.parseBoolean(((AggregateDefinition)this.definition).getDiscardOnAggregationFailure())) != null) {
            answer.setDiscardOnAggregationFailure(discardOnAggregationFailure);
        }
        if ((forceCompletionOnStop = this.parseBoolean(((AggregateDefinition)this.definition).getForceCompletionOnStop())) != null) {
            answer.setForceCompletionOnStop(forceCompletionOnStop);
        }
        if ((completeAllOnStop = this.parseBoolean(((AggregateDefinition)this.definition).getCompleteAllOnStop())) != null) {
            answer.setCompleteAllOnStop(completeAllOnStop);
        }
        if (((AggregateDefinition)this.definition).getOptimisticLockRetryPolicy() == null) {
            if (((AggregateDefinition)this.definition).getOptimisticLockRetryPolicyDefinition() != null) {
                answer.setOptimisticLockRetryPolicy(this.createOptimisticLockRetryPolicy(((AggregateDefinition)this.definition).getOptimisticLockRetryPolicyDefinition()));
            }
        } else {
            answer.setOptimisticLockRetryPolicy(((AggregateDefinition)this.definition).getOptimisticLockRetryPolicy());
        }
        if ((completionTimeoutCheckerInterval = this.parseDuration(((AggregateDefinition)this.definition).getCompletionTimeoutCheckerInterval())) != null) {
            answer.setCompletionTimeoutCheckerInterval(completionTimeoutCheckerInterval);
        }
        return answer;
    }

    public OptimisticLockRetryPolicy createOptimisticLockRetryPolicy(OptimisticLockRetryPolicyDefinition definition) {
        Long dur;
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        Integer num = this.parseInt(definition.getMaximumRetries());
        if (num != null) {
            policy.setMaximumRetries(num);
        }
        if ((dur = this.parseDuration(definition.getRetryDelay())) != null) {
            policy.setRetryDelay(dur);
        }
        if ((dur = this.parseDuration(definition.getMaximumRetryDelay())) != null) {
            policy.setMaximumRetryDelay(dur);
        }
        if (definition.getExponentialBackOff() != null) {
            policy.setExponentialBackOff(this.parseBoolean(definition.getExponentialBackOff(), true));
        }
        if (definition.getRandomBackOff() != null) {
            policy.setRandomBackOff(this.parseBoolean(definition.getRandomBackOff(), false));
        }
        return policy;
    }

    private AggregationRepository createAggregationRepository() {
        AggregationRepository repository = ((AggregateDefinition)this.definition).getAggregationRepositoryBean();
        if (repository == null && ((AggregateDefinition)this.definition).getAggregationRepository() != null) {
            repository = this.mandatoryLookup(((AggregateDefinition)this.definition).getAggregationRepository(), AggregationRepository.class);
        }
        return repository;
    }

    private AggregateController createAggregateController() {
        AggregateController controller = ((AggregateDefinition)this.definition).getAggregateControllerBean();
        if (controller == null && ((AggregateDefinition)this.definition).getAggregateController() != null) {
            controller = this.mandatoryLookup(((AggregateDefinition)this.definition).getAggregateController(), AggregateController.class);
        }
        return controller;
    }
}

