/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import java.util.Map;
import javax.cache.configuration.Configuration;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jcache.JCacheComponent;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class JCacheComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        JCacheComponent target = (JCacheComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(JCacheComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(JCacheComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "cacheconfiguration": 
            case "cacheConfiguration": {
                target.setCacheConfiguration(JCacheComponentConfigurer.property(camelContext, Configuration.class, value));
                return true;
            }
            case "cacheconfigurationproperties": 
            case "cacheConfigurationProperties": {
                target.setCacheConfigurationProperties(JCacheComponentConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "cacheconfigurationpropertiesref": 
            case "cacheConfigurationPropertiesRef": {
                target.setCacheConfigurationPropertiesRef(JCacheComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "cachingprovider": 
            case "cachingProvider": {
                target.setCachingProvider(JCacheComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "configurationuri": 
            case "configurationUri": {
                target.setConfigurationUri(JCacheComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(JCacheComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "cacheconfiguration": 
            case "cacheConfiguration": {
                return Configuration.class;
            }
            case "cacheconfigurationproperties": 
            case "cacheConfigurationProperties": {
                return Map.class;
            }
            case "cacheconfigurationpropertiesref": 
            case "cacheConfigurationPropertiesRef": {
                return String.class;
            }
            case "cachingprovider": 
            case "cachingProvider": {
                return String.class;
            }
            case "configurationuri": 
            case "configurationUri": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        JCacheComponent target = (JCacheComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "cacheconfiguration": 
            case "cacheConfiguration": {
                return target.getCacheConfiguration();
            }
            case "cacheconfigurationproperties": 
            case "cacheConfigurationProperties": {
                return target.getCacheConfigurationProperties();
            }
            case "cacheconfigurationpropertiesref": 
            case "cacheConfigurationPropertiesRef": {
                return target.getCacheConfigurationPropertiesRef();
            }
            case "cachingprovider": 
            case "cachingProvider": {
                return target.getCachingProvider();
            }
            case "configurationuri": 
            case "configurationUri": {
                return target.getConfigurationUri();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
        }
        return null;
    }
}

