/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.jcache.JCacheEndpoint;
import org.apache.camel.component.jcache.JCacheEntryEventListener;
import org.apache.camel.support.DefaultConsumer;

public class JCacheConsumer
extends DefaultConsumer {
    private CacheEntryListenerConfiguration<Object, Object> entryListenerConfiguration = null;

    public JCacheConsumer(JCacheEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    @Override
    protected void doStart() throws Exception {
        if (this.entryListenerConfiguration != null) {
            this.getCache().deregisterCacheEntryListener(this.entryListenerConfiguration);
        }
        this.entryListenerConfiguration = this.createEntryListenerConfiguration();
        this.getCache().registerCacheEntryListener(this.entryListenerConfiguration);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.entryListenerConfiguration != null) {
            this.getCache().deregisterCacheEntryListener(this.entryListenerConfiguration);
            this.entryListenerConfiguration = null;
        }
        super.doStop();
    }

    private JCacheEndpoint getJCacheEndpoint() {
        return (JCacheEndpoint)this.getEndpoint();
    }

    private Cache getCache() throws Exception {
        return this.getJCacheEndpoint().getManager().getCache();
    }

    private CacheEntryListenerConfiguration<Object, Object> createEntryListenerConfiguration() {
        Factory<CacheEntryListener> listenerFactory = () -> new JCacheEntryEventListener(){

            @Override
            protected void onEvents(Iterable<CacheEntryEvent<?, ?>> events) {
                for (CacheEntryEvent<?, ?> event : events) {
                    Exchange exchange = JCacheConsumer.this.createExchange(true);
                    Message message = exchange.getIn();
                    message.setHeader("CamelJCacheEventType", event.getEventType().name());
                    message.setHeader("CamelJCacheKey", event.getKey());
                    message.setBody(event.getValue());
                    if (event.isOldValueAvailable()) {
                        message.setHeader("CamelJCacheOldValue", event.getOldValue());
                    }
                    try {
                        JCacheConsumer.this.getProcessor().process(exchange);
                    }
                    catch (Exception e) {
                        JCacheConsumer.this.getExceptionHandler().handleException(e);
                    }
                }
            }
        };
        Factory<CacheEntryEventFilter> filterFactory = () -> this.getJCacheEndpoint().getManager().getEventFilter();
        return new MutableCacheEntryListenerConfiguration<Object, Object>(listenerFactory, filterFactory, this.getJCacheEndpoint().getManager().getConfiguration().isOldValueRequired(), this.getJCacheEndpoint().getManager().getConfiguration().isSynchronous());
    }
}

