/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.EventType;

final class JCacheEntryEventFilters {
    private JCacheEntryEventFilters() {
    }

    public static class Chained
    implements CacheEntryEventFilter<Object, Object> {
        private final List<CacheEntryEventFilter> filteredEvents;
        private final int filteredEventsSize;

        Chained(List<CacheEntryEventFilter> filteredEvents) {
            if (filteredEvents != null && !filteredEvents.isEmpty()) {
                this.filteredEvents = new ArrayList<CacheEntryEventFilter>(filteredEvents);
                this.filteredEventsSize = this.filteredEvents.size();
            } else {
                this.filteredEvents = null;
                this.filteredEventsSize = 0;
            }
        }

        @Override
        public boolean evaluate(CacheEntryEvent<?, ?> event) throws CacheEntryListenerException {
            if (this.filteredEvents == null) {
                return true;
            }
            for (int i = 0; i < this.filteredEventsSize; ++i) {
                if (this.filteredEvents.get(i).evaluate(event)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Named
    implements CacheEntryEventFilter<Object, Object> {
        private List<EventType> filteredEvents;

        Named(Collection<EventType> filteredEventNames) {
            if (filteredEventNames != null && !filteredEventNames.isEmpty()) {
                this.filteredEvents = new ArrayList<EventType>(filteredEventNames);
            }
        }

        @Override
        public boolean evaluate(CacheEntryEvent<?, ?> event) throws CacheEntryListenerException {
            if (this.filteredEvents == null) {
                return true;
            }
            return !this.filteredEvents.contains((Object)event.getEventType());
        }
    }
}

