/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache.processor.aggregate;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.cache.Cache;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.component.jcache.JCacheConfiguration;
import org.apache.camel.component.jcache.JCacheHelper;
import org.apache.camel.component.jcache.JCacheManager;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.OptimisticLockingAggregationRepository;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultExchangeHolder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="bean", description="Aggregation repository that uses JCache to store exchanges.", annotations={"interfaceName=org.apache.camel.spi.AggregationRepository"})
@Configurer(metadataOnly=true)
public class JCacheAggregationRepository
extends ServiceSupport
implements CamelContextAware,
OptimisticLockingAggregationRepository {
    private static final Logger LOG = LoggerFactory.getLogger(JCacheAggregationRepository.class);
    private CamelContext camelContext;
    private Cache<String, DefaultExchangeHolder> cache;
    private JCacheManager<String, DefaultExchangeHolder> cacheManager;
    @Metadata(description="Configuration for JCache")
    private JCacheConfiguration configuration = new JCacheConfiguration();
    @Metadata(description="Whether optimistic locking is in use")
    private boolean optimistic;
    @Metadata(label="advanced", description="Whether headers on the Exchange that are Java objects and Serializable should be included and saved to the repository")
    private boolean allowSerializedHeaders;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public JCacheConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JCacheConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getCacheName() {
        return this.configuration.getCacheName();
    }

    public void setCacheName(String cacheName) {
        this.configuration.setCacheName(cacheName);
    }

    public Cache<String, DefaultExchangeHolder> getCache() {
        return this.cache;
    }

    public void setCache(Cache<String, DefaultExchangeHolder> cache) {
        this.cache = cache;
    }

    public boolean isOptimistic() {
        return this.optimistic;
    }

    public void setOptimistic(boolean optimistic) {
        this.optimistic = optimistic;
    }

    public boolean isAllowSerializedHeaders() {
        return this.allowSerializedHeaders;
    }

    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.allowSerializedHeaders = allowSerializedHeaders;
    }

    @Override
    public Exchange add(CamelContext camelContext, String key, Exchange oldExchange, Exchange newExchange) throws OptimisticLockingAggregationRepository.OptimisticLockingException {
        if (!this.optimistic) {
            throw new UnsupportedOperationException();
        }
        LOG.trace("Adding an Exchange with ID {} for key {} in an optimistic manner.", (Object)newExchange.getExchangeId(), (Object)key);
        if (oldExchange == null) {
            DefaultExchangeHolder newHolder = DefaultExchangeHolder.marshal(newExchange, true, this.allowSerializedHeaders);
            DefaultExchangeHolder oldHolder = this.cache.getAndPut(key, newHolder);
            if (oldHolder != null) {
                Exchange exchange = this.unmarshallExchange(camelContext, oldHolder);
                LOG.error("Optimistic locking failed for exchange with key {}: IMap#putIfAbsend returned Exchange with ID {}, while it's expected no exchanges to be returned", (Object)key, (Object)(exchange != null ? exchange.getExchangeId() : "<null>"));
                throw new OptimisticLockingAggregationRepository.OptimisticLockingException();
            }
        } else {
            DefaultExchangeHolder newHolder;
            DefaultExchangeHolder oldHolder = DefaultExchangeHolder.marshal(oldExchange, true, this.allowSerializedHeaders);
            if (!this.cache.replace(key, oldHolder, newHolder = DefaultExchangeHolder.marshal(newExchange, true, this.allowSerializedHeaders))) {
                LOG.error("Optimistic locking failed for exchange with key {}: IMap#replace returned no Exchanges, while it's expected to replace one", (Object)key);
                throw new OptimisticLockingAggregationRepository.OptimisticLockingException();
            }
        }
        LOG.trace("Added an Exchange with ID {} for key {} in optimistic manner.", (Object)newExchange.getExchangeId(), (Object)key);
        return oldExchange;
    }

    @Override
    public Exchange add(CamelContext camelContext, String key, Exchange exchange) {
        if (this.optimistic) {
            throw new UnsupportedOperationException();
        }
        LOG.trace("Adding an Exchange with ID {} for key {} in a thread-safe manner.", (Object)exchange.getExchangeId(), (Object)key);
        DefaultExchangeHolder newHolder = DefaultExchangeHolder.marshal(exchange, true, this.allowSerializedHeaders);
        DefaultExchangeHolder oldHolder = this.cache.getAndPut(key, newHolder);
        return this.unmarshallExchange(camelContext, oldHolder);
    }

    @Override
    public Exchange get(CamelContext camelContext, String key) {
        return this.unmarshallExchange(camelContext, this.cache.get(key));
    }

    @Override
    public void remove(CamelContext camelContext, String key, Exchange exchange) {
        DefaultExchangeHolder holder = DefaultExchangeHolder.marshal(exchange, true, this.allowSerializedHeaders);
        if (this.optimistic) {
            LOG.trace("Removing an exchange with ID {} for key {} in an optimistic manner.", (Object)exchange.getExchangeId(), (Object)key);
            if (!this.cache.remove(key, holder)) {
                LOG.error("Optimistic locking failed for exchange with key {}: IMap#remove removed no Exchanges, while it's expected to remove one.", (Object)key);
                throw new OptimisticLockingAggregationRepository.OptimisticLockingException();
            }
            LOG.trace("Removed an exchange with ID {} for key {} in an optimistic manner.", (Object)exchange.getExchangeId(), (Object)key);
        } else {
            this.cache.remove(key);
        }
    }

    @Override
    public void confirm(CamelContext camelContext, String exchangeId) {
        LOG.trace("Confirming an exchange with ID {}.", (Object)exchangeId);
    }

    @Override
    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        Iterator<Cache.Entry<String, DefaultExchangeHolder>> entries = this.cache.iterator();
        while (entries.hasNext()) {
            keys.add(entries.next().getKey());
        }
        return Collections.unmodifiableSet(keys);
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.camelContext, "camelContext");
        ObjectHelper.notNull(this.configuration, "configuration");
        if (this.cache != null) {
            this.cacheManager = new JCacheManager<String, DefaultExchangeHolder>(this.cache);
        } else {
            this.cacheManager = JCacheHelper.createManager(this.getCamelContext(), this.configuration);
            this.cache = this.cacheManager.getCache();
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.cacheManager.close();
    }

    protected Exchange unmarshallExchange(CamelContext camelContext, DefaultExchangeHolder holder) {
        DefaultExchange exchange = null;
        if (holder != null) {
            exchange = new DefaultExchange(camelContext);
            DefaultExchangeHolder.unmarshal(exchange, holder);
        }
        return exchange;
    }
}

