/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Value;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.jcr.JcrConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class JcrConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        JcrConverterLoader.addTypeConverter(registry, InputStream.class, Value.class, false, (type, exchange, value) -> JcrConverter.toValue((Value)value));
        JcrConverterLoader.addTypeConverter(registry, Boolean.class, Value.class, false, (type, exchange, value) -> JcrConverter.toBoolean((Value)value));
        JcrConverterLoader.addTypeConverter(registry, String.class, Value.class, false, (type, exchange, value) -> JcrConverter.toString((Value)value));
        JcrConverterLoader.addTypeConverter(registry, Calendar.class, Value.class, false, (type, exchange, value) -> JcrConverter.toCalendar((Value)value));
        JcrConverterLoader.addTypeConverter(registry, Value.class, InputStream.class, false, (type, exchange, value) -> JcrConverter.toValue((InputStream)value));
        JcrConverterLoader.addTypeConverter(registry, Value.class, Boolean.class, false, (type, exchange, value) -> JcrConverter.toValue((Boolean)value));
        JcrConverterLoader.addTypeConverter(registry, Value.class, String.class, false, (type, exchange, value) -> JcrConverter.toValue((String)value));
        JcrConverterLoader.addTypeConverter(registry, Value.class, Calendar.class, false, (type, exchange, value) -> JcrConverter.toValue((Calendar)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }
}

