/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.time.Duration;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.jcr.JcrEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class JcrEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        JcrEndpoint target = (JcrEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(JcrEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "deep": {
                target.setDeep(JcrEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "eventtypes": 
            case "eventTypes": {
                target.setEventTypes(JcrEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(JcrEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(JcrEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(JcrEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "nolocal": 
            case "noLocal": {
                target.setNoLocal(JcrEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "nodetypenames": 
            case "nodeTypeNames": {
                target.setNodeTypeNames(JcrEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "password": {
                target.setPassword(JcrEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sessionlivecheckinterval": 
            case "sessionLiveCheckInterval": {
                target.setSessionLiveCheckInterval(JcrEndpointConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
            case "sessionlivecheckintervalonstart": 
            case "sessionLiveCheckIntervalOnStart": {
                target.setSessionLiveCheckIntervalOnStart(JcrEndpointConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
            case "username": {
                target.setUsername(JcrEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "uuids": {
                target.setUuids(JcrEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "workspacename": 
            case "workspaceName": {
                target.setWorkspaceName(JcrEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "deep": {
                return Boolean.TYPE;
            }
            case "eventtypes": 
            case "eventTypes": {
                return Integer.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "nolocal": 
            case "noLocal": {
                return Boolean.TYPE;
            }
            case "nodetypenames": 
            case "nodeTypeNames": {
                return String.class;
            }
            case "password": {
                return String.class;
            }
            case "sessionlivecheckinterval": 
            case "sessionLiveCheckInterval": {
                return Long.TYPE;
            }
            case "sessionlivecheckintervalonstart": 
            case "sessionLiveCheckIntervalOnStart": {
                return Long.TYPE;
            }
            case "username": {
                return String.class;
            }
            case "uuids": {
                return String.class;
            }
            case "workspacename": 
            case "workspaceName": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        JcrEndpoint target = (JcrEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "deep": {
                return target.isDeep();
            }
            case "eventtypes": 
            case "eventTypes": {
                return target.getEventTypes();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "nolocal": 
            case "noLocal": {
                return target.isNoLocal();
            }
            case "nodetypenames": 
            case "nodeTypeNames": {
                return target.getNodeTypeNames();
            }
            case "password": {
                return target.getPassword();
            }
            case "sessionlivecheckinterval": 
            case "sessionLiveCheckInterval": {
                return target.getSessionLiveCheckInterval();
            }
            case "sessionlivecheckintervalonstart": 
            case "sessionLiveCheckIntervalOnStart": {
                return target.getSessionLiveCheckIntervalOnStart();
            }
            case "username": {
                return target.getUsername();
            }
            case "uuids": {
                return target.getUuids();
            }
            case "workspacename": 
            case "workspaceName": {
                return target.getWorkspaceName();
            }
        }
        return null;
    }
}

