/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PooledExchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RouteAware;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckAware;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.HostedService;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.UnitOfWorkHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConsumer
extends ServiceSupport
implements Consumer,
RouteAware,
RouteIdAware,
HealthCheckAware,
HostedService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConsumer.class);
    private transient String consumerToString;
    private final Endpoint endpoint;
    private final Processor processor;
    private final AsyncProcessor asyncProcessor;
    private final ExchangeFactory exchangeFactory;
    private HealthCheck healthCheck;
    private ExceptionHandler exceptionHandler;
    private Route route;
    private String routeId;

    public DefaultConsumer(Endpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = processor;
        this.asyncProcessor = AsyncProcessorConverterHelper.convert(processor);
        this.exceptionHandler = new LoggingExceptionHandler(endpoint.getCamelContext(), this.getClass());
        this.exchangeFactory = endpoint.getCamelContext().getCamelContextExtension().getExchangeFactory().newExchangeFactory(this);
    }

    @Override
    public boolean isHostedService() {
        return false;
    }

    public String toString() {
        if (this.consumerToString == null) {
            this.consumerToString = "Consumer[" + URISupport.sanitizeUri(this.endpoint.getEndpointUri()) + "]";
        }
        return this.consumerToString;
    }

    @Override
    public Route getRoute() {
        return this.route;
    }

    @Override
    public void setRoute(Route route) {
        this.route = route;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public UnitOfWork createUoW(Exchange exchange) throws Exception {
        UnitOfWork uow;
        if (this.route != null && exchange.getFromRouteId() == null) {
            exchange.getExchangeExtension().setFromRouteId(this.route.getId());
        }
        if ((uow = exchange.getUnitOfWork()) == null) {
            uow = PluginHelper.getUnitOfWorkFactory(this.endpoint.getCamelContext()).createUnitOfWork(exchange);
            exchange.getExchangeExtension().setUnitOfWork(uow);
        }
        return uow;
    }

    public void doneUoW(Exchange exchange) {
        UnitOfWorkHelper.doneUow(exchange.getUnitOfWork(), exchange);
    }

    @Override
    public Exchange createExchange(boolean autoRelease) {
        Exchange answer = this.exchangeFactory.create(this.getEndpoint(), autoRelease);
        this.endpoint.configureExchange(answer);
        answer.getExchangeExtension().setFromRouteId(this.routeId);
        return answer;
    }

    @Override
    public void releaseExchange(Exchange exchange, boolean autoRelease) {
        if (exchange != null) {
            if (!autoRelease && exchange instanceof PooledExchange) {
                ((PooledExchange)exchange).done();
            }
            this.exchangeFactory.release(exchange);
        }
    }

    @Override
    public AsyncCallback defaultConsumerCallback(Exchange exchange, boolean autoRelease) {
        boolean pooled = this.exchangeFactory.isPooled();
        if (pooled) {
            AsyncCallback answer = exchange.getExchangeExtension().getDefaultConsumerCallback();
            if (answer == null) {
                answer = new DefaultConsumerCallback(this, exchange, autoRelease);
                exchange.getExchangeExtension().setDefaultConsumerCallback(answer);
            }
            return answer;
        }
        return new DefaultConsumerCallback(this, exchange, autoRelease);
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    public AsyncProcessor getAsyncProcessor() {
        return this.asyncProcessor;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void setHealthCheck(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    @Override
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @Override
    protected void doBuild() throws Exception {
        LOG.debug("Build consumer: {}", (Object)this);
        ServiceHelper.buildService(this.exchangeFactory, this.processor);
        DefaultConsumerCallback dummy = new DefaultConsumerCallback(this, null, false);
        LOG.trace("Warming up DefaultConsumer loaded class: {}", (Object)dummy.getClass().getName());
    }

    @Override
    protected void doInit() throws Exception {
        LOG.debug("Init consumer: {}", (Object)this);
        ServiceHelper.initService(this.exchangeFactory, this.processor);
    }

    @Override
    protected void doStart() throws Exception {
        LOG.debug("Starting consumer: {}", (Object)this);
        this.exchangeFactory.setRouteId(this.routeId);
        ServiceHelper.startService(this.exchangeFactory, this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        LOG.debug("Stopping consumer: {}", (Object)this);
        ServiceHelper.stopService(this.exchangeFactory, this.processor);
    }

    @Override
    protected void doShutdown() throws Exception {
        LOG.debug("Shutting down consumer: {}", (Object)this);
        ServiceHelper.stopAndShutdownServices(this.exchangeFactory, this.processor);
    }

    protected void handleException(Throwable t) {
        Throwable newt = t == null ? new IllegalArgumentException("Handling [null] exception") : t;
        this.getExceptionHandler().handleException(newt);
    }

    protected void handleException(String message, Throwable t) {
        Throwable newt = t == null ? new IllegalArgumentException("Handling [null] exception") : t;
        this.getExceptionHandler().handleException(message, newt);
    }

    protected void handleException(String message, Exchange exchange, Throwable t) {
        Throwable newt = t == null ? new IllegalArgumentException("Handling [null] exception") : t;
        this.getExceptionHandler().handleException(message, exchange, newt);
    }

    private static final class DefaultConsumerCallback
    implements AsyncCallback {
        private final DefaultConsumer consumer;
        private final Exchange exchange;
        private final boolean autoRelease;

        public DefaultConsumerCallback(DefaultConsumer consumer, Exchange exchange, boolean autoRelease) {
            this.consumer = consumer;
            this.exchange = exchange;
            this.autoRelease = autoRelease;
        }

        @Override
        public void done(boolean doneSync) {
            try {
                if (this.exchange.getException() != null) {
                    this.consumer.getExceptionHandler().handleException("Error processing exchange", this.exchange, this.exchange.getException());
                }
            }
            finally {
                if (!this.autoRelease) {
                    this.consumer.releaseExchange(this.exchange, this.autoRelease);
                }
            }
        }

        public String toString() {
            return "DefaultConsumerCallback";
        }
    }
}

