/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Map;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HasId;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerAware;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.BridgeExceptionHandlerToErrorHandler;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.EventDrivenPollingConsumer;
import org.apache.camel.support.LazyStartProducer;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultEndpoint
extends ServiceSupport
implements Endpoint,
HasId,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEndpoint.class);
    private final String id = EndpointHelper.createEndpointId();
    private transient String endpointUriToString;
    private volatile String endpointUri;
    private CamelContext camelContext;
    private Component component;
    @Metadata(label="advanced", defaultValue="true", description="Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc. Important: If a component has the same option defined on both component and endpoint level, then disabling autowiring on endpoint level would not affect that the component will still be autowired, and therefore the endpoint will be configured with option from the component level. In other words turning off autowiring would then require to turn it off on the component level.")
    private boolean autowiredEnabled = true;
    @UriParam(label="producer,advanced", description="Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.")
    private boolean lazyStartProducer;
    @UriParam(label="consumer,advanced", description="Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions (if possible) occurred while the Camel consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. Important: This is only possible if the 3rd party component allows Camel to be alerted if an exception was thrown. Some components handle this internally only, and therefore bridgeErrorHandler is not possible. In other situations we may improve the Camel component to hook into the 3rd party component and make this possible for future releases. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.")
    private boolean bridgeErrorHandler;
    @UriParam(label="consumer,advanced", optionalPrefix="consumer.", description="To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.")
    private ExceptionHandler exceptionHandler;
    @UriParam(label="consumer,advanced", description="Sets the exchange pattern when the consumer creates an exchange.")
    private ExchangePattern exchangePattern = ExchangePattern.InOnly;
    private int pollingConsumerQueueSize = 1000;
    private boolean pollingConsumerBlockWhenFull = true;
    private long pollingConsumerBlockTimeout;
    private boolean pollingConsumerCopy;

    protected DefaultEndpoint(String endpointUri, Component component) {
        this.component = component;
        this.setEndpointUri(endpointUri);
        if (component != null) {
            this.camelContext = component.getCamelContext();
        }
    }

    protected DefaultEndpoint() {
    }

    public int hashCode() {
        return this.getEndpointUri().hashCode() * 37 + 1;
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultEndpoint) {
            DefaultEndpoint that = (DefaultEndpoint)object;
            String thisContextName = this.getCamelContext() != null ? this.getCamelContext().getName() : null;
            String thatContextName = that.getCamelContext() != null ? that.getCamelContext().getName() : null;
            return ObjectHelper.equal(this.getEndpointUri(), that.getEndpointUri()) && ObjectHelper.equal(thisContextName, thatContextName);
        }
        return false;
    }

    public String toString() {
        if (this.endpointUriToString == null) {
            String value = null;
            try {
                value = this.getEndpointUri();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.endpointUriToString = URISupport.sanitizeUri(value);
        }
        return this.endpointUriToString;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getEndpointUri() {
        if (this.endpointUri == null) {
            this.endpointUri = this.createEndpointUri();
            if (this.endpointUri == null) {
                throw new IllegalArgumentException("endpointUri is not specified and " + this.getClass().getName() + " does not implement createEndpointUri() to create a default value");
            }
        }
        return this.endpointUri;
    }

    @Override
    public String getEndpointKey() {
        if (this.isLenientProperties()) {
            String uri = this.getEndpointUri();
            return StringHelper.before(uri, "?", uri);
        }
        return this.getEndpointUri();
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public AsyncProducer createAsyncProducer() throws Exception {
        if (this.isLazyStartProducer()) {
            return new LazyStartProducer(this);
        }
        return AsyncProcessorConverterHelper.convert(this.createProducer());
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public void setComponent(Component component) {
        this.component = component;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public PollingConsumer createPollingConsumer() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating EventDrivenPollingConsumer with queueSize: {} blockWhenFull: {} blockTimeout: {} copy: {}", new Object[]{this.getPollingConsumerQueueSize(), this.isPollingConsumerBlockWhenFull(), this.getPollingConsumerBlockTimeout(), this.isPollingConsumerCopy()});
        }
        EventDrivenPollingConsumer consumer = new EventDrivenPollingConsumer((Endpoint)this, this.getPollingConsumerQueueSize());
        consumer.setBlockWhenFull(this.isPollingConsumerBlockWhenFull());
        consumer.setBlockTimeout(this.getPollingConsumerBlockTimeout());
        consumer.setCopy(this.isPollingConsumerCopy());
        return consumer;
    }

    @Override
    public Exchange createExchange() {
        return this.createExchange(this.exchangePattern);
    }

    @Override
    public Exchange createExchange(ExchangePattern pattern) {
        DefaultExchange answer = DefaultExchange.newFromEndpoint(this, pattern);
        this.configureExchange(answer);
        return answer;
    }

    @Override
    public void configureExchange(Exchange exchange) {
    }

    @Override
    public ExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }

    public void setExchangePattern(ExchangePattern exchangePattern) {
        this.exchangePattern = exchangePattern;
    }

    public boolean isAutowiredEnabled() {
        return this.autowiredEnabled;
    }

    public void setAutowiredEnabled(boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public boolean isLazyStartProducer() {
        return this.lazyStartProducer;
    }

    public void setLazyStartProducer(boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public boolean isBridgeErrorHandler() {
        return this.bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public int getPollingConsumerQueueSize() {
        return this.pollingConsumerQueueSize;
    }

    public void setPollingConsumerQueueSize(int pollingConsumerQueueSize) {
        this.pollingConsumerQueueSize = pollingConsumerQueueSize;
    }

    public boolean isPollingConsumerBlockWhenFull() {
        return this.pollingConsumerBlockWhenFull;
    }

    public void setPollingConsumerBlockWhenFull(boolean pollingConsumerBlockWhenFull) {
        this.pollingConsumerBlockWhenFull = pollingConsumerBlockWhenFull;
    }

    public long getPollingConsumerBlockTimeout() {
        return this.pollingConsumerBlockTimeout;
    }

    public void setPollingConsumerBlockTimeout(long pollingConsumerBlockTimeout) {
        this.pollingConsumerBlockTimeout = pollingConsumerBlockTimeout;
    }

    public boolean isPollingConsumerCopy() {
        return this.pollingConsumerCopy;
    }

    public void setPollingConsumerCopy(boolean pollingConsumerCopy) {
        this.pollingConsumerCopy = pollingConsumerCopy;
    }

    @Override
    public void configureProperties(Map<String, Object> options) {
        this.setProperties(this, options);
    }

    public void setProperties(Object bean, Map<String, Object> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        PropertyConfigurer configurer = null;
        if (bean instanceof Component) {
            configurer = this.getComponent().getComponentPropertyConfigurer();
        } else if (bean instanceof Endpoint) {
            configurer = this.getComponent().getEndpointPropertyConfigurer();
        } else if (bean instanceof PropertyConfigurerAware) {
            configurer = ((PropertyConfigurerAware)bean).getPropertyConfigurer(bean);
        }
        PropertyBindingSupport.build().withConfigurer(configurer).withIgnoreCase(true).withOptional(this.isLenientProperties()).bind(this.camelContext, bean, parameters);
    }

    protected String createEndpointUri() {
        return null;
    }

    public void setEndpointUriIfNotSpecified(String value) {
        if (this.endpointUri == null) {
            this.setEndpointUri(value);
        }
    }

    protected void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    protected void configureConsumer(Consumer consumer) throws Exception {
        DefaultConsumer defaultConsumer;
        CamelContextAware.trySetCamelContext(consumer, this.camelContext);
        if (this.bridgeErrorHandler) {
            if (consumer instanceof DefaultConsumer) {
                defaultConsumer = (DefaultConsumer)consumer;
                defaultConsumer.setExceptionHandler(new BridgeExceptionHandlerToErrorHandler(defaultConsumer));
            } else {
                throw new IllegalArgumentException("Option bridgeErrorHandler is only supported by endpoints, having their consumer extend DefaultConsumer. The consumer is a " + consumer.getClass().getName() + " class.");
            }
        }
        if (this.exceptionHandler != null && consumer instanceof DefaultConsumer) {
            defaultConsumer = (DefaultConsumer)consumer;
            defaultConsumer.setExceptionHandler(this.exceptionHandler);
        }
    }

    protected void configurePollingConsumer(PollingConsumer consumer) throws Exception {
        this.configureConsumer(consumer);
    }

    @Override
    protected void doInit() throws Exception {
        PropertyConfigurerGetter getter;
        String[] names;
        PropertyConfigurer configurer;
        ObjectHelper.notNull(this.getCamelContext(), "camelContext");
        if (this.autowiredEnabled && this.getComponent() != null && this.getComponent().isAutowiredEnabled() && (configurer = this.getComponent().getEndpointPropertyConfigurer()) instanceof PropertyConfigurerGetter && (names = (getter = (PropertyConfigurerGetter)((Object)configurer)).getAutowiredNames()) != null) {
            for (String name : names) {
                boolean hit;
                Object value = getter.getOptionValue(this, name, true);
                if (value != null) continue;
                Class<?> type = getter.getOptionType(name, true);
                if (type != null) {
                    value = this.camelContext.getRegistry().findSingleByType(type);
                }
                if (value == null || !(hit = configurer.configure(this.camelContext, this, name, value, true)) || !LOG.isDebugEnabled()) continue;
                LOG.debug("Autowired property: {} on endpoint: {} as exactly one instance of type: {} ({}) found in the registry", new Object[]{name, this, type.getName(), value.getClass().getName()});
            }
        }
    }
}

