/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionOperation;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemValidator {
    public static final int CHECK_ACCESS = 1;
    public static final int CHECK_LOCK = 2;
    public static final int CHECK_CHECKED_OUT = 4;
    public static final int CHECK_REFERENCES = 8;
    public static final int CHECK_CONSTRAINTS = 16;
    public static final int CHECK_PENDING_CHANGES = 32;
    public static final int CHECK_PENDING_CHANGES_ON_NODE = 64;
    public static final int CHECK_HOLD = 128;
    public static final int CHECK_RETENTION = 256;
    private static Logger log = LoggerFactory.getLogger(ItemValidator.class);
    protected final SessionContext context;
    private int enabledChecks = -1;

    public ItemValidator(SessionContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T> T performRelaxed(SessionOperation<T> operation, int checksToDisable) throws RepositoryException {
        int previousChecks = this.enabledChecks;
        try {
            this.enabledChecks &= ~checksToDisable;
            log.debug("Performing {} with checks [{}] disabled", operation, (Object)Integer.toBinaryString(~this.enabledChecks));
            T t = operation.perform(this.context);
            return t;
        }
        finally {
            this.enabledChecks = previousChecks;
        }
    }

    public void validate(NodeState nodeState) throws ConstraintViolationException, RepositoryException {
        NodeTypeRegistry registry = this.context.getNodeTypeRegistry();
        EffectiveNodeType entPrimary = registry.getEffectiveNodeType(nodeState.getNodeTypeName());
        EffectiveNodeType entPrimaryAndMixins = this.getEffectiveNodeType(nodeState);
        QNodeDefinition def = this.context.getItemManager().getDefinition(nodeState).unwrap();
        for (Name requiredPrimaryType : def.getRequiredPrimaryTypes()) {
            if (entPrimary.includesNodeType(requiredPrimaryType)) continue;
            String msg = this.safeGetJCRPath(nodeState.getNodeId()) + ": missing required primary type " + requiredPrimaryType;
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        for (QPropertyDefinition pd : entPrimaryAndMixins.getMandatoryPropDefs()) {
            if (nodeState.hasPropertyName(pd.getName())) continue;
            String msg = this.safeGetJCRPath(nodeState.getNodeId()) + ": mandatory property " + pd.getName() + " does not exist";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        for (QNodeDefinition cnd : entPrimaryAndMixins.getMandatoryNodeDefs()) {
            if (nodeState.hasChildNodeEntry(cnd.getName())) continue;
            String msg = this.safeGetJCRPath(nodeState.getNodeId()) + ": mandatory child node " + cnd.getName() + " does not exist";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
    }

    public void validate(PropertyState propState) throws ConstraintViolationException, RepositoryException {
        QPropertyDefinition def = this.context.getItemManager().getDefinition(propState).unwrap();
        InternalValue[] values = propState.getValues();
        int type = 0;
        for (InternalValue value : values) {
            if (type == 0) {
                type = value.getType();
            } else if (type != value.getType()) {
                throw new ConstraintViolationException(this.safeGetJCRPath(propState.getPropertyId()) + ": inconsistent value types");
            }
            if (def.getRequiredType() == 0 || def.getRequiredType() == type) continue;
            throw new ConstraintViolationException(this.safeGetJCRPath(propState.getPropertyId()) + ": requiredType constraint is not satisfied");
        }
        EffectiveNodeType.checkSetPropertyValueConstraints(def, values);
    }

    public synchronized void checkModify(ItemImpl item, int options, int permissions) throws RepositoryException {
        this.checkCondition(item, options & this.enabledChecks, permissions, false);
    }

    public synchronized void checkRemove(ItemImpl item, int options, int permissions) throws RepositoryException {
        this.checkCondition(item, options & this.enabledChecks, permissions, true);
    }

    private void checkCondition(ItemImpl item, int options, int permissions, boolean isRemoval) throws RepositoryException {
        if ((options & 0x20) == 32 && item.getSession().hasPendingChanges()) {
            String msg = "Unable to perform operation. Session has pending changes.";
            log.debug(msg);
            throw new InvalidItemStateException(msg);
        }
        if ((options & 0x40) == 64 && item.isNode() && ((NodeImpl)item).hasPendingChanges()) {
            String msg = "Unable to perform operation. Session has pending changes.";
            log.debug(msg);
            throw new InvalidItemStateException(msg);
        }
        if ((options & 0x10) == 16 && this.isProtected(item)) {
            String msg = "Unable to perform operation. Node is protected.";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        if ((options & 4) == 4) {
            NodeImpl node;
            NodeImpl nodeImpl = node = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
            if (!node.isCheckedOut()) {
                String msg = "Unable to perform operation. Node is checked-in.";
                log.debug(msg);
                throw new VersionException(msg);
            }
        }
        if ((options & 2) == 2) {
            this.checkLock(item);
        }
        if (permissions > 0) {
            Path path = item.getPrimaryPath();
            this.context.getAccessManager().checkPermission(path, permissions);
        }
        if ((options & 0x80) == 128 && this.hasHold(item, isRemoval)) {
            throw new RepositoryException("Unable to perform operation. Node is affected by a hold.");
        }
        if ((options & 0x100) == 256 && this.hasRetention(item, isRemoval)) {
            throw new RepositoryException("Unable to perform operation. Node is affected by a retention.");
        }
    }

    public synchronized boolean canModify(ItemImpl item, int options, int permissions) throws RepositoryException {
        return this.hasCondition(item, options & this.enabledChecks, permissions, false);
    }

    private boolean hasCondition(ItemImpl item, int options, int permissions, boolean isRemoval) throws RepositoryException {
        if ((options & 0x20) == 32 && item.getSession().hasPendingChanges()) {
            return false;
        }
        if ((options & 0x40) == 64 && item.isNode() && ((NodeImpl)item).hasPendingChanges()) {
            return false;
        }
        if ((options & 0x10) == 16 && this.isProtected(item)) {
            return false;
        }
        if ((options & 4) == 4) {
            NodeImpl node;
            NodeImpl nodeImpl = node = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
            if (!node.isCheckedOut()) {
                return false;
            }
        }
        if ((options & 2) == 2) {
            try {
                this.checkLock(item);
            }
            catch (LockException e) {
                return false;
            }
        }
        if (permissions > 0) {
            Path path = item.getPrimaryPath();
            if (!this.context.getAccessManager().isGranted(path, permissions)) {
                return false;
            }
        }
        if ((options & 0x80) == 128 && this.hasHold(item, isRemoval)) {
            return false;
        }
        return (options & 0x100) != 256 || !this.hasRetention(item, isRemoval);
    }

    private void checkLock(ItemImpl item) throws LockException, RepositoryException {
        if (item.isNew()) {
            return;
        }
        NodeImpl node = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
        this.context.getWorkspace().getInternalLockManager().checkLock(node);
    }

    private boolean isProtected(ItemImpl item) throws RepositoryException {
        ItemDefinition def = item.isNode() ? ((Node)((Object)item)).getDefinition() : ((Property)((Object)item)).getDefinition();
        return def.isProtected();
    }

    private boolean hasHold(ItemImpl item, boolean isRemoval) throws RepositoryException {
        if (item.isNew()) {
            return false;
        }
        Path path = item.getPrimaryPath();
        if (!item.isNode()) {
            path = path.getAncestor(1);
        }
        boolean checkParent = item.isNode() && isRemoval;
        return this.context.getSessionImpl().getRetentionRegistry().hasEffectiveHold(path, checkParent);
    }

    private boolean hasRetention(ItemImpl item, boolean isRemoval) throws RepositoryException {
        if (item.isNew()) {
            return false;
        }
        Path path = item.getPrimaryPath();
        if (!item.isNode()) {
            path = path.getAncestor(1);
        }
        boolean checkParent = item.isNode() && isRemoval;
        return this.context.getSessionImpl().getRetentionRegistry().hasEffectiveRetention(path, checkParent);
    }

    public EffectiveNodeType getEffectiveNodeType(NodeState state) throws RepositoryException {
        try {
            return this.context.getNodeTypeRegistry().getEffectiveNodeType(state.getNodeTypeName(), state.getMixinTypeNames());
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "internal error: failed to build effective node type for node " + this.safeGetJCRPath(state.getNodeId());
            log.debug(msg);
            throw new RepositoryException(msg, ntce);
        }
    }

    public QNodeDefinition findApplicableNodeDefinition(Name name, Name nodeTypeName, NodeState parentState) throws RepositoryException, ConstraintViolationException {
        EffectiveNodeType entParent = this.getEffectiveNodeType(parentState);
        return entParent.getApplicableChildNodeDef(name, nodeTypeName, this.context.getNodeTypeRegistry());
    }

    public QPropertyDefinition findApplicablePropertyDefinition(Name name, int type, boolean multiValued, NodeState parentState) throws RepositoryException, ConstraintViolationException {
        EffectiveNodeType entParent = this.getEffectiveNodeType(parentState);
        return entParent.getApplicablePropertyDef(name, type, multiValued);
    }

    public QPropertyDefinition findApplicablePropertyDefinition(Name name, int type, NodeState parentState) throws RepositoryException, ConstraintViolationException {
        EffectiveNodeType entParent = this.getEffectiveNodeType(parentState);
        return entParent.getApplicablePropertyDef(name, type);
    }

    public String safeGetJCRPath(Path path) {
        try {
            return this.context.getJCRPath(path);
        }
        catch (NamespaceException e) {
            log.error("failed to convert {} to a JCR path", (Object)path);
            return path.toString();
        }
    }

    public String safeGetJCRPath(ItemId id) {
        try {
            return this.safeGetJCRPath(this.context.getHierarchyManager().getPath(id));
        }
        catch (ItemNotFoundException e) {
            return id.toString();
        }
        catch (RepositoryException e) {
            log.error(id + ": failed to build path");
            return id.toString();
        }
    }
}

