/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.File;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import javax.jcr.version.VersionException;
import javax.security.auth.Subject;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.AbstractSession;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.ItemValidator;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.SessionMoveOperation;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.gc.GarbageCollector;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.observation.ObservationManagerImpl;
import org.apache.jackrabbit.core.retention.RetentionManagerImpl;
import org.apache.jackrabbit.core.retention.RetentionRegistry;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionItemOperation;
import org.apache.jackrabbit.core.session.SessionOperation;
import org.apache.jackrabbit.core.session.SessionRefreshOperation;
import org.apache.jackrabbit.core.session.SessionSaveOperation;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.core.version.InternalVersionManager;
import org.apache.jackrabbit.core.xml.ImportHandler;
import org.apache.jackrabbit.core.xml.SessionImporter;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.SessionExtensions;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.IdentifierResolver;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public class SessionImpl
extends AbstractSession
implements JackrabbitSession,
SessionExtensions,
NamespaceResolver,
NamePathResolver,
IdentifierResolver {
    public static final String DISABLE_CLUSTER_SYNC_ON_REFRESH = "org.apache.jackrabbit.disableClusterSyncOnRefresh";
    public static final String AUTO_FIX_CORRUPTIONS = "org.apache.jackrabbit.autoFixCorruptions";
    private static Logger log = LoggerFactory.getLogger(SessionImpl.class);
    private static final AtomicLong SESSION_COUNTER = new AtomicLong();
    protected final SessionContext context;
    protected final RepositoryContext repositoryContext;
    protected AuthContext loginContext;
    protected final Subject subject;
    protected final String userId;
    private final String sessionName;
    protected final Map<String, Object> attributes = new HashMap<String, Object>();
    protected NamePathResolver namePathResolver;
    protected final InternalVersionManager versionMgr;
    protected final Map<SessionListener, SessionListener> listeners = new ReferenceMap<SessionListener, SessionListener>(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.WEAK);
    private PrincipalManager principalManager;
    private UserManager userManager;
    private RetentionManager retentionManager;
    private final Exception openStackTrace;

    protected SessionImpl(RepositoryContext repositoryContext, AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        this(repositoryContext, loginContext.getSubject(), wspConfig);
        this.loginContext = loginContext;
    }

    protected SessionImpl(RepositoryContext repositoryContext, Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        this.context = new SessionContext(repositoryContext, this, wspConfig);
        this.repositoryContext = repositoryContext;
        this.subject = subject;
        this.userId = this.retrieveUserId(subject, wspConfig.getName());
        long count = SESSION_COUNTER.incrementAndGet();
        if (this.userId != null) {
            String user = Text.escapeIllegalJcrChars(this.userId);
            this.sessionName = "session-" + user + "-" + count;
        } else {
            this.sessionName = "session-" + count;
        }
        this.namePathResolver = new DefaultNamePathResolver(this, this, true);
        this.context.setItemStateManager(this.createSessionItemStateManager());
        this.context.setItemManager(this.createItemManager());
        this.context.setAccessManager(this.createAccessManager(subject));
        this.context.setObservationManager(this.createObservationManager(wspConfig.getName()));
        this.versionMgr = this.createVersionManager();
        this.openStackTrace = log.isWarnEnabled() ? new Exception("Stack Trace") : null;
    }

    protected String retrieveUserId(Subject subject, String workspaceName) throws RepositoryException {
        return this.repositoryContext.getSecurityManager().getUserID(subject, workspaceName);
    }

    protected SessionItemStateManager createSessionItemStateManager() {
        SessionItemStateManager mgr = new SessionItemStateManager(this.context.getRootNodeId(), this.context.getWorkspace().getItemStateManager());
        this.context.getWorkspace().getItemStateManager().addListener(mgr);
        return mgr;
    }

    protected ItemManager createItemManager() {
        ItemManager mgr = new ItemManager(this.context);
        this.context.getItemStateManager().addListener(mgr);
        return mgr;
    }

    protected ObservationManagerImpl createObservationManager(String wspName) throws RepositoryException {
        try {
            return new ObservationManagerImpl(this.context.getRepository().getObservationDispatcher(wspName), this, this.context.getRepositoryContext().getClusterNode());
        }
        catch (NoSuchWorkspaceException e) {
            throw new RepositoryException("Internal error: failed to create observation manager", e);
        }
    }

    protected InternalVersionManager createVersionManager() throws RepositoryException {
        return this.context.getRepositoryContext().getInternalVersionManager();
    }

    protected AccessManager createAccessManager(Subject subject) throws AccessDeniedException, RepositoryException {
        String wspName = this.getWorkspace().getName();
        AMContext ctx = new AMContext(new File(this.context.getRepository().getConfig().getHomeDir()), this.context.getRepositoryContext().getFileSystem(), this, subject, this.context.getHierarchyManager(), this.context.getPrivilegeManager(), this, wspName);
        return this.repositoryContext.getSecurityManager().getAccessManager(this, ctx);
    }

    private <T> T perform(SessionOperation<T> operation) throws RepositoryException {
        return this.context.getSessionState().perform(operation);
    }

    private void sanityCheck() throws RepositoryException {
        this.context.getSessionState().checkAlive();
    }

    public Subject getSubject() {
        Subject readOnly = new Subject(true, this.subject.getPrincipals(), this.subject.getPublicCredentials(), this.subject.getPrivateCredentials());
        return readOnly;
    }

    public boolean isSystem() {
        return this.subject != null && !this.subject.getPrincipals(SystemPrincipal.class).isEmpty();
    }

    public boolean isAdmin() {
        if (this.userManager != null) {
            try {
                Authorizable a = this.userManager.getAuthorizable(this.userId);
                if (a != null && !a.isGroup()) {
                    return ((User)a).isAdmin();
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return this.subject != null && !this.subject.getPrincipals(AdminPrincipal.class).isEmpty();
    }

    public Session createSession(String workspaceName) throws AccessDeniedException, NoSuchWorkspaceException, RepositoryException {
        if (workspaceName == null) {
            workspaceName = this.repositoryContext.getWorkspaceManager().getDefaultWorkspaceName();
        }
        Subject newSubject = new Subject(this.subject.isReadOnly(), this.subject.getPrincipals(), this.subject.getPublicCredentials(), this.subject.getPrivateCredentials());
        return this.repositoryContext.getWorkspaceManager().createSession(newSubject, workspaceName);
    }

    public AccessManager getAccessManager() {
        return this.context.getAccessManager();
    }

    public NodeTypeManagerImpl getNodeTypeManager() {
        return this.context.getNodeTypeManager();
    }

    public ItemManager getItemManager() {
        return this.context.getItemManager();
    }

    public HierarchyManager getHierarchyManager() {
        return this.context.getHierarchyManager();
    }

    public InternalVersionManager getInternalVersionManager() {
        return this.versionMgr;
    }

    protected RetentionRegistry getRetentionRegistry() throws RepositoryException {
        return this.context.getWorkspace().getRetentionRegistry();
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public NodeImpl getNodeById(NodeId id) throws ItemNotFoundException, RepositoryException {
        this.sanityCheck();
        try {
            return (NodeImpl)this.getItemManager().getItem(id);
        }
        catch (AccessDeniedException ade) {
            throw new ItemNotFoundException(id.toString());
        }
    }

    protected void notifyLoggingOut() {
        ArrayList<SessionListener> copy = new ArrayList<SessionListener>(this.listeners.values());
        for (SessionListener listener : copy) {
            if (listener == null) continue;
            listener.loggingOut(this);
        }
    }

    protected void notifyLoggedOut() {
        ArrayList<SessionListener> copy = new ArrayList<SessionListener>(this.listeners.values());
        for (SessionListener listener : copy) {
            if (listener == null) continue;
            listener.loggedOut(this);
        }
    }

    public void addListener(SessionListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    public void removeListener(SessionListener listener) {
        this.listeners.remove(listener);
    }

    public GarbageCollector createDataStoreGarbageCollector() throws RepositoryException {
        final GarbageCollector gc = this.repositoryContext.getRepository().createDataStoreGarbageCollector();
        this.addListener(new SessionListener(){

            @Override
            public void loggedOut(SessionImpl session) {
            }

            @Override
            public void loggingOut(SessionImpl session) {
                gc.close();
            }
        });
        return gc;
    }

    @Override
    public String getPrefix(String uri) throws NamespaceException {
        try {
            return this.getNamespacePrefix(uri);
        }
        catch (NamespaceException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new NamespaceException("Namespace not found: " + uri, e);
        }
    }

    @Override
    public String getURI(String prefix) throws NamespaceException {
        try {
            return this.getNamespaceURI(prefix);
        }
        catch (NamespaceException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new NamespaceException("Namespace not found: " + prefix, e);
        }
    }

    @Override
    public String getJCRName(Name name) throws NamespaceException {
        return this.namePathResolver.getJCRName(name);
    }

    @Override
    public Name getQName(String name) throws IllegalNameException, NamespaceException {
        return this.namePathResolver.getQName(name);
    }

    @Override
    public String getJCRPath(Path path) throws NamespaceException {
        return this.namePathResolver.getJCRPath(path);
    }

    @Override
    public Path getQPath(String path) throws MalformedPathException, IllegalNameException, NamespaceException {
        return this.namePathResolver.getQPath(path);
    }

    @Override
    public Path getQPath(String path, boolean normalizeIdentifier) throws MalformedPathException, IllegalNameException, NamespaceException {
        return this.namePathResolver.getQPath(path, normalizeIdentifier);
    }

    @Override
    public Path getPath(String identifier) throws MalformedPathException {
        try {
            return this.context.getHierarchyManager().getPath(NodeId.valueOf(identifier));
        }
        catch (RepositoryException e) {
            throw new MalformedPathException("Identifier '" + identifier + "' cannot be resolved.");
        }
    }

    @Override
    public void checkFormat(String identifier) throws MalformedPathException {
        try {
            NodeId.valueOf(identifier);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedPathException("Invalid identifier: " + identifier);
        }
    }

    @Override
    public boolean hasPermission(String absPath, String ... actions) throws RepositoryException {
        return this.hasPermission(absPath, Text.implode(actions, ","));
    }

    @Override
    public PrincipalManager getPrincipalManager() throws RepositoryException, AccessDeniedException {
        if (this.principalManager == null) {
            this.principalManager = this.repositoryContext.getSecurityManager().getPrincipalManager(this);
        }
        return this.principalManager;
    }

    @Override
    public UserManager getUserManager() throws AccessDeniedException, RepositoryException {
        if (this.userManager == null) {
            this.userManager = this.repositoryContext.getSecurityManager().getUserManager(this);
        }
        return this.userManager;
    }

    @Override
    public Item getItemOrNull(String absPath) throws RepositoryException {
        if (this.itemExists(absPath)) {
            return this.getItem(absPath);
        }
        return null;
    }

    @Override
    public Property getPropertyOrNull(String absPath) throws RepositoryException {
        if (this.propertyExists(absPath)) {
            return this.getProperty(absPath);
        }
        return null;
    }

    @Override
    public Node getNodeOrNull(String absPath) throws RepositoryException {
        if (this.nodeExists(absPath)) {
            return this.getNode(absPath);
        }
        return null;
    }

    @Override
    public void checkPermission(String absPath, String actions) throws AccessControlException, RepositoryException {
        if (!this.hasPermission(absPath, actions)) {
            throw new AccessControlException(actions);
        }
    }

    @Override
    public Workspace getWorkspace() {
        return this.context.getWorkspace();
    }

    @Override
    public Session impersonate(Credentials otherCredentials) throws LoginException, RepositoryException {
        this.sanityCheck();
        if (!(otherCredentials instanceof SimpleCredentials)) {
            String msg = "impersonate failed: incompatible credentials, SimpleCredentials expected";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        SimpleCredentials creds = (SimpleCredentials)otherCredentials;
        creds.setAttribute("org.apache.jackrabbit.core.security.impersonator", this.subject);
        try {
            Session session = this.getRepository().login(otherCredentials, this.getWorkspace().getName());
            return session;
        }
        catch (NoSuchWorkspaceException nswe) {
            String msg = "impersonate failed";
            log.error(msg, (Throwable)nswe);
            throw new RepositoryException(msg, nswe);
        }
        finally {
            creds.removeAttribute("org.apache.jackrabbit.core.security.impersonator");
        }
    }

    @Override
    public Node getRootNode() throws RepositoryException {
        this.sanityCheck();
        return this.getItemManager().getRootNode();
    }

    @Override
    public Node getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        try {
            NodeImpl node = this.getNodeById(new NodeId(uuid));
            if (node.isNodeType(NameConstants.MIX_REFERENCEABLE)) {
                return node;
            }
            throw new ItemNotFoundException(uuid);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException("Invalid UUID: " + uuid, e);
        }
    }

    @Override
    public Item getItem(String absPath) throws RepositoryException {
        return this.perform(SessionItemOperation.getItem(absPath));
    }

    @Override
    public boolean itemExists(String absPath) throws RepositoryException {
        if (absPath != null && absPath.startsWith("[") && absPath.endsWith("]")) {
            try {
                NodeId id = NodeId.valueOf(absPath.substring(1, absPath.length() - 1));
                return this.getItemManager().itemExists(id);
            }
            catch (IllegalArgumentException e) {
                throw new MalformedPathException(absPath);
            }
        }
        return this.perform(SessionItemOperation.itemExists(absPath));
    }

    @Override
    public void save() throws RepositoryException {
        if (this.context.getItemStateManager().hasAnyTransientItemStates()) {
            this.perform(new SessionSaveOperation());
        }
    }

    @Override
    public void refresh(boolean keepChanges) throws RepositoryException {
        this.perform(new SessionRefreshOperation(keepChanges, this.clusterSyncOnRefresh()));
    }

    protected boolean clusterSyncOnRefresh() {
        return this.getAttribute(DISABLE_CLUSTER_SYNC_ON_REFRESH) == null;
    }

    protected boolean autoFixCorruptions() {
        return this.getAttribute(AUTO_FIX_CORRUPTIONS) != null;
    }

    @Override
    public boolean hasPendingChanges() throws RepositoryException {
        this.sanityCheck();
        return this.context.getItemStateManager().hasAnyTransientItemStates();
    }

    @Override
    public void move(String srcAbsPath, String destAbsPath) throws RepositoryException {
        this.perform(new SessionMoveOperation(this, srcAbsPath, destAbsPath));
    }

    @Override
    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        NodeImpl parent;
        this.sanityCheck();
        try {
            Path p = this.getQPath(parentAbsPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + parentAbsPath);
            }
            parent = this.getItemManager().getNode(p);
        }
        catch (NameException e) {
            String msg = parentAbsPath + ": invalid path";
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(parentAbsPath);
        }
        int options = 406;
        this.context.getItemValidator().checkModify(parent, options, 0);
        SessionImporter importer = new SessionImporter(parent, this, uuidBehavior, this.context.getWorkspace().getConfig().getImportConfig());
        return new ImportHandler(importer, this);
    }

    @Override
    public boolean isLive() {
        return this.context.getSessionState().isAlive();
    }

    private void removeRegisteredEventListeners() {
        try {
            ObservationManager manager = this.getWorkspace().getObservationManager();
            List<EventListener> listeners = IteratorUtils.toList(manager.getRegisteredEventListeners());
            for (EventListener listener : listeners) {
                try {
                    manager.removeEventListener(listener);
                }
                catch (RepositoryException e) {
                    log.warn("Error removing event listener: " + listener, (Throwable)e);
                }
            }
        }
        catch (RepositoryException e) {
            log.warn("Error removing event listeners", (Throwable)e);
        }
    }

    @Override
    public void logout() {
        if (this.context.getSessionState().close()) {
            this.removeRegisteredEventListeners();
            this.context.getItemStateManager().disposeAllTransientItemStates();
            this.notifyLoggingOut();
            this.context.getPrivilegeManager().dispose();
            this.context.getNodeTypeManager().dispose();
            this.context.getItemStateManager().dispose();
            this.context.getItemManager().dispose();
            this.context.getWorkspace().dispose();
            if (this.loginContext != null) {
                try {
                    this.loginContext.logout();
                }
                catch (javax.security.auth.login.LoginException le) {
                    log.warn("failed to logout current subject: " + le.getMessage());
                }
                this.loginContext = null;
            }
            try {
                this.context.getAccessManager().close();
            }
            catch (Exception e) {
                log.warn("error while closing AccessManager", (Throwable)e);
            }
            this.notifyLoggedOut();
        }
    }

    @Override
    public Repository getRepository() {
        return this.repositoryContext.getRepository();
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.context.getValueFactory();
    }

    @Override
    public String getUserID() {
        return this.userId;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    @Override
    public void setNamespacePrefix(String prefix, String uri) throws NamespaceException, RepositoryException {
        super.setNamespacePrefix(prefix, uri);
        this.namePathResolver = new DefaultNamePathResolver(this, true);
    }

    @Override
    public void addLockToken(String lt) {
        try {
            this.getWorkspace().getLockManager().addLockToken(lt);
        }
        catch (RepositoryException e) {
            log.debug("Error while adding lock token.");
        }
    }

    @Override
    public String[] getLockTokens() {
        try {
            return this.getWorkspace().getLockManager().getLockTokens();
        }
        catch (RepositoryException e) {
            log.debug("Error while accessing lock tokens.");
            return new String[0];
        }
    }

    @Override
    public void removeLockToken(String lt) {
        try {
            this.getWorkspace().getLockManager().removeLockToken(lt);
        }
        catch (RepositoryException e) {
            log.debug("Error while removing lock token.");
        }
    }

    public Lock[] getLocks() {
        if (!this.isLive()) {
            log.error("failed to retrieve locks: session has been closed");
            return new Lock[0];
        }
        try {
            return this.context.getWorkspace().getInternalLockManager().getLocks(this);
        }
        catch (RepositoryException e) {
            log.error("Lock manager not available.", (Throwable)e);
            return new Lock[0];
        }
    }

    @Override
    public Node getNodeByIdentifier(String id) throws ItemNotFoundException, RepositoryException {
        NodeId nodeId;
        try {
            nodeId = NodeId.valueOf(id);
        }
        catch (IllegalArgumentException iae) {
            throw new RepositoryException("invalid identifier: " + id, iae);
        }
        return this.getNodeById(nodeId);
    }

    @Override
    public Node getNode(String absPath) throws RepositoryException {
        return this.perform(SessionItemOperation.getNode(absPath));
    }

    @Override
    public Property getProperty(String absPath) throws RepositoryException {
        return this.perform(SessionItemOperation.getProperty(absPath));
    }

    @Override
    public boolean nodeExists(String absPath) throws RepositoryException {
        if (absPath != null && absPath.startsWith("[") && absPath.endsWith("]")) {
            try {
                NodeId id = NodeId.valueOf(absPath.substring(1, absPath.length() - 1));
                return this.getItemManager().itemExists(id);
            }
            catch (IllegalArgumentException e) {
                throw new MalformedPathException(absPath);
            }
        }
        return this.perform(SessionItemOperation.nodeExists(absPath));
    }

    @Override
    public boolean propertyExists(String absPath) throws RepositoryException {
        return this.perform(SessionItemOperation.propertyExists(absPath));
    }

    @Override
    public void removeItem(String absPath) throws RepositoryException {
        this.perform(SessionItemOperation.remove(absPath));
    }

    @Override
    public boolean hasPermission(String absPath, String actions) throws RepositoryException {
        this.sanityCheck();
        Path path = this.getQPath(absPath).getNormalizedPath();
        if (!path.isAbsolute()) {
            throw new RepositoryException("Absolute path expected. Was:" + absPath);
        }
        HashSet<String> s = new HashSet<String>(Arrays.asList(actions.split(",")));
        int permissions = 0;
        if (s.remove("read")) {
            permissions |= 1;
        }
        if (s.remove("add_node")) {
            permissions |= 4;
        }
        if (s.remove("set_property")) {
            permissions |= 2;
        }
        if (s.remove("remove")) {
            permissions = this.nodeExists(absPath) ? (permissions |= this.propertyExists(absPath) ? 24 : 8) : (this.propertyExists(absPath) ? (permissions |= 0x10) : 24);
        }
        if (!s.isEmpty()) {
            throw new IllegalArgumentException("Unknown actions: " + s);
        }
        try {
            return this.context.getAccessManager().isGranted(path, permissions);
        }
        catch (AccessDeniedException e) {
            return false;
        }
    }

    @Override
    public boolean hasCapability(String methodName, Object target, Object[] arguments) throws RepositoryException {
        ItemValidator validator = this.context.getItemValidator();
        int options = 406;
        if (target instanceof Node) {
            if (methodName.equals("addNode") || methodName.equals("addMixin") || methodName.equals("orderBefore") || methodName.equals("removeMixin") || methodName.equals("removeShare") || methodName.equals("removeSharedSet") || methodName.equals("setPrimaryType") || methodName.equals("setProperty") || methodName.equals("update")) {
                return validator.canModify((ItemImpl)target, options, 0);
            }
            if (methodName.equals("remove")) {
                try {
                    validator.checkRemove((ItemImpl)target, options, 0);
                }
                catch (RepositoryException e) {
                    return false;
                }
            }
        } else if (target instanceof Property) {
            if (methodName.equals("setValue") || methodName.equals("save")) {
                return validator.canModify((ItemImpl)target, options, 0);
            }
            if (methodName.equals("remove")) {
                try {
                    validator.checkRemove((ItemImpl)target, options, 0);
                }
                catch (RepositoryException e) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public AccessControlManager getAccessControlManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        AccessManager accessMgr = this.context.getAccessManager();
        if (accessMgr instanceof AccessControlManager) {
            return (AccessControlManager)((Object)accessMgr);
        }
        throw new UnsupportedRepositoryOperationException("Access control discovery is not supported.");
    }

    @Override
    public RetentionManager getRetentionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.sanityCheck();
        if (this.retentionManager == null) {
            this.getRetentionRegistry();
            this.retentionManager = new RetentionManagerImpl(this);
        }
        return this.retentionManager;
    }

    public String toString() {
        return this.sessionName;
    }

    public void finalize() {
        if (this.isLive()) {
            if (this.openStackTrace != null) {
                log.warn("Unclosed session detected. The session was opened here: ", (Throwable)this.openStackTrace);
            }
            this.logout();
        }
    }
}

