/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.AbstractDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.FileDataRecord;
import org.apache.jackrabbit.core.data.MultiDataStoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDataStore
extends AbstractDataStore
implements MultiDataStoreAware {
    private static Logger log = LoggerFactory.getLogger(FileDataStore.class);
    private static final int DEFAULT_MIN_RECORD_LENGTH = 100;
    private static final int ACCESS_TIME_RESOLUTION = 2000;
    private static final String TMP = "tmp";
    private volatile long minModifiedDate;
    private File directory;
    private String path;
    private int minRecordLength = 100;
    protected Map<DataIdentifier, WeakReference<DataIdentifier>> inUse = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public void init(String homeDir) {
        if (this.path == null) {
            this.path = homeDir + "/repository/datastore";
        }
        this.directory = new File(this.path);
        this.directory.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataRecord getRecordIfStored(DataIdentifier identifier) throws DataStoreException {
        File file = this.getFile(identifier);
        if (!file.exists()) {
            return null;
        }
        if (this.minModifiedDate != 0L) {
            FileDataStore fileDataStore = this;
            synchronized (fileDataStore) {
                if (FileDataStore.getLastModified(file) < this.minModifiedDate) {
                    FileDataStore.setLastModified(file, System.currentTimeMillis() + 2000L);
                }
            }
        }
        this.usesIdentifier(identifier);
        return new FileDataRecord(this, identifier, file);
    }

    private void usesIdentifier(DataIdentifier identifier) {
        this.inUse.put(identifier, new WeakReference<DataIdentifier>(identifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataRecord addRecord(InputStream input) throws DataStoreException {
        File temporary = null;
        try {
            File file;
            temporary = this.newTemporaryFile();
            DataIdentifier tempId = new DataIdentifier(temporary.getName());
            this.usesIdentifier(tempId);
            long length = 0L;
            MessageDigest digest = MessageDigest.getInstance(this.DIGEST);
            try (DigestOutputStream output = new DigestOutputStream(new FileOutputStream(temporary), digest);){
                length = IOUtils.copyLarge((InputStream)input, (OutputStream)output);
            }
            DataIdentifier identifier = new DataIdentifier(FileDataStore.encodeHexString(digest.digest()));
            Object object = this;
            synchronized (object) {
                this.usesIdentifier(identifier);
                file = this.getFile(identifier);
                if (!file.exists()) {
                    File parent = file.getParentFile();
                    parent.mkdirs();
                    Files.move(temporary.toPath(), file.toPath(), StandardCopyOption.ATOMIC_MOVE);
                    temporary = null;
                } else {
                    long now = System.currentTimeMillis();
                    if (FileDataStore.getLastModified(file) < now + 2000L) {
                        FileDataStore.setLastModified(file, now + 2000L);
                    }
                }
                if (file.length() != length) {
                    if (!file.isFile()) {
                        throw new IOException("Not a file: " + file);
                    }
                    throw new IOException(this.DIGEST + " collision: " + file);
                }
            }
            this.inUse.remove(tempId);
            object = new FileDataRecord(this, identifier, file);
            return object;
        }
        catch (NoSuchAlgorithmException e) {
            throw new DataStoreException(this.DIGEST + " not available", e);
        }
        catch (IOException e) {
            throw new DataStoreException("Could not add record", e);
        }
        finally {
            if (temporary != null) {
                temporary.delete();
            }
        }
    }

    private File getFile(DataIdentifier identifier) {
        this.usesIdentifier(identifier);
        String string = identifier.toString();
        File file = this.directory;
        file = new File(file, string.substring(0, 2));
        file = new File(file, string.substring(2, 4));
        file = new File(file, string.substring(4, 6));
        return new File(file, string);
    }

    private File newTemporaryFile() throws IOException {
        return File.createTempFile(TMP, null, this.directory);
    }

    @Override
    public void updateModifiedDateOnAccess(long before) {
        this.minModifiedDate = before;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRecord(DataIdentifier identifier) throws DataStoreException {
        File file = this.getFile(identifier);
        FileDataStore fileDataStore = this;
        synchronized (fileDataStore) {
            if (file.exists()) {
                if (file.delete()) {
                    this.deleteEmptyParentDirs(file);
                } else {
                    log.warn("Failed to delete file " + file.getAbsolutePath());
                }
            }
        }
    }

    private void deleteEmptyParentDirs(File file) {
        File parent = file.getParentFile();
        try {
            while (FileUtils.directoryContains((File)this.directory, (File)parent)) {
                String[] entries = parent.list();
                if (entries == null) {
                    log.warn("Failed to list directory {}", (Object)parent.getAbsolutePath());
                } else if (entries.length <= 0) {
                    boolean deleted = parent.delete();
                    log.debug("Deleted parent [{}] of file [{}]: {}", new Object[]{parent, file.getAbsolutePath(), deleted});
                    parent = parent.getParentFile();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            log.warn("Error in parents deletion for " + file.getAbsoluteFile(), (Throwable)e);
        }
    }

    @Override
    public int deleteAllOlderThan(long min) {
        int count = 0;
        for (File file : this.directory.listFiles()) {
            if (!file.isDirectory()) continue;
            count += this.deleteOlderRecursive(file, min);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteOlderRecursive(File file, long min) {
        int count = 0;
        if (file.isFile() && file.exists() && file.canWrite()) {
            FileDataStore fileDataStore = this;
            synchronized (fileDataStore) {
                DataIdentifier id;
                long l;
                try {
                    l = FileDataStore.getLastModified(file);
                }
                catch (DataStoreException e) {
                    log.warn("Failed to read modification date; file not deleted", (Throwable)e);
                    l = min;
                }
                if (l < min && !this.inUse.containsKey(id = new DataIdentifier(file.getName()))) {
                    if (log.isInfoEnabled()) {
                        log.info("Deleting old file " + file.getAbsolutePath() + " modified: " + new Timestamp(l).toString() + " length: " + file.length());
                    }
                    if (!file.delete()) {
                        log.warn("Failed to delete old file " + file.getAbsolutePath());
                    }
                    ++count;
                }
            }
        }
        if (file.isDirectory()) {
            File[] list = file.listFiles();
            if (list != null) {
                for (File f : list) {
                    count += this.deleteOlderRecursive(f, min);
                }
            }
            FileDataStore fileDataStore = this;
            synchronized (fileDataStore) {
                list = file.listFiles();
                if (list != null && list.length == 0) {
                    file.delete();
                }
            }
        }
        return count;
    }

    private void listRecursive(List<File> list, File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.listRecursive(list, f);
                    continue;
                }
                list.add(f);
            }
        }
    }

    @Override
    public Iterator<DataIdentifier> getAllIdentifiers() {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : this.directory.listFiles()) {
            if (!file.isDirectory()) continue;
            this.listRecursive(files, file);
        }
        ArrayList<DataIdentifier> identifiers = new ArrayList<DataIdentifier>();
        for (File f : files) {
            String name = f.getName();
            identifiers.add(new DataIdentifier(name));
        }
        log.debug("Found " + identifiers.size() + " identifiers.");
        return identifiers.iterator();
    }

    @Override
    public void clearInUse() {
        this.inUse.clear();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String directoryName) {
        this.path = directoryName;
    }

    @Override
    public int getMinRecordLength() {
        return this.minRecordLength;
    }

    public void setMinRecordLength(int minRecordLength) {
        this.minRecordLength = minRecordLength;
    }

    @Override
    public void close() {
    }

    @Override
    protected byte[] getOrCreateReferenceKey() throws DataStoreException {
        File file = new File(this.directory, "reference.key");
        try {
            if (file.exists()) {
                return FileUtils.readFileToByteArray((File)file);
            }
            byte[] key = super.getOrCreateReferenceKey();
            FileUtils.writeByteArrayToFile((File)file, (byte[])key);
            return key;
        }
        catch (IOException e) {
            throw new DataStoreException("Unable to access reference key file " + file.getPath(), e);
        }
    }

    private static long getLastModified(File file) throws DataStoreException {
        long lastModified = file.lastModified();
        if (lastModified == 0L) {
            throw new DataStoreException("Failed to read record modified date: " + file.getAbsolutePath());
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLastModified(File file, long time) throws DataStoreException {
        if (!file.setLastModified(time)) {
            if (!file.canWrite()) {
                return;
            }
            try (RandomAccessFile r = new RandomAccessFile(file, "rw");){
                r.setLength(r.length());
            }
            catch (IOException e) {
                throw new DataStoreException("An IO Exception occurred while trying to set the last modified date: " + file.getAbsolutePath(), e);
            }
        }
    }
}

