/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.session;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.cluster.ClusterException;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionOperation;

public class SessionRefreshOperation
implements SessionOperation<Object> {
    private final boolean keepChanges;
    private final boolean clusterSync;

    public SessionRefreshOperation(boolean keepChanges, boolean clusterSync) {
        this.keepChanges = keepChanges;
        this.clusterSync = clusterSync;
    }

    @Override
    public Object perform(SessionContext context) throws RepositoryException {
        ClusterNode cluster = context.getRepositoryContext().getClusterNode();
        if (cluster != null && this.clusterSync) {
            try {
                cluster.sync();
            }
            catch (ClusterException e) {
                throw new RepositoryException("Unable to synchronize with the cluster", e);
            }
        }
        if (!this.keepChanges) {
            context.getItemStateManager().disposeAllTransientItemStates();
        }
        return this;
    }

    public String toString() {
        return "session.refresh(" + this.keepChanges + ")";
    }
}

