/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Calendar;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.core.AbstractNodeData;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.version.InternalFrozenNode;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.VersionHistoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionImpl
extends NodeImpl
implements Version {
    private static Logger log = LoggerFactory.getLogger(VersionImpl.class);

    public VersionImpl(ItemManager itemMgr, SessionContext sessionContext, AbstractNodeData data) {
        super(itemMgr, sessionContext, data);
    }

    protected InternalVersion getInternalVersion() throws RepositoryException {
        SessionImpl session = this.sessionContext.getSessionImpl();
        InternalVersion version = session.getInternalVersionManager().getVersion((NodeId)this.id);
        if (version == null) {
            throw new InvalidItemStateException(this.id + ": the item does not exist anymore");
        }
        return version;
    }

    @Override
    public Calendar getCreated() throws RepositoryException {
        return this.getInternalVersion().getCreated();
    }

    @Override
    public Version[] getSuccessors() throws RepositoryException {
        List<InternalVersion> suc = this.getInternalVersion().getSuccessors();
        Version[] ret = new Version[suc.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Version)((Object)this.sessionContext.getSessionImpl().getNodeById(suc.get(i).getId()));
        }
        return ret;
    }

    @Override
    public Version[] getPredecessors() throws RepositoryException {
        InternalVersion[] pred = this.getInternalVersion().getPredecessors();
        Version[] ret = new Version[pred.length];
        for (int i = 0; i < pred.length; ++i) {
            ret[i] = (Version)((Object)this.sessionContext.getSessionImpl().getNodeById(pred[i].getId()));
        }
        return ret;
    }

    @Override
    public Version getLinearSuccessor() throws RepositoryException {
        SessionImpl session = this.sessionContext.getSessionImpl();
        InternalVersionHistory vh = ((VersionHistoryImpl)this.getContainingHistory()).getInternalVersionHistory();
        NodeImpl vn = session.getNodeById(vh.getVersionableId());
        InternalVersion base = ((VersionImpl)vn.getBaseVersion()).getInternalVersion();
        InternalVersion suc = this.getInternalVersion().getLinearSuccessor(base);
        return suc == null ? null : (Version)((Object)session.getNodeById(suc.getId()));
    }

    @Override
    public Version getLinearPredecessor() throws RepositoryException {
        InternalVersion pred = this.getInternalVersion().getLinearPredecessor();
        return pred == null ? null : (Version)((Object)this.sessionContext.getSessionImpl().getNodeById(pred.getId()));
    }

    @Override
    public VersionHistory getContainingHistory() throws RepositoryException {
        return (VersionHistory)this.getParent();
    }

    public InternalFrozenNode getInternalFrozenNode() throws RepositoryException {
        return this.getInternalVersion().getFrozenNode();
    }

    @Override
    public Node getFrozenNode() throws RepositoryException {
        return this.sessionContext.getSessionImpl().getNodeById(this.getInternalVersion().getFrozenNodeId());
    }

    @Override
    public boolean isSame(Item otherItem) {
        if (otherItem instanceof VersionImpl) {
            try {
                InternalVersion other = ((VersionImpl)otherItem).getInternalVersion();
                return other.getId().equals(this.getInternalVersion().getId());
            }
            catch (RepositoryException e) {
                log.warn("Unable to retrieve internal version objects: " + e.getMessage());
                log.debug("Stack dump:", (Throwable)e);
            }
        }
        return false;
    }

    public boolean isMoreRecent(VersionImpl v) throws RepositoryException {
        return this.getInternalVersion().isMoreRecent(v.getInternalVersion());
    }

    public boolean isRootVersion() throws RepositoryException {
        return this.getInternalVersion().isRootVersion();
    }

    @Override
    public void update(String srcWorkspaceName) throws ConstraintViolationException {
        String msg = "update operation not allowed: " + this;
        log.debug(msg);
        throw new ConstraintViolationException(msg);
    }

    @Override
    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws ConstraintViolationException {
        String msg = "merge operation not allowed: " + this;
        log.debug(msg);
        throw new ConstraintViolationException(msg);
    }

    @Override
    public String toString() {
        return "version " + super.toString();
    }
}

