/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups.raft;

import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.component.jgroups.raft.JGroupsRaftEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsRaftProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(JGroupsRaftProducer.class);
    private final JGroupsRaftEndpoint endpoint;

    public JGroupsRaftProducer(JGroupsRaftEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.connect();
    }

    @Override
    protected void doStop() throws Exception {
        this.endpoint.disconnect();
        super.doStop();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        byte[] body = exchange.getIn().getBody(byte[].class);
        Integer setOffset = exchange.getIn().getHeader("JGROUPSRAFT_SET_OFFSET", Integer.class);
        Integer setLength = exchange.getIn().getHeader("JGROUPSRAFT_SET_LENGTH", Integer.class);
        Long setTimeout = exchange.getIn().getHeader("JGROUPSRAFT_SET_TIMEOUT", Long.class);
        TimeUnit setTimeUnit = exchange.getIn().getHeader("JGROUPSRAFT_SET_TIMEUNIT", TimeUnit.class);
        if (body != null) {
            byte[] result;
            if (setOffset != null && setLength != null && setTimeout != null && setTimeUnit != null) {
                LOG.debug("Calling set(byte[] {}, int {}, int {}, long {}, TimeUnit {}) method on raftHandle.", new Object[]{body, setOffset, setLength, setTimeout, setTimeUnit});
                result = this.endpoint.getResolvedRaftHandle().set(body, setOffset, setLength, setTimeout, setTimeUnit);
            } else if (setOffset != null && setLength != null) {
                LOG.debug("Calling set(byte[] {}, int {}, int {}) method on raftHandle.", new Object[]{body, setOffset, setLength});
                result = this.endpoint.getResolvedRaftHandle().set(body, setOffset, setLength);
            } else {
                LOG.debug("Calling set(byte[] {}, int {}, int {} (i.e. body.length)) method on raftHandle.", new Object[]{body, 0, body.length});
                result = this.endpoint.getResolvedRaftHandle().set(body, 0, body.length);
            }
            this.endpoint.populateJGroupsRaftHeaders(exchange);
            exchange.getIn().setBody(result);
        } else {
            LOG.debug("Body is null, cannot call set method on raftHandle.");
        }
    }
}

