/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.nio.ByteBuffer;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.Message;
import org.jgroups.protocols.raft.AppendEntriesResponse;
import org.jgroups.protocols.raft.AppendResult;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.RaftImpl;
import org.jgroups.raft.StateMachine;
import org.jgroups.stack.Protocol;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.Util;

public class Follower
extends RaftImpl {
    public Follower(RAFT raft) {
        super(raft);
    }

    @Override
    public void handleInstallSnapshotRequest(Message msg, Address leader, long last_included_index, long last_included_term) {
        StateMachine sm = this.raft.state_machine;
        if (sm == null) {
            this.raft.getLog().error("%s: no state machine set, cannot install snapshot", this.raft.getAddress());
            return;
        }
        Address sender = msg.src();
        try {
            ByteBuffer sn = ByteBuffer.wrap(msg.getArray(), msg.getOffset(), msg.getLength());
            this.raft.log().setSnapshot(sn);
            ByteArrayDataInputStream in = new ByteArrayDataInputStream(msg.getArray(), msg.getOffset(), msg.getLength());
            this.raft.internal_state.readFrom(in);
            sm.readContentFrom(in);
            Log log = this.raft.log();
            LogEntry le = new LogEntry(last_included_term, null);
            log.reinitializeTo(last_included_index, le);
            this.raft.commit_index = this.raft.last_appended = last_included_index;
            this.raft.getLog().debug("%s: applied snapshot (%s) from %s; last_appended=%d, commit_index=%d", this.raft.getAddress(), Util.printBytes(msg.getLength()), msg.src(), this.raft.lastAppended(), this.raft.commitIndex());
            ++this.raft.num_snapshot_received;
            AppendResult result = new AppendResult(AppendResult.Result.OK, last_included_index).commitIndex(this.raft.commitIndex());
            Message ack = new EmptyMessage(leader).putHeader(this.raft.getId(), new AppendEntriesResponse(this.raft.currentTerm(), result));
            ((Protocol)this.raft.getDownProtocol()).down(ack);
        }
        catch (Exception ex) {
            this.raft.getLog().error("%s: failed applying snapshot from %s: %s", this.raft.getAddress(), sender, ex);
        }
    }
}

