/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.util.Bits;
import org.jgroups.util.SizeStreamable;

public class LogEntries
implements SizeStreamable,
Iterable<LogEntry> {
    protected ArrayList<LogEntry> entries;

    public LogEntries add(LogEntry ... log_entries) {
        if (this.entries == null) {
            this.entries = new ArrayList(log_entries.length);
        } else {
            this.entries.ensureCapacity(log_entries.length);
        }
        for (LogEntry le : log_entries) {
            this.entries.add(Objects.requireNonNull(le));
        }
        return this;
    }

    public static LogEntries create(LogEntry ... entries) {
        return new LogEntries().add(entries);
    }

    public LogEntries clear() {
        if (this.entries != null) {
            this.entries.clear();
        }
        return this;
    }

    @Override
    public Iterator<LogEntry> iterator() {
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        return this.entries.iterator();
    }

    public int size() {
        return this.entries != null ? this.entries.size() : 0;
    }

    public LogEntry[] toArray() {
        if (this.entries == null) {
            return new LogEntry[0];
        }
        LogEntry[] ret = new LogEntry[this.size()];
        int index = 0;
        for (LogEntry le : this.entries) {
            ret[index++] = le;
        }
        return ret;
    }

    public long totalSize() {
        ArrayList<LogEntry> tmp = this.entries;
        if (tmp == null) {
            return 0L;
        }
        long length = 0L;
        int size = tmp.size();
        for (int i = 0; i < size; ++i) {
            LogEntry entry = tmp.get(i);
            if (entry == null) continue;
            length += (long)entry.length;
        }
        return length;
    }

    @Override
    public int serializedSize() {
        int size = this.size();
        int retval = Bits.size(size);
        if (size > 0) {
            for (LogEntry le : this.entries) {
                retval += le.serializedSize();
            }
        }
        return retval;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        int size = this.size();
        Bits.writeIntCompressed(size, out);
        if (size > 0) {
            for (LogEntry le : this.entries) {
                le.writeTo(out);
            }
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        int size = Bits.readIntCompressed(in);
        if (size > 0) {
            this.entries = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                LogEntry le = new LogEntry();
                le.readFrom(in);
                this.entries.add(le);
            }
        }
    }

    public String toString() {
        return String.format("%d entries", this.size());
    }
}

