/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.protocols.raft.RaftHeader;
import org.jgroups.util.Bits;
import org.jgroups.util.Util;

public class AppendEntriesRequest
extends RaftHeader {
    protected Address leader;
    protected long entry_term;
    protected long prev_log_index;
    protected long prev_log_term;
    protected long leader_commit;

    public AppendEntriesRequest() {
    }

    public AppendEntriesRequest(Address leader, long current_term, long prev_log_index, long prev_log_term, long entry_term, long leader_commit) {
        super(current_term);
        this.leader = leader;
        this.entry_term = entry_term;
        this.prev_log_index = prev_log_index;
        this.prev_log_term = prev_log_term;
        this.leader_commit = leader_commit;
    }

    @Override
    public short getMagicId() {
        return 2000;
    }

    @Override
    public Supplier<? extends Header> create() {
        return AppendEntriesRequest::new;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + Util.size(this.leader) + Bits.size(this.entry_term) + Bits.size(this.prev_log_index) + Bits.size(this.prev_log_term) + Bits.size(this.leader_commit);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Util.writeAddress(this.leader, out);
        Bits.writeLongCompressed(this.entry_term, out);
        Bits.writeLongCompressed(this.prev_log_index, out);
        Bits.writeLongCompressed(this.prev_log_term, out);
        Bits.writeLongCompressed(this.leader_commit, out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        super.readFrom(in);
        this.leader = Util.readAddress(in);
        this.entry_term = Bits.readLongCompressed(in);
        this.prev_log_index = Bits.readLongCompressed(in);
        this.prev_log_term = Bits.readLongCompressed(in);
        this.leader_commit = Bits.readLongCompressed(in);
    }

    @Override
    public String toString() {
        return String.format("%s, leader=%s, entry_term=%d, prev_log_index=%d, prev_log_term=%d, leader_commit=%d", super.toString(), this.leader, this.entry_term, this.prev_log_index, this.prev_log_term, this.leader_commit);
    }
}

