/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.util.Bits;
import org.jgroups.util.Streamable;

public class InternalCommand
implements Streamable {
    protected Type type;
    protected String name;

    public InternalCommand() {
    }

    public InternalCommand(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public Type type() {
        return this.type;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.type.ordinal());
        Bits.writeString(this.name, out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        this.type = Type.values()[in.readByte()];
        this.name = Bits.readString(in);
    }

    public Object execute(RAFT raft) throws Exception {
        switch (this.type.ordinal()) {
            case 0: {
                raft._addServer(this.name);
                break;
            }
            case 1: {
                raft._removeServer(this.name);
            }
        }
        return null;
    }

    public String toString() {
        return String.valueOf((Object)this.type) + (String)(this.type == Type.noop ? "" : "(" + this.name + ")");
    }

    public static enum Type {
        addServer,
        removeServer,
        noop;

    }
}

