/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.testfwk;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Lifecycle;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.raft.ELECTION;
import org.jgroups.protocols.raft.ELECTION2;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.election.BaseElection;
import org.jgroups.raft.Options;
import org.jgroups.raft.Settable;
import org.jgroups.raft.testfwk.MockRaftCluster;
import org.jgroups.raft.testfwk.RaftCluster;
import org.jgroups.stack.Protocol;

public class RaftNode
extends Protocol
implements Lifecycle,
Settable,
Closeable {
    protected final Protocol[] prots;
    protected final RAFT raft;
    protected final BaseElection election;
    protected final MockRaftCluster cluster;

    public RaftNode(MockRaftCluster cluster, Protocol[] protocols) {
        this.cluster = cluster;
        this.prots = Objects.requireNonNull(protocols);
        if (protocols.length == 0) {
            throw new IllegalArgumentException("empty protocol list");
        }
        this.raft = this.find(RAFT.class);
        BaseElection e = this.find(ELECTION.class);
        if (e == null) {
            e = this.find(ELECTION2.class);
        }
        this.election = e;
        for (int i = this.prots.length - 1; i >= 0; --i) {
            Protocol below;
            Protocol p = this.prots[i];
            Protocol protocol = below = i - 1 >= 0 ? this.prots[i - 1] : null;
            if (below != null) {
                p.setDownProtocol(below);
                below.setUpProtocol(p);
                continue;
            }
            p.setDownProtocol(this);
        }
    }

    public RaftNode(RaftCluster cluster, RAFT raft) {
        this((MockRaftCluster)cluster, new Protocol[]{raft});
    }

    public Protocol[] protocols() {
        return this.prots;
    }

    @Override
    public Address getAddress() {
        for (Protocol p : this.prots) {
            if (p.getAddress() == null) continue;
            return p.getAddress();
        }
        return null;
    }

    @Override
    public void init() throws Exception {
        for (Protocol p : this.prots) {
            if (p instanceof RAFT && ((RAFT)p).stateMachine() == null) {
                throw new IllegalStateException(String.format("state machine not set in %s", this));
            }
            p.init();
        }
    }

    @Override
    public void start() throws Exception {
        for (Protocol p : this.prots) {
            p.start();
        }
    }

    @Override
    public void stop() {
        for (int i = this.prots.length - 1; i >= 0; --i) {
            this.prots[i].stop();
        }
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    @Override
    public void destroy() {
        for (int i = this.prots.length - 1; i >= 0; --i) {
            this.prots[i].destroy();
        }
    }

    public void handleView(View v) {
        Protocol top;
        if (this.prots != null && this.prots.length > 0 && (top = this.prots[this.prots.length - 1]) != null) {
            top.down(new Event(6, v));
        }
    }

    @Override
    public Object down(Event evt) {
        return null;
    }

    @Override
    public Object down(Message msg) {
        msg.setSrc(this.localAddress());
        this.cluster.send(msg);
        return null;
    }

    @Override
    public Object up(Message msg) {
        this.prots[0].up(msg);
        return null;
    }

    @Override
    public CompletableFuture<byte[]> setAsync(byte[] buf, int offset, int length, Options options) throws Exception {
        return this.raft.setAsync(buf, offset, length, false, options);
    }

    @Override
    public String toString() {
        return Stream.of(this.prots).map(p -> String.format("%s [%s]", p instanceof RAFT ? ((RAFT)p).raftId() : p.getAddress(), p)).collect(Collectors.joining("\n"));
    }

    protected <T extends Protocol> T find(Class<T> cl) {
        for (Protocol p : this.prots) {
            if (!p.getClass().isAssignableFrom(cl)) continue;
            return (T)p;
        }
        return null;
    }

    protected Address localAddress() {
        if (this.local_addr != null) {
            return this.local_addr;
        }
        for (int i = this.prots.length - 1; i >= 0; --i) {
            this.local_addr = this.prots[i].getAddress();
            if (this.local_addr == null) continue;
            return this.local_addr;
        }
        return this.local_addr;
    }

    public RAFT raft() {
        return this.raft;
    }

    public BaseElection election() {
        return this.election;
    }
}

